AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueviewer","com.atlassian.jira.jira-issue-nav-components:issueviewer-test"],function(){require(["jira/components/libs/underscore","jira/components/issueviewer/legacy/asyncdata","jquery"],function(a,c,b){module("jira/components/issueviewer/legacy/asyncdata",{setup:function(){this.asyncData=new c()},disableCache:function(){this.asyncData=new c({disableCache:true})},setTestData:function(){this.asyncData.setMultiple({1:{value:"a"},2:{value:"b"},3:{value:"c"},4:{value:"d"},5:{value:"e"}})},overrideFetchSimple:function(){this.asyncData.fetch=function(d){return new b.Deferred().resolve(d+"-fetched").promise()}},overrideFetchManual:function(){var d=[];this.asyncData.fetch=function(){var e=new b.Deferred();e.abort=function(){e.reject()};sinon.spy(e,"abort");d.push(e);return e};return d},initChangeSpy:function(){if(this.changeSpy){this.changeSpy.reset()}else{this.changeSpy=sinon.spy();this.asyncData.on("change",this.changeSpy)}}});test("get() without fetch()",function(){expect(2);this.setTestData();this.asyncData.get(1).done(function(d,e){equal(d,"a","Correct value");ok(!e.error,"No error")})});test("get() uncached value with default fetch()",function(){expect(2);this.asyncData.get(1).fail(function(d,e){equal(d,undefined,"value is undefined");equal(e.error,true,"error flag is set")})});test("get() with fetch()",function(){expect(2);this.overrideFetchSimple();this.asyncData.get(1).done(function(d,e){equal(d,"1-fetched","Correct value");ok(!e.error,"No error")})});test("get() with a mix of cached and fetched data",function(){expect(4);this.setTestData();this.overrideFetchSimple();this.asyncData.get(5).done(function(d,e){equal(d,"e","Correct cached value");ok(!e.error,"No error")});this.asyncData.get(100).done(function(d,e){equal(d,"100-fetched","Correct fetched value");ok(!e.error,"No error")})});test("get() with forceFetch",function(){expect(2);this.setTestData();this.overrideFetchSimple();this.asyncData.get(5,true).done(function(d,e){equal(d,"5-fetched","Correct fetched value");ok(!e.error,"No error")})});test("get() updates cache after fetching",function(){expect(3);this.setTestData();this.overrideFetchSimple();var d=this.asyncData.getMeta(1).updated;this.asyncData.get(1,true).done(a.bind(function(){equal(this.asyncData.getMeta(1).value,"1-fetched","Correct value");ok(!this.asyncData.getMeta(1).error,"No error");ok(this.asyncData.getMeta(1).updated!==d,"Timestamp updated")},this))});test("get() with options passes the options to done handlers",function(){expect(1);this.overrideFetchSimple();this.asyncData.get(1,false,{a:1}).done(function(e,f,d){deepEqual(d,{a:1},"Options is passed")})});test("get(): 'changed' meta property in done handler",function(){this.overrideFetchSimple();this.asyncData.get(1).done(function(d,e){ok(e.changed,"Changed property is set after first request")});this.asyncData.get(1,true).done(function(d,e){ok(!e.changed,"Changed property is not set after second request")})});test("get(): 'fromCache meta property in done handler",function(){this.setTestData();this.asyncData.get(1).done(function(d,e){ok(e.fromCache,"fromCache property is set")});this.asyncData.get(1,true).done(function(d,e){ok(!e.fromCache,"fromCache property is not set")});this.asyncData.get(10).done(function(d,e){ok(!e.fromCache,"fromCache property is not set")})});test("set() to different value",function(){expect(2);this.setTestData();this.asyncData.set(1,"AA");this.asyncData.get(1).done(function(d,e){equal(d,"AA","Correct value");ok(!e.error,"No error")})});test("set() to null value",function(){expect(2);this.setTestData();this.asyncData.set(1,null);this.asyncData.get(1).done(function(d,e){equal(d,null,"Value was set to null");ok(!e.error,"Error flag was not set")})});test("setError()",function(){expect(2);this.setTestData();this.asyncData.setError(1);this.asyncData.get(1).fail(function(d,e){equal(d,"a","Value wasn't changed");ok(e.error,"Error flag was set")})});test("setError() with value",function(){expect(2);this.setTestData();this.asyncData.setError(1,"error message");this.asyncData.get(1).fail(function(d,e){equal(d,"error message","Value was changed");ok(e.error,"Error flag was set")})});test("set an error value to a valid one",function(){var d=this.overrideFetchManual();this.asyncData.get(1);d[0].reject("a");equal(this.asyncData.getMeta(1).value,"a","Error value is set");equal(this.asyncData.getMeta(1).error,true,"Error flag is set");this.asyncData.get(1,true);d[1].resolve("aa");equal(this.asyncData.getMeta(1).value,"aa","Value is set");equal(this.asyncData.getMeta(1).error,false,"Error flag is set to false")});test("set() triggers change event when changing a value",function(){this.setTestData();this.initChangeSpy();this.asyncData.set(2,"a");equal(this.changeSpy.callCount,1,"change event triggered once")});test("set() triggers change event when setting new value",function(){this.setTestData();this.initChangeSpy();this.asyncData.set(100,"Z");equal(this.changeSpy.callCount,1,"change event triggered once")});test("set() triggers change event when setting error",function(){this.setTestData();this.initChangeSpy();this.asyncData.set(1,null);equal(this.changeSpy.callCount,1,"change event triggered once")});test("set() doesn't trigger change event when nothing changed",function(){this.setTestData();this.initChangeSpy();this.asyncData.set(1,"a");equal(this.changeSpy.callCount,0,"change event not triggered")});test("setMultiple triggers only one change event",function(){this.setTestData();this.initChangeSpy();this.asyncData.setMultiple({1:{value:"aa"},2:{value:"bb"},3:{value:"cc"},4:{value:"dd"},5:{value:"ee"},6:{value:"ff"}});equal(this.changeSpy.callCount,1,"change event triggered once")});test("reset()",function(){expect(1);this.setTestData();this.asyncData.reset();this.asyncData.get(1).fail(function(d){equal(d,undefined,"No value after reset")})});test("reset() with initial values",function(){expect(1);this.setTestData();this.asyncData.setMultiple({a:{value:1},b:{value:2}});this.asyncData.get("a").done(function(d){equal(d,1,"Correct value")})});test("reset() triggers only one change event",function(){this.setTestData();this.initChangeSpy();this.asyncData.reset();equal(this.changeSpy.callCount,1,"change event triggered once");this.initChangeSpy();this.asyncData.reset({a:{value:"b"},c:{value:"d"}});equal(this.changeSpy.callCount,1,"change event triggered once")});test("get() triggers change event iff fetched value is different",function(){expect(2);this.setTestData();this.overrideFetchSimple();this.initChangeSpy();this.asyncData.get(1,true).done(a.bind(function(){equal(this.changeSpy.callCount,1,"change event triggered once");this.initChangeSpy();this.asyncData.get(1,true).done(a.bind(function(){equal(this.changeSpy.callCount,0,"Another change event is not triggered")},this))},this))});test("asynchronous get() doesn't modify the cache after a reset()",function(){expect(2);var d=this.overrideFetchManual();this.asyncData.get("SYN").done(a.bind(function(e){equal(e,"ACK","Asynchronous callback receives expected value");ok(a.isEmpty(this.asyncData.getMeta("SYN").value),"Cache is empty")},this));this.asyncData.reset();d[0].resolve("ACK")});test("concurrent get() requests both resolve but only one fetch is performed",function(){expect(6);var e=this.overrideFetchManual();var d=function(h,f,g){equal(f,"ACK",h+": Asynchronous callback receives expected value");ok(!g.error,h+": Make sure error flag is not set")};this.asyncData.get("SYN").done(a.bind(d,this,"First get()"));equal(e.length,1,"A fetch was performed after the first get()");this.asyncData.get("SYN").done(a.bind(d,this,"Second get()"));equal(e.length,1,"Still only one fetch was performed after the second get()");e[0].resolve("ACK")});test("concurrent get() requests abort the initial request on force fetch",function(){expect(5);var e=this.overrideFetchManual();var d=function(h,f,g){equal(f,"ACK",h+": Asynchronous callback receives expected value");ok(!g.error,h+": Make sure error flag is not set")};this.asyncData.get("SYN").done(a.bind(d,this,"First get()"));this.asyncData.get("SYN",true).done(a.bind(d,this,"Second get()"));equal(e[0].abort.callCount,1,"First request is aborted after the second get()");e[1].resolve("ACK")});test("get() works with disableCache",function(){expect(3);this.disableCache();this.overrideFetchSimple();this.asyncData.get(1).done(a.bind(function(d,e){equal(d,"1-fetched","Value in done handler is correct");ok(e.updated,"meta.updated exists in done handler");ok(a.isEmpty(this.asyncData.getMeta(1)),"Cache is empty")},this))});test("set() doesn't modify cache with disableCache",function(){this.disableCache();var d=this.asyncData.set(1,"a");equal(d,true,"set() returns true as if the cache is modified");ok(a.isEmpty(this.asyncData.getMeta(1)),"But cache is still empty")});test("setError() doesn't modify cache with disableCache",function(){this.disableCache();var d=this.asyncData.setError(1,"a");equal(d,true,"set() returns true as if the cache is modified");ok(a.isEmpty(this.asyncData.getMeta(1)),"But cache is still empty")});test("maxCacheSize: 1",function(){this.asyncData=new c({maxCacheSize:1});this.overrideFetchSimple();this.asyncData.get(1);equal(this.asyncData.hasCached(1),true,"First request is added to the empty cache");this.asyncData.get(2);this.asyncData.get(3);equal(a.keys(this.asyncData.data).length,1,"Cache size is limited to 1");equal(this.asyncData.hasCached(1),false,"First request has been removed from the cache");equal(this.asyncData.hasCached(2),false,"Second request has been removed from the cache");equal(this.asyncData.hasCached(3),true,"Third request remains in the cache")});test("maxCacheSize: 2",function(){this.asyncData=new c({maxCacheSize:2});this.overrideFetchSimple();this.asyncData.get(1);equal(this.asyncData.hasCached(1),true,"First request is added to the empty cache");this.asyncData.get(2);this.asyncData.get(3);equal(a.keys(this.asyncData.data).length,2,"Cache size is limited to 2");equal(this.asyncData.hasCached(1),false,"First request has been removed from the cache");equal(this.asyncData.hasCached(2),true,"Second request remains in the cache");equal(this.asyncData.hasCached(3),true,"Third request remains in the cache")});test("maxCacheSize causes the least-recently-accessed item to be removed",function(){this.asyncData=new c({maxCacheSize:2});this.overrideFetchSimple();this.asyncData.get(1);this.asyncData.get(2);this.asyncData.get(1);this.asyncData.get(3);equal(this.asyncData.hasCached(2),false);equal(this.asyncData.hasCached(1),true);equal(this.asyncData.hasCached(3),true)});test("maxCacheSize limits setMultiple()",function(){this.asyncData=new c({maxCacheSize:2});this.asyncData.setMultiple({1:{value:"one"},2:{value:"two"},3:{value:"three"},4:{value:"four"}});equal(a.keys(this.asyncData.data).length,2,"Cache size is limited to 2")});test("maxCacheSize prevents set() from adding data to the cache if it is already full",function(){this.asyncData=new c({maxCacheSize:2});this.overrideFetchSimple();this.asyncData.get(1);this.asyncData.get(2);this.asyncData.set(2,"updated");equal(this.asyncData.getMeta(2).value,"updated","On a full cache, set() can still update cached values");this.asyncData.set(3,"new");equal(this.asyncData.hasCached(3),false,"On a full cache, set() won't add any new values")});test("remove()",function(){this.asyncData.set(1,"a");equal(this.asyncData.hasCached(1),true,"Item added to cache");var d=this.asyncData.remove(1);equal(this.asyncData.hasCached(1),false,"Item is removed from cache");equal(d,true,"remove() returns true to indicate the item was removed")});test("remove() item not in cache",function(){equal(this.asyncData.remove(1),false,"Nothing was changed, so remove() returns false")});test("setPending callbacks called",function(){expect(5);var d=sinon.spy();var g=sinon.spy();var f=new b.Deferred();f.abort=sinon.spy();this.asyncData.setPending(1,f,d,g);var e=new b.Deferred();var h=this.asyncData.setPending(1,e,d,g);h.pipe(function(){ok(f.abort.calledOnce,"Pending task was aborted");ok(d.called,"Done callback called if finished successfully");ok(!g.called,"Failure callback not called if finished successfully")});e.resolve();d=sinon.spy();g=sinon.spy();e=new b.Deferred();h=this.asyncData.setPending(1,e,d,g);h.pipe(null,function(){ok(!d.called,"Done callback not called if not finished successfully");ok(g.called,"Failure callback called if not finished successfully")});e.reject()});test("meta.initialLoad should be true for all get() calls that piggyback onto the same AJAX fetch() call",function(){var d=new b.Deferred();this.asyncData.fetch=function(){return d.promise()};this.asyncData.get("id1").done(function(e,f){ok(f.initialLoad,"meta.initialLoad should be truthy for both concurrent gets that are resolved by the same fetch")});this.asyncData.get("id1").done(function(e,f){ok(f.initialLoad,"meta.initialLoad should be truthy for both concurrent gets that are resolved by the same fetch")});d.resolve("id-fetched");this.asyncData.get("id1").done(function(e,f){ok(!f.initialLoad,"meta.initialLoad should not be true for a value that was just returned from cache")})})})});