AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueviewer", "com.atlassian.jira.jira-issue-nav-components:issueviewer-test"], function() {
    "use strict";

    require([
        "jira/components/issueviewer/entities/issue"
    ], function(
        IssueModel
    ) {

        module('jira/components/issueviewer/entities/issue', {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
                this.sandbox.useFakeServer();

                this.model = new IssueModel();
            },

            teardown: function() {
                this.sandbox.restore();
            }
        });

        test("It knows if an issue is the current issue", function() {
            var fakeEntityModel = {id: 123};
            this.model.updateFromEntity(fakeEntityModel);
            ok(this.model.isCurrentIssue(123));

            fakeEntityModel = {id: 124};
            this.model.updateFromEntity(fakeEntityModel);
            ok(!this.model.isCurrentIssue(123));
        });

        test("It stores the project key if present", function() {
            this.model.updateFromEntity({
                project: {
                    key: "TEST"
                }
            });

            equal(this.model.get('projectKey'), 'TEST');
        });

        test("It stores null as the project key if it wasn't present", function() {
            this.model.updateFromEntity({});
            strictEqual(this.model.get('projectKey'), null);
        });

        test("It stores the project type if present", function() {
            this.model.updateFromEntity({
                project: {
                    projectType: "software"
                }
            });

            equal(this.model.get('projectType'), 'software');
        });

        test("It stores null as the project type if it wasn't present", function() {
            this.model.updateFromEntity({});
            strictEqual(this.model.get('projectType'), null);
        });

        test("It stores the project id if present", function() {
            this.model.updateFromEntity({
                project: {
                    id: 1000
                }
            });

            equal(this.model.get('projectId'), 1000);
        });

        test("It stores null as the project id if it wasn't present", function() {
            this.model.updateFromEntity({});
            strictEqual(this.model.get('projectId'), null);
        });

        test("It generates the info of the issue", function() {
            this.model.updateFromEntity({
                id: 1,
                key: 'TEST-1',
                project: {
                    id: 2,
                    key: 'TEST',
                    projectType: 'software'
                }
            });

            deepEqual(this.model.getIssueInfo(), {
                issueId: 1,
                issueKey: 'TEST-1',
                projectId: 2,
                projectKey: 'TEST',
                projectType: 'software'
            });
        });
    });
});
