AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueviewer", "com.atlassian.jira.jira-issue-nav-components:issueviewer-test"], function() {
    "use strict";

    require([
        "jira/components/issueviewer/controllers/error",
        "jquery"
    ], function(
        ErrorController,
        jQuery
    ) {
        module('jira/components/issueviewer/controllers/error', {
            setup: function() {
                this.sandbox = sinon.sandbox.create();

                this.buildErrorController = function(ErrorController) {
                    return new ErrorController({
                        contextPath: "jira/",
                        showReturnToSearchOnError: function() {
                            return false;
                        }
                    });
                };

                this.controller = this.buildErrorController(ErrorController);
            },

            teardown: function() {
                this.sandbox.restore();
            }
        });

        test("When rendering an error, it fires the 'render' event and provides a list of regions", function() {
            var spy = this.sandbox.spy();
            this.controller.on("render", spy);

            this.controller.render("forbidden");

            ok(spy.calledOnce, "It fires a 'render' event");
            equal(typeof spy.firstCall.args[0], "object", "It includes a list of regions as the first argument");

            ok(spy.firstCall.args[0].pager, "It includes a reference to the 'pager' element");
        });

        test("When rendering an error from AJAX, it provides that information in the options argument", function() {
            var spy = this.sandbox.spy();
            this.controller.on("render", spy);

            this.controller.render("forbidden");

            equal(spy.firstCall.args[1].loadedFromDom, false, "loadedFromDom is false");
        });

        test("When rendering an error from DOM, it provides that information in the options argument", function() {
            var spy = this.sandbox.spy();
            this.controller.on("render", spy);

            this.controller.applyToDom("forbidden");

            equal(spy.firstCall.args[1].loadedFromDom, true, "loadedFromDom is true");
        });

        test("When rendering a 'generic' error, it displays the correct fancy error", function() {
            var $el = jQuery("<div>");
            this.controller.setElement($el);
            this.controller.render("generic");

            equal($el.find('.issue-error').length, 1, "Fancy error is shown");
            equal($el.find('.error-image-genericError').length, 1, "Error has correct image");
            equal($el.find('#issue-error-reload-button').length, 1, "Reload button is present");
        });

        test("When clicking the 'reload button' on a 'generic' error, it reloads the page", function() {
            var moduleMocks = AJS.test.mockableModuleContext();
            var stubbedBrowser = {locationReload: sinon.stub()};
            moduleMocks.mock("jira/components/util/browser", stubbedBrowser);
            var customController = this.buildErrorController(moduleMocks.require("jira/components/issueviewer/controllers/error"));

            var $el = jQuery("<div>");
            customController.setElement($el);
            customController.render("generic");

            var $reloadButton = $el.find('#issue-error-reload-button');
            $reloadButton.trigger("click");

            ok(stubbedBrowser.locationReload.calledOnce, "Page reload requested");
        });


        test("When rendering a 'not found' error, it displays the correct fancy error", function() {
            var $el = jQuery("<div>");
            this.controller.setElement($el);
            this.controller.render("notfound");

            equal($el.find('.issue-error').length, 1, "Fancy error is shown");
            equal($el.find('.error-image-canNotBeViewed').length, 1, "Error has correct image");
        });
    });
});
