define("jira/components/issueviewer/analytics/issueopsbar", ['require'], function (require) {
    "use strict";

    var _ = require('jira/components/libs/underscore');
    var $ = require('jquery');
    var AnalyticsUtils = require('jira/viewissue/analytics-utils');
    var AJSHelper = require("jira/components/utils/ajshelper");

    var Analytics = function (opsbarView) {
        this.issueId = opsbarView.model.get('id');
        this.$el = opsbarView.$el;

        this.bindEventsToOpsbar();
    };

    Analytics.prototype.triggerEvent = function (data) {
        AJSHelper.trigger('analyticsEvent', {
            name: "kickass.opsbar.operation",
            data: data
        });
    };

    Analytics.prototype._getParamsButtonMain = function (event, $link, idx) {
        return _.extend(this._getParamsCommon(event), {
            issueId: this.issueId,
            id: $link.attr('id'),
            idx: idx
        });
    };

    Analytics.prototype._getParamsButtonSubmenu = function (event, $sublink, subIdx, $parentLink, parentIdx) {
        return _.extend(this._getParamsCommon(event), {
            issueId: this.issueId,
            id: $sublink.attr('id'),
            idx: subIdx,
            parentId: $parentLink.attr('id'),
            parentIdx: parentIdx
        });
    };

    Analytics.prototype._getParamsCommon = function () {
        return {
            context: AnalyticsUtils.context()
        };
    };

    Analytics.prototype.bindEventsToOpsbar = function () {
        var links = this.$el.find('div.ops-menus li.toolbar-item');

        links.each(function (i, li) {
            var $li = $(li);

            if ($li.hasClass('toolbar-dropdown')) {
                var $linkTrigger = $li.find('a.toolbar-trigger');
                $linkTrigger.click(function (e) {
                    this.triggerEvent(this._getParamsButtonMain(e, $linkTrigger, i));
                }.bind(this));

                var $submenuLinks = $li.find('.aui-list a');
                $submenuLinks.each(function (j, sublink) {
                    var $sublink = $(sublink);
                    $sublink.click(function (e) {
                        this.triggerEvent(this._getParamsButtonSubmenu(e, $sublink, j, $linkTrigger, i));
                    }.bind(this));
                }.bind(this));
            } else {
                var $link = $li.find('a');
                $link.click(function (e) {
                    this.triggerEvent(this._getParamsButtonMain(e, $link, i));
                }.bind(this));
            }
        }.bind(this));
    };

    return Analytics;
});
