AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueviewer","com.atlassian.jira.jira-issue-nav-components:issueviewer-test"],function(){require(["jquery","jira/message","jira/components/issueviewer","jira/components/issueviewer/services/metadataservice","jira/util/data/meta","jira/util/events","jira/components/issueviewer/eventtypes","wrm/data"],function(i,a,e,b,c,h,d,g){var f=JIRA.Issue.CommentForm;module("jira/components/issueviewer",{setup:function(){this.sandbox=sinon.sandbox.create();this.sandbox.useFakeServer();this.sandbox.stub(a,"showErrorMsg");this.sandbox.stub(g,"claim");this.module=new e();this.newIssue=true;this.meta={duration:123,fromCache:true};this.issueEntity={id:321,key:"HSP-2"}},teardown:function(){this.sandbox.restore()},generateLoadCompleteOptions:function(j){return{duration:undefined,fromCache:undefined,isNewIssue:false,issueId:undefined,issueKey:undefined,issueRefreshedEvent:j,loadReason:undefined}}});test("When setting the container, it updates the container of the internal controllers",function(){this.module.setContainer(i("#qunit-fixture"));ok(this.module.errorController._$el.is(i("#qunit-fixture")),"The ErrorController's element was updated");ok(this.module.issueController.$el.is(i("#qunit-fixture")),"The IssueController's element was updated")});test("When loading a valid issue, it should appropriately set the issue meta data",function(){this.sandbox.stub(b,"addIssueMetadata");this.module.issueLoader.trigger("issueLoaded",{issue:{id:12345,key:"JRA-123"}},{},{issueEntity:{}});ok(b.addIssueMetadata,"Metadata service is called")});test("When having an error loading an issue, it should appropriately remove the issue meta data",function(){this.sandbox.stub(b,"removeIssueMetadata");this.module.issueLoader.trigger("error","generic",{});ok(b.removeIssueMetadata,"Metadata service is called")});test("When loading an issue when comment is dirty, it should show a confirmation",function(){this.sandbox.stub(window,"confirm");var k=i("<form id='issue-comment-add' />").appendTo("#qunit-fixture");var l=i("<textarea id='comment' name='comment'></textarea>").appendTo(k);l.val("I am a dirty dirty field");var j=this.module.loadIssue({id:1,key:"KEY-1"});ok(window.confirm.calledOnce,"Expected dirty form warning to appear");ok(j.isRejected(),"Expected deferred to be rejected")});test("When loading an issue when comment is dirty and the user does not allow the dismissal of comment, the comment is focused",function(){this.sandbox.stub(window,"confirm").returns(false);this.sandbox.spy(f,"focus");var k=i("<form id='issue-comment-add' />").appendTo("#qunit-fixture");var l=i("<textarea id='comment' name='comment' />").appendTo(k);l.val("I am a dirty dirty field");var j=this.module.canDismissComment();ok(!j,"Expected not to be able to dismiss comment");ok(f.focus.calledOnce,"Expected comment to be focused")});test("When loading an issue when comment is dirty, the confirm dialog only appears once",function(){this.sandbox.stub(window,"confirm").returns(true);var j=i("<form id='issue-comment-add' />").appendTo("#qunit-fixture");var k=i("<textarea id='comment' name='comment'></textarea>").appendTo(j);k.val("I am a dirty dirty field");this.module.canDismissComment();this.module.canDismissComment();this.module.canDismissComment();ok(window.confirm.calledOnce,"Expected confirm dialog to be called once")});test("When loading an issue when comment is dirty, the confirm dialog appears if cancelled and then invoked again",function(){this.sandbox.stub(window,"confirm").returns(false);var j=i("<form id='issue-comment-add' />").appendTo("#qunit-fixture");var k=i("<textarea id='comment' name='comment'></textarea>").appendTo(j);k.val("I am a dirty dirty field");this.module.canDismissComment();this.module.canDismissComment();ok(window.confirm.calledTwice,"Expected confirm dialog to be called twice")});test("When an issue is updated, the viewIssueQuery is saved",function(){sinon.stub(this.module.viewIssueData,"get").returns(new i.Deferred());var j={attachmentOrder:"DESC"};this.module.model.setId("1");this.module.updateIssueWithQuery(j);ok(this.module.viewIssueData.get.calledOnce,"ViewIssueData.get is called once");deepEqual(this.module.viewIssueData.get.firstCall.args[2].issueEntity.viewIssueQuery,j,"New ViewIssueQuery is passsed to ViewIssueData.get")});test("When an issue is refreshed, update is called with mergeIntoCurrent = true by default.",function(){var j=sinon.spy(this.module.issueLoader,"update");this.module.model.set("id","1");this.module.refreshIssue();ok(j.calledOnce,"update() should have been called once.");equal(j.firstCall.args[0].mergeIntoCurrent,true,"mergeIntoCurrent should equal true.")});test("When an issue is refreshed, update is called with mergeIntoCurrent = false when passed as options",function(){var j=sinon.spy(this.module.issueLoader,"update");this.module.model.set("id","1");this.module.refreshIssue({mergeIntoCurrent:false});ok(j.calledOnce,"update() should have been called once.");equal(j.firstCall.args[0].mergeIntoCurrent,false,"mergeIntoCurrent should equal false.")});test("When a new issue is loaded, the old issue is closed before showing the new one",function(){var k=new e();var l=k.issueLoader;var j=k.issueController;this.sandbox.stub(j,"close");l.trigger("issueLoaded",{issue:{id:12345,key:"JRA-123"}},{},{issueEntity:{}});ok(j.close.calledOnce,"The issue is closed")});test("When a new issue is loaded, the old issue is not closed if the new one is an update",function(){var k=new e();var l=k.issueLoader;var j=k.issueController;this.sandbox.stub(j,"close");l.trigger("issueLoaded",{issue:{id:12345,key:"JRA-123"}},{isUpdate:true,mergeIntoCurrent:true},{issueEntity:{}});ok(!j.close.called,"The issue is not closed")});test("When a new issue is loaded, the old issue is not closed if the new one is a new set of data",function(){var k=new e();var l=k.issueLoader;var j=k.issueController;this.sandbox.stub(j,"close");l.trigger("issueLoaded",{issue:{id:12345,key:"JRA-123"}},{isUpdate:true,mergeIntoCurrent:true},{issueEntity:{}});ok(!j.close.called,"The issue is not closed")});test("Triggers a 'loadError' event on loading an error from the DOM",function(){var k=new e();var j=sinon.spy();k.on("loadError",j);this.sandbox.stub(c,"get").withArgs("serverRenderedViewIssue").returns(true);this.sandbox.stub(c,"set");k.loadIssue({});equal(j.callCount,1,"A loadError event was triggered")});test("Triggers a 'render' event on loading an issue from the DOM",function(){var k=new e();var j=sinon.spy();k.on("render",j);this.sandbox.stub(c,"get").withArgs("serverRenderedViewIssue").returns(true);this.sandbox.stub(c,"set");k.loadIssue({});equal(j.callCount,1,"A render event was triggered")});test("Load project information from WRM when loaded from the DOM",function(){var j=new e();this.sandbox.stub(c,"get").withArgs("serverRenderedViewIssue").returns(true);j.loadIssue({});sinon.assert.calledOnce(g.claim.withArgs("projectId"));sinon.assert.calledOnce(g.claim.withArgs("projectKey"));sinon.assert.calledOnce(g.claim.withArgs("projectType"))});test("When having an error loading an issue, it triggers a JIRA.Event",function(){var k=new e();var j=sinon.spy();h.bind(d.ISSUE_REFRESHED,j);k.issueLoader.trigger("error","generic",{issueId:1234});sinon.assert.calledOnce(j);sinon.assert.calledWith(j,sinon.match.any,1234)});test("When having an error loading an issue with events disabled, it does not trigger a JIRA.Event",function(){var k=new e({useJIRAEvents:false});var j=sinon.spy();h.bind(d.ISSUE_REFRESHED,j);k.issueLoader.trigger("error","generic",{});sinon.assert.notCalled(j)});test("When loading a valid issue, it triggers a JIRA.Event",function(){var k=new e();var j=sinon.spy();h.bind(d.ISSUE_REFRESHED,j);k.issueLoader.trigger("issueLoaded",{issue:{id:12345,key:"JRA-123"}},{},{issueEntity:{id:1234}});sinon.assert.calledOnce(j);sinon.assert.calledWith(j,sinon.match.any,1234)});test("When the IssueController triggers the 'individualPanelRendered' event, it triggers a JIRA.Event",function(){var l=new e();var j=sinon.spy();var k=i("<div/>");h.bind(d.NEW_CONTENT_ADDED,j);l.issueController.trigger("individualPanelRendered",k);sinon.assert.calledOnce(j);sinon.assert.calledWith(j,sinon.match.any,k)});test("When the IssueController triggers the 'individualPanelRendered' event with events disabled, it does not trigger a JIRA.Event",function(){var l=new e({useJIRAEvents:false});var j=sinon.spy();var m=sinon.spy();var k=i("<div/>");h.bind(d.NEW_CONTENT_ADDED,j);l.on("individualPanelRendered",m);l.issueController.trigger("individualPanelRendered",k);sinon.assert.notCalled(j);sinon.assert.calledOnce(m);sinon.assert.calledWith(m,k)});test("When the IssueController triggers the 'panelRendered' event, it triggers a JIRA.Event",function(){var n=new e();var m=sinon.spy();var k="test";var j=i("<div/>");var l=i("<div/>");h.bind(d.PANEL_REFRESHED,m);n.issueController.trigger("panelRendered",k,j,l);sinon.assert.calledOnce(m);sinon.assert.calledWith(m,sinon.match.any,k,j,l)});test("When the IssueController triggers the 'panelRendered' event with events disabled, it does not trigger a JIRA.Event",function(){var n=new e({useJIRAEvents:false});var k=sinon.spy();var o=sinon.spy();var l="test";var j=i("<div/>");var m=i("<div/>");h.bind(d.NEW_CONTENT_ADDED,k);n.on("panelRendered",o);n.issueController.trigger("panelRendered",l,j,m);sinon.assert.notCalled(k);sinon.assert.calledOnce(o);sinon.assert.calledWith(o,l,j,m)});test("When the IssueController triggers the 'renderMainView' event, it triggers two JIRA.Events",function(){var m=new e();m.model.setId("1");var j=i("<div/>");var k=sinon.spy();var l=sinon.spy();h.bind(d.NEW_CONTENT_ADDED,k);h.bind(d.REFRESH_TOGGLE_BLOCKS,l);m.issueController.trigger("renderMainView",j);sinon.assert.calledOnce(k);sinon.assert.calledWith(k,sinon.match.any,j);sinon.assert.calledOnce(l);sinon.assert.calledWith(l,sinon.match.any,"1")});test("When the IssueController triggers the 'renderMainView' event with events disabled, it does not trigger any JIRA.Event",function(){var m=new e({useJIRAEvents:false});m.model.setId("1");var j=i("<div/>");var k=sinon.spy();var l=sinon.spy();var n=sinon.spy();h.bind(d.NEW_CONTENT_ADDED,k);h.bind(d.REFRESH_TOGGLE_BLOCKS,l);m.on("renderMainView",n);m.issueController.trigger("renderMainView",j);sinon.assert.notCalled(k);sinon.assert.notCalled(l);sinon.assert.calledOnce(n);sinon.assert.calledWith(n,j)});test("When focusing the component, it delegates into an internal IssueController",function(){var j=new e({useJIRAEvents:false});this.spy(j.issueController,"focus");j.focus();sinon.assert.calledOnce(j.issueController.focus)});test("It gets the project key of the issue",function(){this.module.issueLoader.trigger("issueLoaded",{issue:{id:12345,key:"JRA-123",project:{id:1000,key:"JRA",projectType:"software",avatarUrls:{}}}},{},{issueEntity:{}});equal(this.module.getProjectKey(),"JRA")});test("It gets the project type of the issue",function(){this.module.issueLoader.trigger("issueLoaded",{issue:{id:12345,key:"JRA-123",project:{id:1000,key:"JRA",projectType:"software",avatarUrls:{}}}},{},{issueEntity:{}});equal(this.module.getProjectType(),"software")});test("It gets the project type id of the issue",function(){this.module.issueLoader.trigger("issueLoaded",{issue:{id:12345,key:"JRA-123",project:{id:1000,key:"JRA",projectType:"software",avatarUrls:{}}}},{},{issueEntity:{}});equal(this.module.getProjectId(),1000)});test("When options.useJIRAEvents===true then triggering loadComplete should inform that ISSUE_REFRESHED event will be generated",function(){this.sandbox.spy(this.module,"trigger");this.module.options={useJIRAEvents:true};this.module.issueLoader.trigger("issueLoaded",{issue:{id:12345,key:"JRA-123"}},{},{issueEntity:{}});sinon.assert.calledWith(this.module.trigger,"loadComplete",this.module.model,this.generateLoadCompleteOptions(true))});test("When options.useJIRAEvents===false then triggering loadComplete should inform that ISSUE_REFRESHED event will not be generated",function(){this.sandbox.spy(this.module,"trigger");this.module.options={useJIRAEvents:false};this.module.issueLoader.trigger("issueLoaded",{issue:{id:12345,key:"JRA-123"}},{},{issueEntity:{}});sinon.assert.calledWith(this.module.trigger,"loadComplete",this.module.model,this.generateLoadCompleteOptions(false))});test("When options.useJIRAEvents is undefined then triggering loadComplete should inform that ISSUE_REFRESHED event will not be generated",function(){this.sandbox.spy(this.module,"trigger");this.module.options={};this.module.issueLoader.trigger("issueLoaded",{issue:{id:12345,key:"JRA-123"}},{},{issueEntity:{}});sinon.assert.calledWith(this.module.trigger,"loadComplete",this.module.model,this.generateLoadCompleteOptions(false))})})});