define("jira/components/analytics/services/trigger", ["require"], function(require) {
    "use strict";

    var MarionetteController = require('jira/components/libs/marionette-1.4.1/controller');
    var AJSHelper = require("jira/components/utils/ajshelper");

    /**
     * @class JIRA.Components.Analytics.Services.Trigger
     *
     * This service is responsible for triggering analytic events. It delegates to AJS.trigger
     *
     * @extends Marionette.Controller
     */
    return MarionetteController.extend({
        /**
         * @constructor
         * @deprecated Nothing to initialise
         */
        initialize: function() {
        },

        /**
         * Triggers an event
         *
         * @param {string} name Name of the event
         * @param {Object} [parameters] Arbitrary data to include in the event
         */
        trigger: function(name, parameters) {
            AJSHelper.trigger('analyticsEvent', {
                name: name,
                data: parameters
            });
        },

        /**
         * Registers an event. This allows this event to be triggered later.
         *
         * @deprecated All events are valid now
         */
        registerEvent: function() {
        }
    });
});
