AJS.test.require("com.atlassian.jira.jira-issue-nav-components:analytics", function() {
    "use strict";

    var triggerInstance;
    var AJSHelper;

    module('jira/components/analytics/services/trigger', {

        setup: function() {
            this.sandbox = sinon.sandbox.create();
            var mockedContext = AJS.test.mockableModuleContext();

            AJSHelper = require('jira/components/utils/ajshelper');
            this.sandbox.spy(AJSHelper, "trigger");
            mockedContext.mock('jira/components/utils/ajshelper', AJSHelper);

            var Trigger = mockedContext.require('jira/components/analytics/services/trigger');
            triggerInstance = new Trigger();
        },

        teardown: function() {
            this.sandbox.restore();
        }
    });

    test("It delegates in AJS.trigger", function() {
        var name = 'aName';
        var data = {};

        triggerInstance.trigger(name, data);

        sinon.assert.calledOnce(AJSHelper.trigger);
        sinon.assert.calledWith(AJSHelper.trigger, sinon.match.any, sinon.match({
            name: name,
            data: data
        }));
    });
});
