AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:analytics-test"], function() {
    "use strict";

    require([
        "jira/components/analytics",
        "jira/components/analytics/appmodule",
        "jira/components/testutils/app-module"
    ], function(
        Analytics,
        AppModule,
        TestUtilsAppModule
    ) {
        var AJSTest = window.AJS.test;

        module('jira/components/analytics/appmodule', {
            setup: function() {
                this.sandbox = sinon.sandbox.create();

                this.moduleMocks = AJSTest.mockableModuleContext();

                this.application = TestUtilsAppModule.startApplication();
                this.Analytics = Analytics;
            },

            createModule: function(application) {
                return TestUtilsAppModule.createAMDModule({
                    sinon: this.sandbox,
                    application: application || this.application,
                    appModuleName: "jira/components/analytics/appmodule",
                    moduleName: "jira/components/analytics"
                });
            },

            stubMethods: function(methods) {
                TestUtilsAppModule.stubMethods({
                    sinon: this.sandbox,
                    methods: methods,
                    moduleClass: Analytics
                });
            },

            teardown: function() {
                this.sandbox.restore();
                this.application.stop();
                delete this.application;
            }
        });

        test("It passes the options to the Analytics appmodule if options.useLog is true", function() {
            this.stub(this, "Analytics");
            this.moduleMocks.mock("jira/components/analytics", this.Analytics);

            var AppModule = this.moduleMocks.require("jira/components/analytics/appmodule");

            var appModule = new AppModule();

            appModule.create({useLog: true});
            equal(this.Analytics.lastCall.args[0].useLog, true, "It passes true as options.useLog to the module");
        });

        test("It passes the options to the Analytics appmodule if options.useLog is false", function() {
            this.stub(this, "Analytics");
            this.moduleMocks.mock("jira/components/analytics", this.Analytics);

            var AppModule = this.moduleMocks.require("jira/components/analytics/appmodule");

            var appModule = new AppModule();

            appModule.create({useLog: false});
            equal(this.Analytics.lastCall.args[0].useLog, false, "It passes false as options.useLog to the module");
        });

        test("It passes the options to the Analytics appmodule if options.useLog is undefined", function() {
            this.stub(this, "Analytics");
            this.moduleMocks.mock("jira/components/analytics", this.Analytics);

            var AppModule = this.moduleMocks.require("jira/components/analytics/appmodule");

            var appModule = new AppModule();

            appModule.create({});
            equal(this.Analytics.lastCall.args[0].useLog, false, "By default, it uses options.useLog = false");
        });

        test("It creates a instance of Analytics", function() {
            var appModule = new AppModule();
            ok(appModule.create() instanceof this.Analytics, "It creates an instance of Analytics");
        });

        test("Commands are registered in the application", function() {
            var commands = [
                "trigger",
                "registerEvent",
                "registerTracker"
            ];

            this.stubMethods(commands);
            TestUtilsAppModule.assertCommands({
                commands: commands,
                commandsNamespace: "analytics",
                application: this.application,
                module: this.createModule()
            });
        });
    });
});
