define("jira/components/issueeditor/views/saveerror", ["require"], function(require){
    "use strict";

    var _ = require("jira/components/libs/underscore");
    var MarionetteItemView = require('jira/components/libs/marionette-1.4.1/itemview');
    var Messages = require('jira/message');
    var Templates = require("jira/components/issueeditor/templates");

    /**
     * A global "saving failed" message.
     */
    return MarionetteItemView.extend({
        events: {
            "simpleClick .issue": "onIssueLinkClick"
        },

        template: Templates.saveErrorMessage,

        /**
         * Extract error messages from the `IssueSaverService` response.
         *
         * @private
         * @returns {string[]} The error messages in `this.options.response`.
         */
        getErrorMessages: function() {
            var errorCollection;
            var errors = [];

            errorCollection = this.options.response.errorCollection;
            if (errorCollection) {
                errors = errorCollection.errorMessages.concat(_.values(errorCollection.errors));
            }

            return errors;
        },

        /**
         * Close the view and trigger an "issueLinkClick" event.
         *
         * @param {jQuery.Event} e A jQuery click event.
         * @private
         */
        onIssueLinkClick: function(e) {
            var options;

            options = {
                id: this.options.issueId,
                key: this.options.issueKey
            };

            e.preventDefault();
            this.trigger("issueLinkClick", options);
            this.close();
        },

        onRender: function() {
            this.setElement(Messages.showErrorMsg(this.$el.html(), {
                closeable: true,
                timeout: 0
            }));
        },

        serializeData: function() {
            return {
                errors: this.getErrorMessages(),
                issueKey: this.options.issueKey
            };
        }
    });
});
