AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueeditor", "com.atlassian.jira.jira-issue-nav-components:issueeditor-test"], function() {
    "use strict";

    require([
        "jquery",
        "jira/components/issueeditor/entities/field",
        "jira/components/issueeditor/views/modalfield",
        "jira/components/issueviewer/legacy/issueeventbus"
    ], function(
        jQuery,
        FieldModel,
        ModalFieldView,
        IssueEventBus
    ) {
        module("jira/components/issueeditor/views/modalfield", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();

                this.fieldModel = new FieldModel({
                    id: "summary",
                    label: "Summary",
                    required: true,
                    editHtml: [
                        '<div class="field-group">',
                        '<label for="summary">Summary<span class="aui-icon icon-required">Required</span></label>',
                        '<input class="text long-field" id="summary"  name="summary" type="text" value="default"/>',
                        '</div>'
                    ].join("\n")
                });
            },

            showDialog: function() {

                var view = this.view = new ModalFieldView({
                    issueEventBus: new IssueEventBus(),
                    model: this.fieldModel,
                    issue: {id: "1000", key: "BULK-15"}
                });

                view.show();

                // Unfortunately, there is no better way to avoid polluting the DOM, as JIRA.Dialog always injects the
                // content into <body>
                var dialog = view._getDialog().$popup;
                dialog.css('position', 'relative');
                jQuery("#qunit-fixture").append(dialog);
            },

            submitDialog: function() {
                this.view._getDialog().$popup.find('input[type=submit]').click();
            },

            teardown: function() {
                this.sandbox.restore();
                if (this.view) {
                    this.view.close();
                }
            }
        });

        test("Saves the IssueFieldModel", function() {
            this.sandbox.stub(this.fieldModel, "save");

            this.showDialog();
            this.submitDialog();

            ok(this.fieldModel.save.calledOnce);
        });
    });
});
