define("jira/components/issueeditor/views/loadingerror", ["require"], function(require){
    "use strict";

    var MarionetteItemView = require('jira/components/libs/marionette-1.4.1/itemview');
    var Messages = require('jira/message');
    var Templates = require("jira/components/issueeditor/templates");

    return MarionetteItemView.extend({
        template: Templates.errorsLoading,

        initialize: function(errorMessages, isTimeout) {
            this.errorMessages = errorMessages;
            this.isTimeout = isTimeout;
        },

        serializeData: function() {
            return {
                errorMessages: this.errorMessages,
                isTimeout: this.isTimeout
            };
        },

        onRender: function() {
            this.setElement(Messages.showErrorMsg(this.$el.html(), {
                closeable: true,
                timeout: 0
            }));
        }
    });
});
