AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueeditor","com.atlassian.jira.jira-issue-nav-components:issueeditor-test"],function(){require(["jira/components/libs/underscore","jquery","jira/components/issueeditor/entities/fields","jira/components/issueeditor/views/field","jira/components/issueviewer/legacy/issueeventbus","jira/util/events","jira/components/issueeditor/eventtypes","jira/components/issueeditor/inlineeditutils","jira/util/events/reasons","jira/ajs/select/multi-select","jira/ajs/select/single-select","jira/components/issueeditor/analytics/viewissue","jira/components/issueviewer/services/darkfeatures"],function(g,n,d,e,b,l,j,h,k,i,c,f,m){var a=AJS.params;module("jira/components/issueeditor/views/field",{setup:function(){this.sandbox=sinon.sandbox.create();a.ignoreFrame=true;this.$el=n("<div class='value editable-field inactive'><a href='#'><span class='link-child'>initial</span><strong class='twixi'></strong></a><span class='overlay-icon aui-iconfont-edit'></span></div>").appendTo("#qunit-fixture");this.collection=new d();this.collection.add({id:"summary",editHtml:'<div class=\'field-group\'><input type="text" name="myinput" value="initial"></div>'});this.model=this.collection.at(0);this.view=new e({issueEventBus:new b(),model:this.model,el:this.$el});this.assertInEditMode=g.bind(function(){equal(this.model.getEditing(),true,"Model says we are editing");ok(this.$el.find("[name=myinput]"),"Input element exists");equal(this.$el.hasClass("inactive"),false,"Inactive class is not present on the element")},this);this.assertInReadMode=g.bind(function(){equal(!!this.model.getEditing(),false,"Model says we are not editing");equal(this.$el.find("span").html(),"initial","Span exists");equal(this.$el.hasClass("inactive"),true,"Inactive class is present on the element")},this)},teardown:function(){this.$el.remove();this.sandbox.restore()},setEditableFieldAnalyticsSpies:function(){this.spy(f,"triggerEditableFieldSingleClick");this.spy(f,"triggerEditableFieldDoubleClick");this.spy(f,"triggerEditableFieldClickPencilIcon")}});test("Readonly mode is default state",function(){this.assertInReadMode()});asyncTest("when readonly view is clicked, we switch to edit",function(){this.$el.click();var o=this;setTimeout(function(){o.assertInEditMode();start()},400)});test("when model is set to editing, so is the view",function(){this.model.edit();this.assertInEditMode()});test("when model is set to editing, inline edit started event is fired",function(){var o=sinon.spy();l.bind(j.INLINE_EDIT_STARTED,o);this.model.edit();equal(o.callCount,1);equal(o.args[0][1],"summary");var p=o.args[0][3].children();equal(p.length,1);ok(p.is(".field-group"))});test("when model is set to editing, inline edit receives multiple elements",function(){this.model.setEditHtml('<input type="text" name="myinput1" ><input type="text" name="myinput2" ><input type="text" name="myinput3" >');var o=sinon.spy();l.bind(j.INLINE_EDIT_STARTED,o);this.model.edit();equal(o.callCount,1);var p=o.args[0][3].children();equal(p.length,3)});test("When cancel event is triggered on collection we switch to readonly mode",function(){this.model.edit();this.collection.cancelEdit();this.assertInReadMode()});test("Update causes params to be updated in model",function(){this.model.edit();this.$el.find(":input").val("My New Val");this.model.update(this.$el);deepEqual(this.model.getParams(),{myinput:"My New Val"})});test("Cancel is triggered either by ESC or via onCancel call",function(){this.model.edit();var o=sinon.spy();this.model.cancelEdit=o;var p=new n.Event("keyup");p.keyCode=50;this.$el.trigger(p);equal(o.callCount,0,"Random keyup shouldn't cancel the edit.");p=new n.Event("keyup");p.keyCode=27;this.$el.trigger(p);equal(o.callCount,1,"ESC should cancel the edit.");this.model.edit({});this.$el.find(".cancel").click();equal(o.callCount,2,"Clicking on cancel should also cancel the edit.")});test("Validation error in model switches view to edit mode",function(){this.model.setValidationError("<input/>","An error occur");equal(this.view.$el.find(":text").length,1,"Expected field to be shown");equal(this.model.getEditing(),true,"Expected model to be in edit mode")});test("Validation error should be appended",function(){this.model.setValidationError('<input/><div class="error">An error occur</div>',"An error occur");equal(this.view.$el.find(".error").length,1,"Expected only on error message");equal(this.view.$el.find(".error").text(),"An error occur")});asyncTest("Clicking on link doesn't enter edit",function(){var p=sinon.spy();var o=this.$el;this.model.edit=p;o.find("span.link-child").click();setTimeout(function(){equal(p.callCount,0,"Expected edit not to be called because we clicked a child of a link");o.find("summary").click();setTimeout(function(){equal(p.callCount,0,"Expected edit not to be called because we clicked a link");o.click();setTimeout(function(){equal(p.callCount,1,"Expected edit to to be called because we DIDN'T click a link");start()},400)},400)},400)});asyncTest("No duplicate INLINE_EDIT_FOCUSED and INLINE_EDIT_BLURRED events are fired",function(){var p=sinon.spy();var q=sinon.spy();var o=h.BLUR_FOCUS_TIMEOUT+1;l.bind(j.INLINE_EDIT_FOCUSED,p);l.bind(j.INLINE_EDIT_BLURRED,q);this.model.edit();var r=this.$el.find("input");r.focus();r.focus();setTimeout(function(){r.blur();setTimeout(function(){r.blur();setTimeout(function(){equal(p.callCount,1,"Only one INLINE_EDIT_FOCUSED event fired");equal(q.callCount,1,"Only one INLINE_EDIT_BLURRED event fired");start()},o)},o)},0)});test("Clicking on element that prevents default doesn't enter edit",function(){var o=sinon.spy();var p=false;this.model.edit=o;this.$el.click(function(q){p=true;q.preventDefault()});this.$el.find(".twixi").click();ok(p);equal(o.callCount,0,"Expected edit not to be called because we clicked a child of a link")});test("Cancel on blur when clean",function(){var p=sinon.spy();var o=sinon.spy();this.model.cancelEdit=p;this.model.onSave(o);this.model.edit();l.trigger(j.INLINE_EDIT_FOCUSED,["summary"]);l.trigger(j.INLINE_EDIT_BLURRED,["summary"]);equal(p.callCount,1,"Expected cancel to occur since field is clean");equal(o.callCount,0,"Expected save to NOT occur since field is clean")});test("Save on blur when dirty",function(){var p=sinon.spy();var o=sinon.spy();this.model.cancelEdit=p;this.model.onSave(o);this.model.edit();this.$el.find("input").val("dirty");l.trigger(j.INLINE_EDIT_FOCUSED,["summary"]);l.trigger(j.INLINE_EDIT_BLURRED,["summary"]);equal(p.callCount,0,"Expected cancel to NOT occur since field is dirty");equal(o.callCount,1,"Expected save to occur since field is dirty")});test("Blurring twice does not trigger two saves",function(){var p=sinon.spy();var o=sinon.spy();this.model.cancelEdit=p;this.model.onSave(function(){this.handleSaveStarted()});this.model.onSave(o);this.model.edit();this.$el.find("input").val("dirty");l.trigger(j.INLINE_EDIT_FOCUSED,["summary"]);l.trigger(j.INLINE_EDIT_BLURRED,["summary"]);l.trigger(j.INLINE_EDIT_BLURRED,["summary"]);equal(p.callCount,0,"Expected cancel to NOT occur since field is dirty");equal(o.callCount,1,"Expected save to occur only once")});test("Save or cancel is not triggered when save options gain focus",function(){var o=sinon.useFakeTimers();var q=sinon.spy();var p=sinon.spy();this.model.cancelEdit=q;this.model.onSave(p);this.model.edit();this.$el.find("input").val("dirty");this.$el.find("input").focus();this.$el.find("input").blur();this.$el.find(".save-options button:first").focus();o.tick(h.BLUR_FOCUS_TIMEOUT+1);equal(q.callCount,0,"Expected cancel to NOT occur since save options has focus");equal(p.callCount,0,"Expected save to NOT occur since save options has focus");o.restore()});test("Save or cancel is not triggered when an input regains focus from save options",function(){var o=sinon.useFakeTimers();var q=sinon.spy();var p=sinon.spy();this.model.cancelEdit=q;this.model.onSave(p);this.model.edit();this.$el.find("input").val("dirty");this.$el.find(".save-options button:first").focus();this.$el.find(".save-options button:first").blur();this.$el.find("input").focus();o.tick(h.BLUR_FOCUS_TIMEOUT+1);equal(q.callCount,0,"Expected cancel to NOT occur since save options has focus");equal(p.callCount,0,"Expected save to NOT occur since save options has focus");o.restore()});test("reveal is triggered on both edit and focus",function(){var o=sinon.spy();this.$el.bind("reveal",o);this.view.switchToEdit();equal(o.callCount,1);this.view.focus();equal(o.callCount,2)});test("JRA-28241 can prevent submit through event",function(){var p=sinon.spy();var o=sinon.spy();this.model.cancelEdit=p;this.model.onSave(o);this.model.edit();this.$el.find("input").val("dirty");this.$el.find("form").bind("before-submit",function(q){q.preventDefault()});this.$el.find("form").submit();equal(p.callCount,0,"Expected cancel to NOT occur since save options has focus");equal(o.callCount,0,"Expected save to NOT occur since save options has focus")});asyncTest("JRADEV-12018 - Inline edit is not enabled when event is transmitted from within a parent with class uneditable",function(){var p=sinon.spy();var o=this.$el;this.model.edit=p;var q=n("<div class='uneditable'>This is an uneditable div</div>");o.append(q);q.click();setTimeout(function(){equal(p.callCount,0,"Expected edit not to be called because we clicked an uneditable element");start()},400)});test("_handleEditingStarted() should trigger a EventTypes.NEW_CONTENT_ADDED",function(){var o=sinon.spy(l,"trigger");this.view._handleEditingStarted();equal(o.callCount,2,"Two events are triggered");equal(o.firstCall.args[0],j.NEW_CONTENT_ADDED,"Event is EventTypes.NEW_CONTENT_ADDED");equal(typeof o.firstCall.args[1][1],"string","Ensure event has a reason argument");equal(o.firstCall.args[1][1],k.inlineEditStarted,"Event reason is JIRA.CONTENT_ADDED_REASON.inlineEditStarted");equal(o.secondCall.args[0],j.INLINE_EDIT_STARTED,"Second event is EventTypes.INLINE_EDIT_STARTED");o.restore()});test("_handleEditingStarted() should trigger showSuggestions for single selects only",function(){var p=sinon.spy();var r=sinon.spy();var q=n("<select><option>blah</option></select>").bind("showSuggestions",p);var o=n("<select multiple='multiple'><option>blah</option><option>blah2</option></select>").bind("showSuggestions",r);this.view.$el.append(q);this.view.$el.append(o);new i({element:o});new c({element:q});this.view._handleEditingStarted();equal(p.callCount,1,"Expected event to fire for single-selects");equal(r.callCount,0,"Expected event not to fire for multi-selects")});test("editField is triggered on switchToEdit",function(){var o=sinon.spy();this.view.on("editField",o);this.view.switchToEdit();sinon.assert.calledOnce(o);sinon.assert.calledWith(o,sinon.match({fieldId:"summary"}))});test("editFieldCancel is triggered on switchToRead",function(){var o=sinon.spy();this.view.on("editFieldCancel",o);this.view.switchToRead();sinon.assert.calledOnce(o);sinon.assert.calledWith(o,sinon.match({fieldId:"summary"}))});test("analytics event is triggered on single click of editable field",function(){this.setEditableFieldAnalyticsSpies();var o=sinon.useFakeTimers();this.$el.click();o.tick(400);sinon.assert.calledOnce(f.triggerEditableFieldSingleClick);sinon.assert.notCalled(f.triggerEditableFieldDoubleClick);sinon.assert.notCalled(f.triggerEditableFieldClickPencilIcon);o.restore()});test("analytics event is triggered on double click of editable field",function(){this.setEditableFieldAnalyticsSpies();this.$el.click();this.$el.click();sinon.assert.calledOnce(f.triggerEditableFieldDoubleClick);sinon.assert.notCalled(f.triggerEditableFieldSingleClick);sinon.assert.notCalled(f.triggerEditableFieldClickPencilIcon)});test("analytics event is triggered on pencil icon click of editable field",function(){this.setEditableFieldAnalyticsSpies();this.$el.find(".overlay-icon.aui-iconfont-edit").click();sinon.assert.calledOnce(f.triggerEditableFieldClickPencilIcon);sinon.assert.notCalled(f.triggerEditableFieldSingleClick);sinon.assert.notCalled(f.triggerEditableFieldDoubleClick)});test("Should show button bar if flag enabled",function(){this.sandbox.stub(m.RTE_ENABLED,"enabled").returns(true);this.model.setValidationError('<div class="jira-wikifield"><textarea name="myinput"> </textarea><div class="wiki-preview" id="preview-link"> </div></div>',"An error occur");ok(this.$el.find(".save-options").hasClass("show-button-bar"))});test("Should not show button bar if flag not enabled",function(){this.sandbox.stub(m.RTE_ENABLED,"enabled").returns(false);this.model.setValidationError('<div class="jira-wikifield"><textarea name="myinput"> </textarea><div class="wiki-preview" id="preview-link"> </div></div>',"An error occur");ok(!this.$el.find(".save-options").hasClass("show-button-bar"))});test("Should not show button bar if flag enabled but wikifield not present",function(){this.sandbox.stub(m.RTE_ENABLED,"enabled").returns(true);this.model.setValidationError('<div class="jira-field"><textarea name="myinput"> </textarea><div class="wiki-preview" id="preview-link"> </div></div>',"An error occur");ok(!this.$el.find(".save-options").hasClass("show-button-bar"))})})});