AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueeditor","com.atlassian.jira.jira-issue-nav-components:issueeditor-test"],function(){require(["jquery","jira/components/issueeditor/entities/fields","jira/components/issueeditor/entities/field","jira/components/issueviewer/services/darkfeatures"],function(c,b,d,a){module("jira/components/issueeditor/entities/field",{setup:function(){this.sandbox=sinon.sandbox.create();this.$el=c("<div>initial</div>");this.collection=new b();this.model=new d({id:"a",editHtml:'<input type="text" name="myinput" value="initial">'});this.collection.add(this.model)},teardown:function(){this.$el.remove();this.sandbox.restore()}});test("Writes to element correctly",function(){this.model.switchElToEdit(this.$el);equal(this.model.getViewHtml().text(),"initial");equal(this.$el.find("[name=myinput]").length,1)});test("isDirty returns false when not edited",function(){this.model.switchElToEdit(this.$el);this.model.update(this.$el);ok(!this.model.isDirty())});test("isDirty returns true when edited",function(){this.model.switchElToEdit(this.$el);this.$el.find("input").val("changed");this.model.update(this.$el);ok(this.model.isDirty())});test("cancelEdit sets isDirty to false",function(){this.model.switchElToEdit(this.$el);this.$el.find("input").val("changed");this.model.update(this.$el);ok(this.model.isDirty());this.model.cancelEdit();ok(!this.model.isDirty())});test("Only update model if we are in edit mode",function(){var e=sinon.spy();this.model.setParams=e;this.model.update();equal(e.callCount,0,"Expected model not to be updated because we aren't in edit mode");this.model.edit();this.model.update(c('<input type="text" value="foobar"/>'));equal(e.callCount,1,"Expected model to be updated because we are in edit mode")});test("Blurring field saves if dirty",function(){var e=sinon.spy();this.model.setParams({dirtyField:"dsgasd"});this.model.setEditing(true);this.model.save=e;this.model.blurEdit();equal(e.callCount,1)});test("Blurring field cancels if not dirty",function(){var e=sinon.spy();this.model.setEditing(true);this.model.cancelEdit=e;this.model.blurEdit();equal(e.callCount,1)});test("Should show button bar if flag enabled",function(){this.model.set("editHtml",'<div class="jira-wikifield"><textarea name="myinput"> </textarea><div class="wiki-preview" id="preview-link"> </div></div>');this.sandbox.stub(a.RTE_ENABLED,"enabled").returns(true);this.model.switchElToEdit(this.$el);ok(this.$el.find(".save-options").hasClass("show-button-bar"))});test("Should not show button bar if flag not enabled",function(){this.model.set("editHtml",'<div class="jira-wikifield"><textarea name="myinput"> </textarea><div class="wiki-preview" id="preview-link"> </div></div>');this.sandbox.stub(a.RTE_ENABLED,"enabled").returns(false);this.model.switchElToEdit(this.$el);ok(!this.$el.find(".save-options").hasClass("show-button-bar"))});test("Should not show button bar if flag enabled but wikifield not present",function(){this.model.set("editHtml",'<div class="jira-field"><textarea name="myinput"> </textarea><div class="wiki-preview" id="preview-link"> </div></div>');this.sandbox.stub(a.RTE_ENABLED,"enabled").returns(true);this.model.switchElToEdit(this.$el);ok(!this.$el.find(".save-options").hasClass("show-button-bar"))})})});