define("jira/components/inline-issue-create", ['require'], function (require) {
    "use strict";

    var _ = require('jira/components/libs/underscore');
    var Marionette = require('jira/components/libs/marionette-2.1.0');
    var Widget = require('jira/inline-issue-create/widget');
    var Trigger = require('jira/inline-issue-create/views/default-trigger');
    var Bootstrap = require('jira/inline-issue-create/entities/inline-bootstrap');

    return Marionette.Object.extend({
        _buildBootstrap: function(){
            this.bootstrap = new Bootstrap();
            this.listenTo(this.bootstrap, {
                "sync": function() {
                    this.widget.setCurrentJQLs(this.bootstrap.jqls);
                }
            });
        },

        _buildWidget: function() {
            this.widget = new Widget({
                issueTypes: this.bootstrap.issueTypes,
                projects: this.bootstrap.projects
            });
            this.listenTo(this.widget, {
                "issueCreated": function(issue, fields){
                    this.trigger("issueCreated", {
                        issue: issue,
                        fields: fields
                    });
                },
                "activated": function(){
                    this.trigger("activated");
                },
                "deactivated": function(){
                    this.trigger("deactivated");
                }
            });
        },

        _buildTrigger: function() {
            this.widgetTrigger = new Trigger({
                widget: this.widget
            });
            this.listenTo(this.widgetTrigger, {
                "selected": function () {
                    this.activate();
                    this.trigger("inlineIssueCreateOpened");
                }
            });
        },

        initialize: function() {
            this._buildBootstrap();
            this._buildWidget();
            this._buildTrigger();
            this.render();
        },

        setJQL: function(jql) {
            this.bootstrap.setJQLs([jql]);
        },

        render: function() {
            this.widgetTrigger.render();
            this.widget.render();
        },

        show: function(el) {
            this.render();
            el.append(this.widgetTrigger.$el);
            this.widget.attach(el);
        },

        activate: function() {
            if (this.bootstrap.projects.length) {
                var isActivated = this.widget.activate();
                if (isActivated) {
                    this.widget.focus();
                }
            } else {
                this.widget.openCreateIssueDialog();
            }
        },

        activateWithJQL: function(jql) {
            this.bootstrap.jqls = [jql];
            this.bootstrap.fetch({reset: true}).done(_.bind(function() {
                if (this.bootstrap.projects.length) {
                    var isActivated = this.widget.activate();
                    if (isActivated) {
                        this.widget.focus();
                    }
                }
            }, this));
        }
    });
});
