AJS.test.require("com.atlassian.jira.jira-issue-nav-components:detailslayout-test", function () {
    "use strict";

    var ToolsView = require("jira/components/detailslayout/views/tools");

    module("jira/components/detailslayout/controllers/tools", {
        setup: function() {
            this.view = new ToolsView({
                showExpand: true
            });
        },

        getTipsy: function(view) {
            // This hack is horrible, but Tipsy makes a good job in not exposing its internal implementation.
            // If we want to assert things on the Tipsy, we need to spy on its methods.

            // This forces the creation of the tipsy
            this.showTipsy(view);
            view.ui.expand.trigger('hide');

            // Get the Tipsy instance
            return view.ui.expand.data('tipsy');
        },

        showTipsy: function(view) {
            view.ui.expand.trigger('mouseover');
        }
    });

    test("When the view is destroyed, it destroys the tooltip for the Expand button", function() {
        this.view.render();
        var tipsy = this.getTipsy(this.view);
        var onHide = this.spy(tipsy, "hide");

        this.showTipsy(this.view);
        this.view.destroy();

        sinon.assert.calledOnce(onHide);
    });
});
