AJS.test.require("com.atlassian.jira.jira-issue-nav-components:detailslayout-test",function(){require(["jira/components/issuecomponentresolver","jira/components/issueeditor","jira/components/issueviewer","jira/components/detailslayout/controllers/tools","jira/components/detailslayout/views/empty","jira/components/detailslayout/views/loading","jira/components/detailslayout/views/layout","jira/components/detailslayout/views/container","jira/components/search/results","jira/components/simpleissuelist","jira/components/test-utils/marionettemocker","jira/components/test-utils/mockutils","jquery"],function(e,g,f,b,c,i,j,k,l,d,a,h,m){module("jira/components/detailslayout",{setup:function(){this.setupViews();this.sandbox=sinon.sandbox.create();this.tools=a.createEventedMock(sinon,b);this.searchResults=a.createEventedMock(sinon,l);this.simpleIssueList=a.createEventedMock(sinon,d);this.issueComponentResolver=this.sandbox.stub(e);this.issueViewerComponent=a.createEventedMock(sinon,f);this.issueEditorComponent=a.createEventedMock(sinon,g);this.issueComponentResolver.resolve.returns(this.issueEditorComponent.constructor);this.issueEditorComponent.loadIssue.returns(new m.Deferred());this.DetailsLayoutConstructor=h.requireWithMocks("jira/components/detailslayout",{"jira/components/detailslayout/controllers/tools":this.tools.constructor,"jira/components/detailslayout/views/empty":this.emptyView.constructor,"jira/components/detailslayout/views/loading":this.loadingView.constructor,"jira/components/detailslayout/views/layout":this.layoutView.constructor,"jira/components/detailslayout/views/container":this.containerView.constructor,"jira/components/simpleissuelist":this.simpleIssueList.constructor,"jira/components/issuecomponentresolver":this.issueComponentResolver});this.detailsLayout=new this.DetailsLayoutConstructor()},teardown:function(){this.sandbox.restore()},setupViews:function(){this.defaultElement=m("<div></div>");this.emptyView=a.createEventedMock(sinon,c,{$el:this.defaultElement});this.loadingView=a.createEventedMock(sinon,i,{$el:this.defaultElement});this.layoutView=a.createEventedMock(sinon,j,{$el:this.defaultElement});this.containerView=a.createEventedMock(sinon,k,{$el:this.defaultElement})},generateIssueMock:function(){return new Backbone.Model({id:1,entity:{key:"TEST-1",summary:"My issue",status:{name:"ToDo"}},projectId:1000,projectKey:"TEST",projectType:"software"})},resetWithInlineEditingDisabled:function(){this.issueComponentResolver.resolve.returns(this.issueViewerComponent.constructor);this.detailsLayout=new this.DetailsLayoutConstructor()}});test("When SimpleIssueList wants to be refreshed, the layout triggers the 'list:refresh' event",function(){var n=this.spy();this.detailsLayout.on("list:refresh",n);this.simpleIssueList.trigger("refresh");sinon.assert.calledOnce(n)});test("When SimpleIssueList wants to be sorted with a different JQL, the layout triggers the 'list:sort' event",function(){var n=this.spy();this.detailsLayout.on("list:sort",n);this.simpleIssueList.trigger("sort","project IN (DEMO)");sinon.assert.calledOnce(n);sinon.assert.calledWith(n,"project IN (DEMO)")});test("When SimpleIssueList triggers the 'list:select' event, it gets re-triggered",function(){var o=this.spy();this.detailsLayout.on("list:select",o);var n={id:1,key:"DEMO-1"};this.simpleIssueList.trigger("list:select",n);sinon.assert.calledOnce(o,n)});test("When the editor fails to load an issue, it disables the issue in the list",function(){this.issueEditorComponent.trigger("loadError",{issueId:"DEMO-123"});sinon.assert.calledOnce(this.simpleIssueList.disableIssue);sinon.assert.calledWith(this.simpleIssueList.disableIssue,"DEMO-123")});test("Removing an issue removes it from the SimpleIssueList",function(){var n=new m.Deferred();this.simpleIssueList.removeIssue.returns(n.promise());this.detailsLayout.removeIssue(1);sinon.assert.calledOnce(this.simpleIssueList.removeIssue);sinon.assert.calledWith(this.simpleIssueList.removeIssue,1)});test("Removing an issue shows the loading screen",function(){var n=new m.Deferred();this.simpleIssueList.removeIssue.returns(n.promise());this.detailsLayout.removeIssue(1);sinon.assert.calledOnce(this.containerView.showLoading);n.resolve(10);sinon.assert.calledOnce(this.containerView.hideLoading)});test("Removing an issue shows the empty view if it was the last issue",function(){var n=new m.Deferred();this.simpleIssueList.removeIssue.returns(n.promise());this.detailsLayout.removeIssue(1);n.resolve(0);sinon.assert.calledWith(this.containerView.showView,this.emptyView)});test("When it receives a 'before:loadpage' event, it shows the loading view",function(){this.spy(this.detailsLayout,"showLoading");this.detailsLayout.simpleIssueList.trigger("before:loadpage");sinon.assert.called(this.detailsLayout.showLoading)});test("When it receives an 'error:loadpage' event, it hides the loading view",function(){this.spy(this.detailsLayout,"hideLoading");var n={some:"data"};this.detailsLayout.simpleIssueList.trigger("error:loadpage",n);sinon.assert.called(this.detailsLayout.hideLoading)});test("When it receives an 'error:loadpage' event, it retriggers it with the event payload",function(){this.spy(this.detailsLayout,"trigger");var n={some:"data"};this.detailsLayout.simpleIssueList.trigger("error:loadpage",n);sinon.assert.calledWith(this.detailsLayout.trigger,"error:loadpage",n)});test("When it is loaded, it triggers a 'list:render' event",function(){this.spy(this.detailsLayout,"trigger");this.detailsLayout.load(this.searchResults);sinon.assert.calledWith(this.detailsLayout.trigger,"list:render")});test("When an issue is selected, it shows the loading view",function(){this.spy(this.detailsLayout,"showLoading");var n={id:1,get:function(){return"KEY"}};this.detailsLayout.load(this.searchResults);this.searchResults.trigger("select",n);sinon.assert.calledWith(this.detailsLayout.showLoading)});test("It ask SimpleIssueList to use IIC",function(){new this.DetailsLayoutConstructor({displayInlineIssueCreate:true});equal(this.simpleIssueList.constructor.lastCall.args[0].displayInlineIssueCreate,true)});test("When SimpleIssueList triggers the event 'issueCreated' it is re-triggered",function(){var o={};var n=this.spy();this.detailsLayout.on("issueCreated",n);this.simpleIssueList.trigger("issueCreated",o);sinon.assert.calledOnce(n);sinon.assert.calledWith(n,o)});test("It uses the default EmptyView if a custom one is not provided",function(){this.searchResults.isEmptySearch.returns(true);this.detailsLayout.load(this.searchResults);sinon.assert.calledOnce(this.containerView.showView);sinon.assert.calledWith(this.containerView.showView,this.emptyView)});test("It uses the provided EmptyView",function(){var o=a.createEventedMock(sinon,c,{$el:this.defaultElement});var p=this.spy(function(){return o});var n=new this.DetailsLayoutConstructor({emptyViewFactory:p});this.searchResults.isEmptySearch.returns(true);n.load(this.searchResults);sinon.assert.calledOnce(p);sinon.assert.calledOnce(this.containerView.showView);sinon.assert.calledWith(this.containerView.showView,o)});test("When the paginator is used, an event is triggered",function(){this.simpleIssueList.selectNext.returns({current:2,total:2});var n=this.spy();this.detailsLayout.on("pager:next",n);this.tools.trigger("pager:next");sinon.assert.calledOnce(n);sinon.assert.calledWith(n,{current:2,total:2});this.simpleIssueList.selectPrevious.returns({current:1,total:2});var o=this.spy();this.detailsLayout.on("pager:previous",o);this.tools.trigger("pager:previous");sinon.assert.calledOnce(o);sinon.assert.calledWith(o,{current:1,total:2})});test("When the expand button is used, an event is triggered",function(){var n=this.spy();this.detailsLayout.on("expand",n);this.tools.trigger("expand");sinon.assert.calledOnce(n)});test("When the detailsLayout component is destroyed, the internal components are destroyed",function(){this.detailsLayout.destroy();sinon.assert.calledOnce(this.tools.destroy);sinon.assert.calledOnce(this.issueEditorComponent.close);sinon.assert.calledOnce(this.simpleIssueList.destroy)});test("When the editor emits editor:saveSuccess event it should be forwarded",function(){var n=this.spy();this.detailsLayout.on("editor:saveSuccess",n);this.issueEditorComponent.trigger("saveSuccess",{issueId:"123456",savedFieldIds:["fieldId-1"],savedFieldTypes:["fieldType-1"],duration:123});sinon.assert.calledOnce(n);sinon.assert.calledWith(n,{event:"123456",savedFieldIds:["fieldId-1"],savedFieldTypes:["fieldType-1"],duration:123})});test("When the details layout focuses the list, it delegates into SimpleIssueList",function(){this.detailsLayout.focusList();sinon.assert.calledOnce(this.simpleIssueList.focus)});test("When the details layout focuses the editor, it delegates into IssueEditor",function(){this.detailsLayout.focusEditor();sinon.assert.calledOnce(this.issueEditorComponent.focus)});test("When the editor emits the 'individualPanelRendered' event, it should be forwarded",function(){var n=this.spy();var o={data:123};this.detailsLayout.on("individualPanelRendered",n);this.issueEditorComponent.trigger("individualPanelRendered",o);sinon.assert.calledOnce(n);sinon.assert.calledWith(n,o)});test("When the editor emits the 'loadComplete' event and the issue is not from the cache, DetailsLayout emits an 'editorLoaded' event",function(){var n=this.spy();this.detailsLayout.on("editorLoaded",n);this.issueEditorComponent.trigger("loadComplete",this.generateIssueMock(),{});sinon.assert.calledOnce(n);sinon.assert.calledWith(n,{issueKey:"TEST-1",issueId:1,issueEditorOptions:{},projectId:1000,projectKey:"TEST",projectType:"software"})});test("When the editor emits the 'loadComplete' event and the issue is from the cache, DetailsLayout emits an 'editorLoadedFromCache' event",function(){var o=this.spy();this.detailsLayout.on("editorLoadedFromCache",o);var n={loadReason:"issues-cache-refresh"};this.issueEditorComponent.trigger("loadComplete",this.generateIssueMock(),n);sinon.assert.calledOnce(o);sinon.assert.calledWith(o,{issueKey:"TEST-1",issueId:1,issueEditorOptions:n,projectId:1000,projectKey:"TEST",projectType:"software"})});test("When getting the project Id, it delegates into the IssueEditor",function(){this.issueEditorComponent.getProjectId.returns(123);var n=this.detailsLayout.getActiveProjectId();sinon.assert.calledOnce(this.issueEditorComponent.getProjectId);equal(n,123)});test("When getting the project key, it delegates into the IssueEditor",function(){this.issueEditorComponent.getProjectKey.returns("KEY");var n=this.detailsLayout.getActiveProjectKey();sinon.assert.calledOnce(this.issueEditorComponent.getProjectKey);equal(n,"KEY")});test("When getting the project type, it delegates into the IssueEditor",function(){this.issueEditorComponent.getProjectType.returns("software");var n=this.detailsLayout.getActiveProjectType();sinon.assert.calledOnce(this.issueEditorComponent.getProjectType);equal(n,"software")});test("When Inline Editing is enabled, 'hasSavesInProgress' should be delegated to the Issue Component",function(){this.issueEditorComponent.hasSavesInProgress.returns(true);var n=this.detailsLayout.hasSavesInProgress();ok(n);sinon.assert.calledOnce(this.issueEditorComponent.hasSavesInProgress)});test("When Inline Editing is disabled, 'hasSavesInProgress' is always false",function(){this.resetWithInlineEditingDisabled();this.issueEditorComponent.hasSavesInProgress.returns(true);var n=this.detailsLayout.hasSavesInProgress();ok(!n);equal(0,this.issueEditorComponent.hasSavesInProgress.callCount)});test("When Inline Editing is enabled, 'getEditorFields' should be delegated to the Issue Component",function(){this.issueEditorComponent.getFields.returns({data:123});var n=this.detailsLayout.getEditorFields();equal(123,n.data);sinon.assert.calledOnce(this.issueEditorComponent.getFields)});test("When Inline Editing is disabled, 'getEditorFields' returns undefined",function(){this.resetWithInlineEditingDisabled();this.issueEditorComponent.getFields.returns({data:123});var n=this.detailsLayout.getEditorFields();ok(typeof n==="undefined");equal(0,this.issueEditorComponent.getFields.callCount)});test("When Inline Editing is disabled, 'editField' should be delegated to the Issue Component",function(){this.detailsLayout.editField("field");sinon.assert.calledOnce(this.issueEditorComponent.editField);sinon.assert.calledWith(this.issueEditorComponent.editField,"field")});test("When Inline Editing is disabled, 'editField' does nothing",function(){this.resetWithInlineEditingDisabled();this.detailsLayout.editField("field");equal(0,this.issueEditorComponent.editField.callCount)})})});