define('layout/login/login-view',
    [
        'zepto',
        'layout/base/page-view',
        'layout/header/header-view',
        'util/ajax',
        'util/app-data',
        'util/auth',
        'util/events',
        'util/router'
    ],
    function (
        $,
        PageView,
        HeaderView,
        ajaxUtil,
        appData,
        auth,
        events,
        router) {

        var messageDesktopLink = ['<a class="login-desktop-link">', '</a>'];

        var MESSAGES = {
            '401.login.unsuccessful': AJS.I18n.getText('jira.mobile.login.error.unsuccessful'),
            '403.login.captcha.required': AJS.I18n.getText('jira.mobile.login.error.captcha.required', messageDesktopLink[0], messageDesktopLink[1]),
            'default': AJS.I18n.getText('jira.mobile.login.error.unknown', messageDesktopLink[0], messageDesktopLink[1])
        };

        var loginDestination = auth.getLoginDestination();

        return PageView.extend({
            className: 'card login',

            desktopUrl: loginDestination,

            pageTitle: AJS.I18n.getText('jira.mobile.title.log.in'),

            // Prevent this view from sliding left/right for other views
            canSlide: false,

            prevRoute: '',

            events: {
                'submit #form-crowd-login': 'submit'
            },

            initialize: function (options) {
                this.$form = this.$el.find('form');
                this.header = new HeaderView({
                    el: this.$el,
                    showLogo: true
                });
                if (options.prevRoute) {
                    this.prevRoute = options.prevRoute;
                }
                if (appData.getUsername()) {
                    auth.logout({
                        showLoginPage: false
                    });
                }
            },

            render: function () {
                this.$el.empty();
                this.header.render();
                var data = {
                    loginPath: loginDestination,
                    contextPath: appData.get('context-path'),
                    appTitle: appData.get('app-title')
                };
                this.$el.append(AtlassianMobile.Templates.JIRA.layout.loginContent(data));
                this.$form = this.$el.find('form');
                return this;
            },

            onShow: function () {
                $('body').addClass('page-type-indra').addClass('page-type-login');
            },

            onHide: function () {
                $('body').removeClass('page-type-indra').removeClass('page-type-login');
            },

            showMessage: function (type, text) {
                // TODO: Use AUI soy templates
                var $msg = $('#login-message');
                var shouldInsert = false;
                if (!$msg.length) {
                    $msg = $('<div id="login-message"/>');
                    shouldInsert = true;
                }
                $msg
                    .attr('class', '')
                    .addClass('aui-message ' + type)
                    .html('<span class="aui-icon icon-' + type + '"></span>');
                $('<span class="error"/>').html(text).appendTo($msg);
                // Update the desktop login link with username and destination
                var desktopUrl = loginDestination;
                var username = $('#username').val();
                if (username) {
                    desktopUrl += '&os_username=' + encodeURIComponent(username);
                }
                $msg.find('.login-desktop-link').attr('href', desktopUrl);
                if (shouldInsert) {
                    $msg.insertAfter('#login-panel > header');
                }
            },

            submit: function (e) {
                e.preventDefault();
                var $form = this.$form;
                var that = this;
                this.showLoading();
                ajaxUtil.ajax({
                    type: 'POST',
                    data: $form.serialize(),
                    url: '/login',
                    success: function (data, status, xhr) {
                        auth.login(data);
                        var route = that.prevRoute || '';
                        router.navigate(route, {trigger: true});
                    },
                    error: function (xhr, errorType, error, data) {
                        var key = data && data.reasonKey;
                        var msg;
                        if (key) {
                            msg = MESSAGES[key];
                            xhr.errorHandled = true;
                        }
                        if (!msg) {
                            msg = MESSAGES['default'];
                        }
                        that.showMessage('error', msg);
                    }
                })
            }
        });
    }
);
