define('feature/filters/filter-list-view',
    ['layout/base/page-view', 'layout/header/header-view', 'feature/filters/filter-item-view', 'util/app-data', 'util/events'],
    function (PageView, HeaderView, FilterItemView, appData, events) {

        var FilterListView = PageView.extend({
            className: 'card filter-list-card',

            desktopUrl: appData.get('context-path') + '/secure/ManageFilters.jspa?filterView=favourites',

            pageTitle: function () {
                return '[' + this.title + ']';
            },

            initialize: function (options) {
                this.title = options.title;
                this.childViews = [];
                this.listenTo(this.collection, 'reset', this.render);

                // Initialise the header
                var headerAttributes = {
                    el: this.$el,
                    title: this.title,
                    action: false
                };
                this.header = new HeaderView(headerAttributes);
            },

            render: function () {
                this.$el.empty();
                this.header.render();

                // Render content
                this.$el.append(AtlassianMobile.Templates.JIRA.FilterList.listContainer({
                    title: this.title,
                    filters: this.collection.toJSON()
                }));

                var $list = this.$('.filter-list');
                var filters = this.collection;
                var childViews = [];

                if (!filters.isEmpty()) {
                    filters.each(function (filter) {
                        var view = new FilterItemView({model: filter});
                        childViews.push(view);
                        view.render();
                        $list.append(view.$el);
                    });
                }
                this.childViews.concat(childViews);

                this.$el.append(AtlassianMobile.Templates.JIRA.layout.atlasFooter());
            },

            onClose: function(){
                _.each(this.childViews, function (view){
                    view.close();
                });
            }
        });

        return FilterListView;
    }
);
