define('layout/header/header-view', ['zepto', 'underscore', 'backbone'], function ($, _, Backbone) {
    return Backbone.View.extend({

        loading: null,
        positionListener: null,

        events: {
            'click .back-button': 'backButton',
            'click .header .flyout-button' : 'toggleFlyout',
            'click .loading-cancel': 'cancelLoading'
        },

        initialize: function(options){
            this.title = options.title;
        },

        goBack: function (event) {
            window.history.back();
        },

        toggleFlyout: function(event){
            if (event.defaultPrevented) {
                return;
            }
            event.preventDefault();
            event.stopPropagation();
            var flyout = require('layout/fly-out/main');
            flyout.toggle();
        },

        render: function(){
            var data = {
                title: this.title,
                backText: this.options.backText,
                showLogo: !!this.options.showLogo
            };
            if (this.options.actionsView) {
                data.actionHtml = this.options.actionsView.render().$el.html();
            }

            // This is a header, so prepend to the provided container
            this.$el.prepend(AtlassianMobile.Templates.Common.layout.header(data));
            return this;
        },

        /**
         * Show a small loading spinner in the header, for use with in-page actions
         *
         * @param type "header" or "page" - default "header"
         */
        showLoading: function (type) {
            if (!type) {
                type = 'header';
            }
            var selector = '.' + type + '-loading-indicator';

            var $indicator = this.$(selector);
            $indicator.html(AtlassianMobile.Templates.Common.layout.loading());
            var $overlay;
            if (type === 'page') {
                $overlay = this.$('.mob-overlay.loading').addClass('show');
            }
            var $spinner = $indicator.find('.spinner').spin('small', {
                left: 0,
                top: 'auto'
            });
            var $cancel = $indicator.find('.loading-cancel').removeClass('hidden');
            var $success = $indicator.find('.loading-success');
            this.loading = {
                overlay: $overlay,
                indicator: $indicator,
                cancel: $cancel,
                spinner: $spinner.data('spinner')
            }
            this.success = $success;
            if (type === 'page') {
                this.positionPageSpinner();
                _.defer(function () {
                    $indicator.addClass('show');
                });
                this.positionListener =  _.bind(this.positionPageSpinner, this);
                $(window).on('resize scroll', this.positionListener);
            }
        },

        /**
         * Remove any active loading spinners
         */
        hideLoading: function () {
            if (this.loading) {
                this.loading.spinner.stop();
                this.loading.cancel.hide();
                if (this.loading.overlay) {
                    this.loading.overlay.removeClass('show');
                }
                if (this.positionListener) {
                    $(window).off('resize scroll', this.positionListener);
                    this.resizeListener = null;
                    this.loading.indicator.removeClass('show');
                }
                this.loading = null;
            }
        },

        /**
        * Show the success message then fade away...
        */
        showSuccess: function () {
            var success = this.success;
            success.addClass('show');
            // Hide it in half a second
            setTimeout( function () {
                // Why js animation and not css animation?
                // Because we we want to make this display none by removing the show class after the animation is finished.
                success.animate({
                    opacity: 0
                }, {
                    duration: 213, 
                    easing: 'ease-in-out',
                    complete: function () {
                        success.removeClass('show');
                    }
                });
            }, 1500);
        },

        /**
         * Cancel any AJAX requests that are currently active for the active PageView
         */
        cancelLoading: function () {
            require('util/presenter').cancelLoading();
        },

        /**
         * Make sure a full-page spinner is positioned in the centre of the screen
         */
        positionPageSpinner: function () {
            if (this.loading && this.loading.overlay) {
                var $elem = this.loading.indicator;
                var ew = $elem.width();
                var eh = $elem.height();
                var ww = window.innerWidth;
                var wh = window.innerHeight;
                $elem.css({
                    left: ww / 2 - ew / 2,
                    top: (wh / 2 - eh / 2) + window.scrollY
                });
            }
        },

        backButton: function () {
            window.history.back();
        },

        preventDefault: function (e) {
            e.preventDefault();
        }
    });
});