define('wiki-edit/keymaster-setup', [
    'jquery',
    'wiki-edit/keymaster'
], function($, key) {
    return {
        init: function () {
            // Set-up library handling key bindings to correctly set scopes for wiki editor
            key.filter = function(event) {
                var element = event.target || event.srcElement || false;
                var editor;
                if (element && (' ' + element.className + ' ').indexOf(' wiki-textfield ') > -1) {
                    editor = $(element).data("wikiEditor");
                    if (editor) {
                        key.setScope(editor.id);
                        return true;
                    }
                }
                return false;
            };
        }
    }
});


