AJS.test.require(["com.atlassian.jira.plugins.jira-wiki-editor:wiki-editor-resources"],function(){var f=require("wiki-edit/WikiEnabledTextarea");var d=require("jquery");var a=13;function c(g,i){var h=document.createEvent("Event");h.initEvent(g,true,true);h.keyCode=i;return h}module("WikiEnabledTextarea",{setup:function(){this.el=document.createElement("textarea");this.el.classList.add("wiki-textfield");d(this.el).appendTo("#qunit-fixture");this.wikiEnabledTextarea=new f(this.el)},standardData:function e(){this.el.value="test test test";this.el.selectionStart=5;this.el.selectionEnd=9},triggerKeyPress:function b(g){this.el.dispatchEvent(c("focus"));this.el.dispatchEvent(c("keydown",g));this.el.dispatchEvent(c("keyup",g))}});test("Creating editor for the same element multiple times should return the same instance",function(){var g=new f(this.el);ok(this.wikiEnabledTextarea===g)});test("Should wrap selected text with token",function(){this.standardData();this.wikiEnabledTextarea.bold();equal(this.el.value,"test *test* test");equal(this.el.selectionStart,6);equal(this.el.selectionEnd,10)});test("Should wrap selected text with token using parameter",function(){this.standardData();this.wikiEnabledTextarea.color("green");equal(this.el.value,"test {color:green}test{color} test");equal(this.el.selectionStart,18);equal(this.el.selectionEnd,22)});test("Should insert placeholder when no text is selected",function(){this.el.value="test ";this.el.selectionStart=5;this.el.selectionEnd=5;this.wikiEnabledTextarea.bold();equal(this.el.value,"test *jira.wiki.editor.operation.bold.placeholder*");equal(this.el.selectionStart,6);equal(this.el.selectionEnd,49)});test("Should toggle wrapping selected text with token",function(){this.standardData();this.wikiEnabledTextarea.bold();this.wikiEnabledTextarea.bold();equal(this.el.value,"test test test");equal(this.el.selectionStart,5);equal(this.el.selectionEnd,9)});test("Should prefix line with token",function(){this.standardData();this.wikiEnabledTextarea.h1();equal(this.el.value,"h1. test test test");equal(this.el.selectionStart,9);equal(this.el.selectionEnd,13)});test("Should unprefix line with any of the tokens before prefixing with another",function(){this.standardData();this.wikiEnabledTextarea.h1();this.wikiEnabledTextarea.h2();equal(this.el.value,"h2. test test test");equal(this.el.selectionStart,9);equal(this.el.selectionEnd,13)});test("Should insert token without selecting it",function(){this.standardData();this.wikiEnabledTextarea["(on)"]();equal(this.el.value,"test (on) test");equal(this.el.selectionStart,9);equal(this.el.selectionEnd,9)});test("Should insert token without selecting it using supplied parameter",function(){this.standardData();this.wikiEnabledTextarea["image-attachment"]("text.jpg");equal(this.el.value,"test  !text.jpg|thumbnail!  test");equal(this.el.selectionStart,27);equal(this.el.selectionEnd,27)});test("Should insert image attachment without thumbnail",function(){this.standardData();this.wikiEnabledTextarea["image-attachment-full"]("test.gif");equal(this.el.value,"test  !test.gif!  test");equal(this.el.selectionStart,17);equal(this.el.selectionEnd,17)});test("Should continue list on enter",function(){var g=function g(i){this.el.value=i+"test";var h=this.el.value.length;this.el.selectionStart=h;this.el.selectionEnd=h;this.triggerKeyPress(a);equal(this.el.value,i+"test\n"+i);equal(this.el.selectionStart,h+i.length+1);equal(this.el.selectionEnd,h+i.length+1)}.bind(this);g("* ");g("# ");g("#* ");g("*# ");g("** ");g("*#*#*#*##***##*#*#*#* ")});test("Should stop continuing list on enter when nothing except prefix is present",function(){this.el.value="* test\n* ";this.el.selectionStart=9;this.el.selectionEnd=9;this.triggerKeyPress(a);equal(this.el.value,"* test\n");equal(this.el.selectionStart,7);equal(this.el.selectionEnd,7)});test("Ensure there is a listener for the speech action",function(){equal(typeof this.wikiEnabledTextarea.speech,"function")})});