AJS.test.require(["com.atlassian.jira.plugins.jira-wiki-editor:wiki-editor-resources"], function() {

    var UndoableTextarea = require("wiki-edit/UndoableTextarea");
    var jQuery = require("jquery");

    module("UndoableTextarea", {
        setup: function() {
            var el = document.createElement('textarea');
            var fixtures = document.getElementById('qunit-fixture');
            fixtures.appendChild(el);
            this.undoableTextarea = new UndoableTextarea(el);
            this.el = el;
        },
        standardData: function standardData() {
            this.el.value = "test";
            this.el.selectionStart = 0;
            this.el.selectionEnd = 4;
        },
        standardData2: function standardData() {
            this.el.value = "test test";
            this.el.selectionStart = 5;
            this.el.selectionEnd = 9;
        },
        triggerKeydown: function triggerKeydown(character, ctrl, shift) {
            if (typeof character === "number") {
                character = String.fromCharCode(character);
            }
            for (var i = 0; i < character.length; i++) {
                var e = jQuery.Event("keydown");
                e.keyCode = character.charCodeAt(i);
                if (ctrl) e.ctrlKey = true;
                if (shift) e.shiftKey = true;
                jQuery(this.el).trigger(e);
            }
        }
    });

    test("getValue should return text and selection on the element", function() {
        this.standardData();
        var result = this.undoableTextarea.getValue();

        equal(result.value, "test");
        equal(result.selectionStart, 0);
        equal(result.selectionEnd, 4);
    });

    test("undo should update the value and selection on the element", function() {
        this.standardData();
        this.undoableTextarea.recordHistoryItem();
        this.standardData2();
        this.undoableTextarea.recordHistoryItem();
        this.undoableTextarea.undo();
        var result = this.undoableTextarea.getValue();

        equal(result.value, "test");
        equal(result.selectionStart, 0);
        equal(result.selectionEnd, 4);
    });

    test("redo should update the value and selection on the element", function() {
        this.standardData();
        this.undoableTextarea.recordHistoryItem();
        this.standardData2();
        this.undoableTextarea.recordHistoryItem();
        this.undoableTextarea.undo();
        this.undoableTextarea.undo();
        this.undoableTextarea.redo();
        var result = this.undoableTextarea.getValue();

        equal(result.value, "test");
        equal(result.selectionStart, 0);
        equal(result.selectionEnd, 4);
    });

    test("Should undo on crl+z", function() {
        this.standardData();
        this.undoableTextarea.recordHistoryItem();
        this.standardData2();
        this.undoableTextarea.recordHistoryItem();

        this.triggerKeydown("z", true);

        var result = this.undoableTextarea.getValue();

        equal(result.value, "test");
        equal(result.selectionStart, 0);
        equal(result.selectionEnd, 4);
    });

    test("Should redo on crl+y", function() {
        this.standardData();
        this.undoableTextarea.recordHistoryItem();
        this.standardData2();
        this.undoableTextarea.recordHistoryItem();
        this.undoableTextarea.undo();
        this.undoableTextarea.undo();

        this.triggerKeydown("y", true);

        var result = this.undoableTextarea.getValue();

        equal(result.value, "test");
        equal(result.selectionStart, 0);
        equal(result.selectionEnd, 4);
    });

    test("Should redo on ctrl+shift+z", function() {
        this.standardData();
        this.undoableTextarea.recordHistoryItem();
        this.standardData2();
        this.undoableTextarea.recordHistoryItem();
        this.undoableTextarea.undo();
        this.undoableTextarea.undo();

        this.triggerKeydown("z", true, true);

        var result = this.undoableTextarea.getValue();

        equal(result.value, "test");
        equal(result.selectionStart, 0);
        equal(result.selectionEnd, 4);
    });

});
