AJS.test.require(["com.atlassian.jira.plugins.jira-wiki-editor:wiki-editor-resources"],function(){var a=require("wiki-edit/UndoManager");module("UndoManager",{setup:function(){this.sandbox=sinon.sandbox.create();this.undoManager=new a();this.listeners={undo:sinon.spy(),redo:sinon.spy(),clear:sinon.spy(),push:sinon.spy(),updateCurrent:sinon.spy()};this.undoManager.on(a.EventTypes.UNDO,this.listeners.undo);this.undoManager.on(a.EventTypes.REDO,this.listeners.redo);this.undoManager.on(a.EventTypes.CLEAR,this.listeners.clear);this.undoManager.on(a.EventTypes.PUSH,this.listeners.push);this.undoManager.on(a.EventTypes.UPDATE_CURRENT,this.listeners.updateCurrent)},teardown:function(){this.sandbox.restore()}});test("Shouldn't be able to undo/redo on empty manager",function(){equal(this.undoManager.canUndo(),false,"Can't undo when there is nothing on the stack");equal(this.undoManager.undo(),undefined,"Can't undo when there is nothing on the stack");equal(this.undoManager.canRedo(),false,"Can't redo when there is nothing on the stack");equal(this.undoManager.redo(),undefined,"Can't redo when there is nothing on the stack")});test("Should undo the right value",function(){this.undoManager.push(1);this.undoManager.push(2);this.undoManager.updateCurrent(3);equal(this.undoManager.undo(),2,"Undo returns previously pushed value");this.undoManager.push(3);this.undoManager.updateCurrent(4);equal(this.undoManager.undo(),3,"Undo returns previously pushed value");equal(this.undoManager.undo(),1,"Undo returns previously pushed value");equal(this.undoManager.canUndo(),false,"Stack is empty")});test("Should redo the right value",function(){this.undoManager.push(1);this.undoManager.push(2);this.undoManager.updateCurrent(3);this.undoManager.undo();equal(this.undoManager.redo(),3,"Redo returns previously undone value");this.undoManager.push(3);this.undoManager.updateCurrent(4);this.undoManager.undo();this.undoManager.undo();equal(this.undoManager.redo(),3,"Redo returns previously pushed value");equal(this.undoManager.redo(),4,"Redo returns previously pushed value");equal(this.undoManager.canRedo(),false,"Stack is empty")});test("Should remember up to 1000 last items",function(){for(var b=1;b<=1000;b++){this.undoManager.push(b)}equal(this.undoManager._undoStack.length,1000);this.undoManager.push(1001);equal(this.undoManager._undoStack.length,1000);this.undoManager.push(1002);this.undoManager.push(1003);equal(this.undoManager._undoStack.length,1000)});test("Undo should skip sequences of the same elements and return first that is different",function(){this.undoManager.push(1);this.undoManager.push(2);this.undoManager.push(2);this.undoManager.push(2);equal(this.undoManager.undo(),1)});test("Should trigger event on undo",function(){this.undoManager.push(1);this.undoManager.undo();equal(this.listeners.undo.calledOnce,true)});test("Should not trigger event on undo if stack is empty",function(){this.undoManager.undo();equal(this.listeners.undo.called,false)});test("Should trigger event on redo",function(){this.undoManager.push(1);this.undoManager.undo();this.undoManager.redo();equal(this.listeners.redo.calledOnce,true)});test("Should not trigger event on redo if stack is empty",function(){this.undoManager.redo();equal(this.listeners.redo.called,false)});test("Should trigger events on push",function(){this.undoManager.push(1);equal(this.listeners.push.calledOnce,true);this.undoManager.push(2);equal(this.listeners.push.calledTwice,true)});test("Should trigger events on updateCurrent",function(){this.undoManager.push(1);this.undoManager.updateCurrent(2);equal(this.listeners.updateCurrent.calledOnce,true)});test("Should not trigger events on updateCurrent if content is the same",function(){this.undoManager.push(1);this.undoManager.updateCurrent(1);equal(this.listeners.updateCurrent.called,false)});test("Should trigger events on clear",function(){this.undoManager.clear();equal(this.listeners.clear.calledOnce,true)})});