define('wiki-edit/thumbnails', [
    'wrm/data'
], function (wrmData) {
    var thumbnailsAllowedWrmData = wrmData.claim('com.atlassian.jira.plugins.jira-wiki-editor:wiki-editor-thumbnails.thumbnails-allowed');

    return {
        isThumbnailable: function (fileName, $optionalDataEl) {
            var canUseThumbnails = true;
            // metadata panel should always be present on every issue page, but just to be sure, default to true if not present
            if (thumbnailsAllowedWrmData != null) {
                // jquery should always be giving us back a boolean, as value should only ever be true/false, but just making sure its a boolean
                canUseThumbnails = !!thumbnailsAllowedWrmData;
            }

            if (!canUseThumbnails) {
                return false;
            }

            var thumbnailsAllowed;
            if ($optionalDataEl) {
                thumbnailsAllowed = $optionalDataEl.data("attachment-thumbnail");
            }

            if (thumbnailsAllowed == null) {
                // not exhaustive check, but consistent with other plugins like DnD
                // NB: Gif attachments are rendered without thumbnail (eg: !lolcat.gif!) so they can animate properly
                return Boolean(fileName.match(/\.(jpg|jpeg|pjpeg|png)$/i));
            } else {
                if (thumbnailsAllowed) {
                    // again, while GIF may infact be thumbnailable, we don't want to add that markup, as it prevents the animation
                    return !fileName.match(/\.gif$/i);
                }
                return false;
            }
        }
    };
});

