AJS.test.require(["com.atlassian.jira.plugins.jira-wiki-editor:wiki-editor-thumbnails"], function () {

    var $ = require("jquery");
    var thumbnailsAllowedWrm = "com.atlassian.jira.plugins.jira-wiki-editor:wiki-editor-thumbnails.thumbnails-allowed";

    module("Thumbnails", {
        setup: function () {
            this.context = AJS.test.mockableModuleContext();
            this.sandbox = sinon.sandbox.create();

            this.mockWrmData = {
                claim: this.sandbox.stub()
            };
            this.context.mock("wrm/data", this.mockWrmData);
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("isThumbnailable is not allowed when instance disabled", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(false);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        strictEqual(Thumbnails.isThumbnailable("image.png"), false);
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

    test("isThumbnailable is not allowed when filename not known type and not specified in element", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(true);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        strictEqual(Thumbnails.isThumbnailable("image.bmp"), false);
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

    test("isThumbnailable is not allowed when disabled in element", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(true);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        var html = '<div data-attachment-thumbnail="false" />';
        strictEqual(Thumbnails.isThumbnailable("image.png", $(html)), false);
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

    test("isThumbnailable is allowed when enabled in element", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(true);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        var html = '<div data-attachment-thumbnail="true" />';
        strictEqual(Thumbnails.isThumbnailable("image.BMP", $(html)), true);
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

    test("isThumbnailable is allowed when file type known", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(true);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        strictEqual(Thumbnails.isThumbnailable("image.png"), true);
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

    test("isThumbnailable is allowed when enabled in element as anything truthy", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(true);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        var html = '<div data-attachment-thumbnail="something" />';
        strictEqual(Thumbnails.isThumbnailable("image.bmp", $(html)), true);
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

    test("isThumbnailable is not allowed when enabled in element as anything falsy", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(true);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        var html = '<div data-attachment-thumbnail="" />';
        strictEqual(Thumbnails.isThumbnailable("image.bmp", $(html)), false);
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

    test("isThumbnailable is not allowed when not present in element", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(true);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        var html = '<div data-random="99" />';
        strictEqual(Thumbnails.isThumbnailable("image.bmp", $(html)), false);
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

    test("isThumbnailable is not allowed when not present in element but known file type", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(true);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        var html = '<div data-random="99" />';
        strictEqual(Thumbnails.isThumbnailable("image.jpeg", $(html)), true);
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

    test("isThumbnailable wrmData only claimed once", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(true);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        strictEqual(Thumbnails.isThumbnailable("image.bmp"), false);
        strictEqual(Thumbnails.isThumbnailable("image.jpg"), true);
        var html = '<div data-attachment-thumbnail="true" />';
        strictEqual(Thumbnails.isThumbnailable("image.bmp", $(html)), true);
        // wrm only once
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

    test("isThumbnailable is always false for GIF even if explicitly possible", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(true);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        var html = '<div data-attachment-thumbnail="true" />';
        strictEqual(Thumbnails.isThumbnailable("image.gif", $(html)), false);
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

    test("isThumbnailable is always false for GIF even if explicitly possible and uppercase", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(true);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        var html = '<div data-attachment-thumbnail="true" />';
        strictEqual(Thumbnails.isThumbnailable("IMAGE.GIF", $(html)), false);
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

    test("isThumbnailable is always false for GIF when check filetype and uppercase", function () {
        this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).returns(true);
        var Thumbnails = this.context.require('wiki-edit/thumbnails');
        strictEqual(Thumbnails.isThumbnailable("IMAGE.GIF"), false);
        ok(this.mockWrmData.claim.withArgs(thumbnailsAllowedWrm).calledOnce);
    });

});
