AJS.test.require(["com.atlassian.jira.plugins.jira-wiki-editor:wiki-editor-resources"],function(){var d=require("wiki-edit/TextareaManipulator");module("TextareaManipulator",{setup:function(){var f=document.createElement("textarea");var e=document.getElementById("qunit-fixture");e.appendChild(f);this.manipulator=new d(f);this.el=f},standardData:function c(){this.el.value="test test test";this.el.selectionStart=5;this.el.selectionEnd=9},multilineData:function b(){this.el.value="test1\ntest2\ntest3";this.el.selectionStart=6;this.el.selectionEnd=11}});test("getSelection should return selection set on the element",function(){this.el.value="test element";this.el.selectionStart=5;this.el.selectionEnd=12;var e=this.manipulator.getSelection();equal(e.start,5);equal(e.end,12);equal(e.length,7);equal(e.text,"element")});test("setSelection should set selection on the element",function(){this.el.value="test element";this.manipulator.setSelection(0,4);equal(this.el.selectionStart,0);equal(this.el.selectionEnd,4)});test("setSelection should set cursor on the element when called with one argument",function(){this.el.value="test element";this.manipulator.setSelection(4);equal(this.el.selectionStart,4);equal(this.el.selectionEnd,4)});test("replaceSelectionWith should replace selection with length > 0",function(){this.standardData();this.manipulator.replaceSelectionWith("replace");equal(this.el.value,"test replace test")});test("replaceSelectionWith should insert text in place when selection length == 0",function(){this.el.value="test";this.el.selectionStart=4;this.el.selectionEnd=4;this.manipulator.replaceSelectionWith(" insert");equal(this.el.value,"test insert")});test("replaceSelectionWith should put cursor at the end of inserted/changed text",function(){this.standardData();this.manipulator.replaceSelectionWith("replace");equal(this.el.selectionStart,12);equal(this.el.selectionEnd,12)});test("replaceSelectionWith should select inserted/changed text when said so",function(){this.standardData();this.manipulator.replaceSelectionWith("replace",true);equal(this.el.selectionStart,5);equal(this.el.selectionEnd,12)});test("wrapSelectionWith should assume empty placeholder if none was supplied",function(){this.standardData();this.el.selectionStart=9;this.manipulator.wrapSelectionWith("*","^");equal(this.el.value,"test test*^ test")});test("wrapSelectionWith should assume suffix is the same as prefix if none was supplied",function(){this.standardData();this.manipulator.wrapSelectionWith("*");equal(this.el.value,"test *test* test")});test("wrapSelectionWith should wrap selected text with prefix and suffix",function(){this.standardData();this.manipulator.wrapSelectionWith("*","^");equal(this.el.value,"test *test^ test")});test("wrapSelectionWith should do nothing if text is already wrapped with prefix and suffix",function(){this.el.value="test *test* test";this.el.selectionStart=6;this.el.selectionEnd=10;this.manipulator.wrapSelectionWith("*");equal(this.el.value,"test *test* test")});test("wrapSelectionWith should insert placeholder, if selection length is == 0",function(){this.el.value="test ";this.el.selectionStart=5;this.el.selectionEnd=5;this.manipulator.wrapSelectionWith("*","*","placeholder");equal(this.el.value,"test *placeholder*")});test("wrapSelectionWith should keep original text selected or select placeholder",function(){this.standardData();this.manipulator.wrapSelectionWith("*","^");equal(this.el.selectionStart,6);equal(this.el.selectionEnd,10);this.el.value="test ";this.el.selectionStart=5;this.el.selectionEnd=5;this.manipulator.wrapSelectionWith("*","*","placeholder");equal(this.el.selectionStart,6);equal(this.el.selectionEnd,17)});test("_getSelectedLines should return object with array of strings representing lines in textarea",function(){this.multilineData();var e=this.manipulator._getSelectedLines();equal(e.lines.length,3);deepEqual(e.lines,["test1","test2","test3"])});test("_getSelectedLines should return object with indexes of start and end lines of the selection within textarea",function(){this.multilineData();var e=this.manipulator._getSelectedLines();deepEqual(e.start,1);deepEqual(e.end,1);this.el.selectionStart=3;var e=this.manipulator._getSelectedLines();deepEqual(e.start,0);deepEqual(e.end,1)});test("getLineAtCursor should return the line at which cursor is",function(){this.multilineData();var e=this.manipulator.getLineAtCursor();equal(e,"test2");this.el.selectionStart=2;this.el.selectionEnd=2;var e=this.manipulator.getLineAtCursor();equal(e,"test1")});var a=/^[#\*]+ /;test("getFirstLineMatch should return matched string",function(){this.el.value="test1\n* test2\ntest3";this.el.selectionStart=6;this.el.selectionEnd=13;equal(this.manipulator.getFirstLineMatch(a),"* ")});test("getFirstLineMatch should return undefined when not match is found",function(){this.el.value="test1\ntest2\ntest3";this.el.selectionStart=6;this.el.selectionEnd=11;equal(this.manipulator.getFirstLineMatch(a),undefined)});test("getFirstLineMatch should check only the first line of the selection",function(){this.el.value="test1\ntest2\n* test3";this.el.selectionStart=6;this.el.selectionEnd=11;equal(this.manipulator.getFirstLineMatch(a),undefined)});test("areSelectedLinesPrefixed should return true if any of the selected lines is prefixed with the parameter",function(){this.el.value="test\n* test\n* test\ntest";this.el.selectionStart=3;this.el.selectionEnd=7;ok(this.manipulator.areSelectedLinesPrefixed("* "))});test("areSelectedLinesPrefixed should return false if none of the selected lines is prefixed with the parameter",function(){this.el.value="test\n* test\n* test\ntest";this.el.selectionStart=1;this.el.selectionEnd=1;ok(!this.manipulator.areSelectedLinesPrefixed("* "))});test("prefixSelectedLines should prefix selected lines with parameter",function(){this.el.value="test\ntest";this.el.selectionStart=1;this.el.selectionEnd=8;this.manipulator.prefixSelectedLines("* ");equal(this.el.value,"* test\n* test")});test("prefixSelectedLines should not change lines already prefixed",function(){this.el.value="* test\ntest";this.el.selectionStart=3;this.el.selectionEnd=10;this.manipulator.prefixSelectedLines("* ");equal(this.el.value,"* test\n* test")});test("prefixSelectedLines should keep the selection the same",function(){this.el.value="* test\ntest";this.el.selectionStart=3;this.el.selectionEnd=10;this.manipulator.prefixSelectedLines("* ");equal(this.el.value,"* test\n* test");equal(this.el.selectionStart,3);equal(this.el.selectionEnd,12)});test("unprefixSelectedLines should unprefix selected lines with parameter",function(){this.el.value="* test\n* test";this.el.selectionStart=1;this.el.selectionEnd=8;this.manipulator.unprefixSelectedLines("* ");equal(this.el.value,"test\ntest")});test("unprefixSelectedLines should not change lines already unprefixed",function(){this.el.value="* test\ntest";this.el.selectionStart=3;this.el.selectionEnd=10;this.manipulator.unprefixSelectedLines("* ");equal(this.el.value,"test\ntest")});test("unprefixSelectedLines should keep the selection the same",function(){this.el.value="* test\ntest";this.el.selectionStart=3;this.el.selectionEnd=10;this.manipulator.unprefixSelectedLines("* ");equal(this.el.selectionStart,1);equal(this.el.selectionEnd,8)})});