AJS.test.require(["com.atlassian.jira.plugins.jira-wiki-editor:wiki-editor-resources"], function() {

    var speechRecognition = require("wiki-edit/SpeechRecognition");
    var Meta = require("jira/util/data/meta");

    module("SpeechRecognition", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            var speechAPI = {
                continuous: null,
                interimResults: null,
                lang: null,
                start: function(){},
                stop: function(){}
            };
            this.stubSpeechAPI = this.sandbox.stub(speechAPI);
            var textareaAPI = {
                undoRedoEl: {
                    recordHistoryItem: function(){}
                },
                manipulationEngine: {
                    replaceSelectionWith: function(){},
                    setSelection: function(){}
                },
                $el: {
                    trigger: function(){}
                }
            };
            this.stubTextareaAPI = this.sandbox.stub(textareaAPI);

            // "creates" webkitSpeechRecognition for browsers that do not have this method (Firefox, for example)
            // this is necessary because you cannot stub a method that does not exist. :)
            window.webkitSpeechRecognition = function(){};
            this.sandbox.stub(window, "webkitSpeechRecognition").returns(this.stubSpeechAPI);

            this.sandbox.stub(Meta, "get").returns("es_ES");
        },
        teardown: function() {
            this.sandbox.restore();
        }
    });

    test("Should prepare instance to handle events from the Speech API", function() {
        speechRecognition.start();

        // verify all four event listeners are in place
        equal(typeof this.stubSpeechAPI.onstart, "function");
        equal(typeof this.stubSpeechAPI.onresult, "function");
        equal(typeof this.stubSpeechAPI.onerror, "function");
        equal(typeof this.stubSpeechAPI.onend, "function");
    });

    test("Should set correct lang based on the value Meta returns", function() {
        speechRecognition.start();
        strictEqual(this.stubSpeechAPI.lang, "es-ES", "should have replaced _ with - for es_ES");

        // let's try a different value
        Meta.get.returns("ja_JP");
        speechRecognition.start();
        strictEqual(this.stubSpeechAPI.lang, "ja-JP", "should have replaced _ with - for ja_JP");
    });

    test("Should set appropriate values for continuous and interim results", function() {
        speechRecognition.start();
        strictEqual(this.stubSpeechAPI.continuous, false);
        strictEqual(this.stubSpeechAPI.interimResults, true);
    });

    test("Should stop recognition service when results are marked as final", function() {
        // start is called in order to add events to the speechAPI object
        speechRecognition.start(this.stubTextareaAPI);
        this.stubSpeechAPI.stop.reset();

        var finalResultEvent = {
            results: [
                {
                    0: {transcript: "text here"},
                    isFinal: true
                }
            ]
        };
        this.stubSpeechAPI.onresult(finalResultEvent);
        ok(this.stubSpeechAPI.stop.calledOnce);
    });

    test("Should not stop recognition service when results are not marked as final", function() {
        // start is called in order to add events to the speechAPI object
        speechRecognition.start(this.stubTextareaAPI);
        this.stubSpeechAPI.stop.reset();

        var resultEvent = {
            results: [
                {
                    0: {transcript: "text here"},
                    isFinal: false
                }
            ]
        };
        this.stubSpeechAPI.onresult(resultEvent);
        ok(this.stubSpeechAPI.stop.callCount === 0);
    });

    test("onerror handler should stop recognition service", function() {
        // start is called in order to add events to the speechAPI object
        speechRecognition.start(this.stubTextareaAPI);
        this.stubSpeechAPI.stop.reset();

        this.stubSpeechAPI.onerror({error:""});
        ok(this.stubSpeechAPI.stop.calledOnce);
    });

    test("onend handler should stop recognition service", function() {
        // start is called in order to add events to the speechAPI object
        speechRecognition.start(this.stubTextareaAPI);
        this.stubSpeechAPI.stop.reset();

        this.stubSpeechAPI.onend();
        ok(this.stubSpeechAPI.stop.calledOnce);
    });

    test("Should try to hide flag only if close method is available", function() {
        var flagAPI = {
            close: function(){}
        };
        var stubFlagAPI = this.sandbox.stub(flagAPI);
        speechRecognition.speakFlag = stubFlagAPI;

        speechRecognition.dismissCurrentMessage();
        ok(stubFlagAPI.close.calledOnce);
    })
});
