AJS.test.require(["com.atlassian.jira.plugins.jira-wiki-editor:wiki-editor-resources"], function () {

    var $ = require("jquery");
    var AttachmentListUtil = require('wiki-edit/attachment-list-util');
    var wrmContextPath = require('wrm/context-path');

    module("AttachmentListUtil", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.form = $('<form><input name="formToken" value="formToken"/><div class="upload-progress-bar"><div data-file-id="temporaryAttachmentId"><span class="upload-progress-bar__file-name" data-attachment-type="img/png">test.png</span></div></div></form>');
            this.formWithoutFormToken = $('<form><div class="upload-progress-bar"><div data-file-id="temporaryAttachmentId"><span class="upload-progress-bar__file-name" data-attachment-type="img/png">test.png</span></div></div></form>');

            this.fixture = $("#qunit-fixture");
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("should append item with proper attachment url", function () {
        this.fixture.append(this.form);
        var $attachmentList = $('<div>');
        var $attachmentListContainer = $('<div>');

        AttachmentListUtil.buildAttachmentLinks($attachmentList, $attachmentListContainer, true, true, true);

        var hrefs = $attachmentList.find('a').map(function (idx, el) {
            return $(el).attr('data-attachment-href');
        }).toArray();
        deepEqual(hrefs, [wrmContextPath() + "/secure/temporaryattachment/formToken/temporaryAttachmentId_test.png"]);
    });

    test("should append item with proper attachment url for form without form token", function () {
        this.fixture.append(this.formWithoutFormToken);
        var $attachmentList = $('<div>');
        var $attachmentListContainer = $('<div>');

        AttachmentListUtil.buildAttachmentLinks($attachmentList, $attachmentListContainer, true, true, true);

        var hrefs = $attachmentList.find('a').map(function (idx, el) {
            return $(el).attr('data-attachment-href');
        }).toArray();
        deepEqual(hrefs, [wrmContextPath() + "/secure/temporaryattachment/undefined/temporaryAttachmentId_test.png"]);
    });
});
