define('wiki-edit/analytics', ['jira/analytics'], function(analytics) {

    function triggerEvent(name, props) {
        analytics.send({ name: 'jira.wikieditor.'+name, data: props || {} });
    }

    function hashCode (string) {
        var charCode;
        var hash = 0;
        if (!string) {
            return "";
        }

        for (var i = 0; i < string.length; i += 1) {
            charCode = string.charCodeAt(i);
            hash = ((hash * 32) - hash) + charCode;
            hash |= 0; // force 32-bit representation
        }

        return hash;
    }

    return {
        trigger: triggerEvent,
        hashCode: hashCode
    };
});
