/*globals GH*/
define('jira/inline-issue-create/agile/entities/issue-types', [
    'jira/inline-issue-create/lib/underscore',
    'jira/inline-issue-create/entities/issue-types',
    'jira-agile/rapid/ui/plan/plan-controller'
], function (
    _,
    IssueTypeCollection,
    AgilePlanController
) {
    "use strict";

    var AgileIssueTypeCollection = IssueTypeCollection.extend({
        parse: function parse(resp) {
            var values = IssueTypeCollection.prototype.parse.apply(this, arguments);
            return this.filterOutGHEpics(values);
        },
        reset: function reset(values) {
            var issueTypes = this.filterOutGHEpics(values);
            return IssueTypeCollection.prototype.reset.apply(this, [issueTypes]);
        },
        filterOutGHEpics : function filterOutGHEpics(issueTypes) {
            var epicId = GH.EpicConfig.getEpicIssueTypeId();
            if (issueTypes && epicId && epicsAsPanelEnabled()) {
                return _.filter(issueTypes, function (e) {
                    return e.id !== epicId;
                });
            }
            return issueTypes;
        }
    });

    function epicsAsPanelEnabled() {
        return AgilePlanController.isEpicsPanelEnabled();
    }

    return AgileIssueTypeCollection;
});
