define('jira/inline-issue-create/views/issue-type-dropdown-item', [
    'jira/inline-issue-create/lib/marionette'
], function (
    Marionette
) {
    "use strict";

    var ItemView = Marionette.ItemView.extend({
        template: JIRA.Templates.InlineIssueCreate.issueTypeSelectorItem,
        initialize: function initialize(options) {
            this.dropdownModel = options.dropdownModel;
        },
        events: {
            "click a": function onClick(e) {
                this.trigger("selected");
            }
        },
        onRender: function onRender() {
            this.unwrapTemplate();
        }
    });

    return ItemView;
});
