define('jira/inline-issue-create/widget-group', [
    'jira/inline-issue-create/lib/underscore',
    'jira/inline-issue-create/lib/marionette',
    'jira/inline-issue-create/widget',
    'jira/inline-issue-create/entities/inline-bootstrap'
], function WidgetGroup(
    _,
    Marionette,
    IicWidget,
    InlineBootstrap
) {
    "use strict";

    var WidgetGroup = Marionette.Controller.extend({
        initialize: function initialize(options) {
            this.TriggerView = options.TriggerView;
            this.Widget = IicWidget;
            this.widgets = {};
            this.currentJQLs = undefined;
            this.createdCallback = options.createdCallback;
            this.activeWidget = undefined;
            this.inlineBootstrap = options.inlineBootstrap || new InlineBootstrap();
            this.widgetOptions = _.defaults(options.widgetOptions || {}, {
                issueTypes: this.inlineBootstrap.issueTypes,
                projects: this.inlineBootstrap.projects
            });
        },
        getWidget: function getWidget(id) {
            if (!this.widgets[id]) {
                this.widgets[id] = this._createNewWidget(id);
            }
            return this.widgets[id];
        },
        setCurrentJqls: function setCurrentJqls(jqls) {
            this.currentJQLs = jqls;
            _.each(this.widgets, function setWidgetJqls(w) {
                w.widget.setCurrentJQLs(jqls);
            });
            this.inlineBootstrap.setJQLs(jqls);
        },
        activateWidget: function activateWidget(widget) {
            if (this.activeWidget === widget) {
                widget.focus();
                return;
            }
            var previouslyActiveWidget = this.activeWidget;
            this.activeWidget = undefined;
            _.each(this.widgets, function deactivateWidget(w) {
                if (w !== widget) {
                    w.widget.deactivate();
                }
            });

            var isActivated = widget.activate();
            if (isActivated) {
                widget.focus();
                this.activeWidget = widget;
                this.trigger("widget:activated", widget, previouslyActiveWidget);

                if (previouslyActiveWidget) {
                    widget.setSummary(previouslyActiveWidget.getSummary());
                    widget.setSelectedIssueTypeIfAvailable(previouslyActiveWidget.getSelectedIssueType());
                    previouslyActiveWidget.reset();
                }
            }

            return isActivated;
        },
        _createNewWidget: function _createNewWidget(id) {
            var manager = this;

            var widget = new this.Widget(this.widgetOptions);
            widget.on("deactivated", function onWidgetDeactivated() {
                if (manager.activeWidget === widget) {
                    manager.activeWidget = undefined;
                    widget.reset();
                }
            });

            if (this.createdCallback) {
                this.createdCallback(widget, id);
            }

            if (this.currentJQLs) {
                widget.setCurrentJQLs(this.currentJQLs);
            }

            var trigger = new manager.TriggerView({
                widget: widget
            });

            trigger.on("selected", function () {
                manager.activateWidget(widget);
            });

            return {
                widget: widget,
                trigger: trigger,
                render: function render($element) {
                    trigger.render();
                    $element.append(trigger.$el);
                    widget.attach(trigger.$el);
                    widget.render();
                    manager.trigger("widget:rendered", widget, trigger, $element);
                }
            };
        }
    });

    return WidgetGroup;
});
