define('jira/inline-issue-create/entities/possible-values', [
    'jira/inline-issue-create/lib/backbone',
    'jira/inline-issue-create/lib/underscore',
    'wrm/context-path',
    'jira/inline-issue-create/lib/brace'
], function (
    Backbone,
    _,
    wrmContextPath,
    Brace
) {
    "use strict";

    return Brace.Collection.extend({
        url: function url() {
            var queries = _.map(this.jqls, function (jql) {return "query=" + encodeURIComponent(jql) + "&";});
            return wrmContextPath() + "/rest/inline-create/1.0/context/possibleValues/" + this.getEntityName() + "?".concat.apply("?", queries);
        },
        getEntityName: undefined,
        initialize: function initialize(attributes, options) {
            this._initializeState(attributes, options);
        },
        _initializeState: function _initializeState(attributes, options) {
            if (options && options.jqls) {
                this.jqls = options.jqls;
            } else {
                this.jqls = undefined;
            }

            this.fetching = false;
            this.initialized = false;
        },
        parse: function parse(response) {
            return response.values;
        },
        setJQLs: function settJQLs(jqls) {
            if (_.isEqual(this.jqls, jqls)) {
                return;
            }
            this.jqls = jqls;
            this.fetch({reset: true});
        },
        reset: function reset() {
            this.fetching = false;
            this.initialized = true;
            return Backbone.Collection.prototype.reset.apply(this, arguments);
        },
        fetch: function fetch(options) {
            var collection = this;

            function triggerFetched() {
                collection.fetching = false;
                collection.initialized = true;
                collection.trigger("fetch:finished");
            }

            options = options || {};
            if (options.success) {
                options.success = _.wrap(options.success, function successWrapper(originalSuccessHandler) {
                    triggerFetched();
                    return originalSuccessHandler.apply(collection, Array.prototype.slice.call(arguments, 1));
                });
            } else {
                options.success = triggerFetched;
            }
            this.trigger("fetch:started");
            this.fetching = true;
            return Backbone.Collection.prototype.fetch.call(this, options);
        },
        isInitialized: function isInitialized() {
            return this.initialized;
        },
        isFetching: function isFetching() {
            return this.fetching;
        }
    });
});
