'use strict';function _toConsumableArray(arr) {if (Array.isArray(arr)) {for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {arr2[i] = arr[i];}return arr2;} else {return Array.from(arr);}}define([
'fusion/test/qunit',
'fusion/test/jquery',
'fusion/test/hamjest',
'fusion/test/backbone',
'underscore'],
function (QUnit,
$,
__,
Backbone,
_) {
    "use strict";

    var templateSpy = sinon.stub();
    var confirmationDialogTemplateSpy = sinon.stub();

    var ReposTableMock = Backbone.View.extend({
        initialize: sinon.spy() });


    var AccountModelMock = Backbone.View.extend({
        hasLinkedRepositories: function hasLinkedRepositories() {},
        getName: function getName() {},
        isApproved: function isApproved() {},
        getId: function getId() {},
        setHasLinkedRepositories: sinon.spy() });


    var AdminPageOrgContainerMock = Backbone.View.extend({
        initialize: sinon.spy() });


    var mockedContextPath = sinon.spy();

    var RepoMultiSelectorMock = Backbone.View.extend({
        initialize: sinon.spy(),
        spin: sinon.spy(),
        spinStop: sinon.spy() });


    var RepoCollectionMock = Backbone.Collection.extend({
        initialize: sinon.spy(),
        hasEnabledRepos: function hasEnabledRepos() {} });


    var RestClientMock = sinon.stub();
    var ConfirmationDialogMock = Backbone.View.extend({
        initialize: sinon.spy(),
        render: sinon.spy(),
        remove: sinon.spy() });


    var webhooksDialogMock = {
        showWebhooksDialog: sinon.spy() };


    var DVCSaccountSettingsMock = Backbone.View.extend({
        initialize: sinon.spy() });


    QUnit.module('dvcs/views/dvcs-account-view', {
        require: {
            main: 'dvcs/views/dvcs-account-view',
            jquery: 'fusion/test/jquery',
            backbone: 'fusion/test/backbone' },


        mocks: {
            jquery: QUnit.moduleMock('jquery', function () {return $;}),

            backbone: QUnit.moduleMock('backbone', function () {return Backbone;}),

            underscore: QUnit.moduleMock('unserscore', function () {return _;}),

            ReposTable: QUnit.moduleMock("dvcs/views/dvcs-repos-table", function () {return ReposTableMock;}),

            WebhooksDialog: QUnit.moduleMock("dvcs/views/webhooks-dialog", function () {return webhooksDialogMock;}),

            AdminPageOrgContainer: QUnit.moduleMock("dvcs/bitbucket/views/bitbucket-admin-page-org-container-view",
            function () {return AdminPageOrgContainerMock;}),

            contextPath: QUnit.moduleMock('wrm/context-path', function () {return mockedContextPath;}),

            RepoMultiSelectorMock: QUnit.moduleMock("dvcs/views/dvcs-repo-multi-selector", function () {return RepoMultiSelectorMock;}),

            RepoCollection: QUnit.moduleMock("dvcs/models/dvcs-repo-collection", function () {return RepoCollectionMock;}),

            RestClient: QUnit.moduleMock("dvcs/rest/dvcs-connector-rest-client", function () {return RestClientMock;}),

            confirmationDialog: QUnit.moduleMock("dvcs/views/confirmation-dialog", function () {return ConfirmationDialogMock;}),

            Constants: QUnit.moduleMock("dvcs/util/constants", function () {return new Object({
                    REPOSITORIES_CHUNK_SIZE: 100,
                    REPOSITORIES_RENDERING_INTERVAL: 1 });}),


            DvcsAccountSettings: QUnit.moduleMock("dvcs/views/dvcs-account-settings", function () {return DVCSaccountSettingsMock;}) },


        templates: {
            'dvcs.connector.plugin.soy.dvcs.accounts.emptyAccount': templateSpy,
            'dvcs.connector.plugin.soy.confirmDelete': confirmationDialogTemplateSpy },


        setupDefaultModelMocks: function setupDefaultModelMocks() {
            this.modelHasEnabledReposStub = sinon.stub(AccountModelMock.prototype, 'hasLinkedRepositories');
            this.modelIsApproved = sinon.stub(AccountModelMock.prototype, 'isApproved');
            this.modelGetName = sinon.stub(AccountModelMock.prototype, 'getName');
            this.modelGetId = sinon.stub(AccountModelMock.prototype, 'getId');

            this.modelHasEnabledReposStub.returns(false);
            this.modelIsApproved.returns(true);
        },

        setupRestClientMock: function setupRestClientMock() {
            this.ajaxResultStub = {
                done: function done() {return new Object({ fail: function fail() {} });} };


            RestClientMock.prototype.organization = {
                getRepositories: sinon.stub(),
                remove: sinon.stub() };


            RestClientMock.prototype.organization.getRepositories.returns(this.ajaxResultStub);
            RestClientMock.prototype.organization.remove.returns(this.ajaxResultStub);
        },

        setupRepoCollectionMock: function setupRepoCollectionMock() {
            this.repoCollectionHasEnabledReposStub = sinon.stub(RepoCollectionMock.prototype, 'hasEnabledRepos');
            this.repoCollectionHasEnabledReposStub.returns(true);
        },

        setupFixture: function setupFixture() {
            this.$el = $('<div class="the-view-el"></div>');
            this.fixture.append(this.$el);
            this.$el.append('<div class="dvcs-header-container expandable"><h4></h4><a class="dvcs-control-delete-org"></a></div>');
            this.$el.append('<div id="dvcs-account-repos-N" data-sync-disabled="false"><form id="fake-form">' +
            '<table class="dvcs-repos-table"></table></form></div>');
            this.$el.append('<div class="no-enabled-repos"></div>');
            this.$el.append('<select><options></options></select>');
            this.$el.append('<button class="addDvcsRepoButton"></button>');
        },

        resetConfirmationDialogMocks: function resetConfirmationDialogMocks() {
            ConfirmationDialogMock.prototype.initialize.reset();
            ConfirmationDialogMock.prototype.render.reset();
            ConfirmationDialogMock.prototype.remove.reset();
        },

        restoreModelMocks: function restoreModelMocks() {
            this.modelHasEnabledReposStub.restore();
            this.modelIsApproved.restore();
            this.modelGetName.restore();
            this.modelGetId.restore();
        },

        resetTemplatesMocks: function resetTemplatesMocks() {
            templateSpy.reset();
            confirmationDialogTemplateSpy.reset();
        },

        resetDVCSAccountViewMock: function resetDVCSAccountViewMock() {
            DVCSaccountSettingsMock.prototype.initialize.reset();
        },

        beforeEach: function beforeEach() {
            templateSpy.returns('<div id="empty-div"></div>');

            this.setupFixture();
            this.setupDefaultModelMocks();
            this.setupRestClientMock();
            this.setupRepoCollectionMock();

            $.fn.spin = sinon.spy();
            $.fn.spinStop = sinon.spy();
        },

        afterEach: function afterEach() {

            this.restoreModelMocks();
            this.resetConfirmationDialogMocks();
            this.resetTemplatesMocks();
            this.resetDVCSAccountViewMock();

            this.repoCollectionHasEnabledReposStub.restore();
            $.fn.spin.reset();
            $.fn.spinStop.reset();

            // reset initialize spies
            RepoMultiSelectorMock.prototype.initialize.reset();
            RepoCollectionMock.prototype.initialize.reset();
            ReposTableMock.prototype.initialize.reset();
            AdminPageOrgContainerMock.prototype.initialize.reset();
            mockedContextPath.reset();
            RestClientMock.reset();
            webhooksDialogMock.showWebhooksDialog.reset();
        } });



    QUnit.test('should create all required views and models', function (assert, DVCSAccountView) {

        var model = new AccountModelMock();

        var view = new DVCSAccountView({
            el: this.$el,
            model: model });

        view.render();

        assert.assertThat('should call create instance of repo collection', RepoCollectionMock.prototype.initialize.callCount, __.equalTo(1));

        var collectionInstance = RepoCollectionMock.prototype.initialize.thisValues[0];

        assert.assertThat('should call create instance of repo multi selector view', RepoMultiSelectorMock.prototype.initialize.callCount, __.equalTo(1));
        assert.assertThat('should pass repo collection and correct dom selector to mutli selector view',
        RepoMultiSelectorMock.prototype.initialize.firstCall.args[0], __.hasProperties({
            el: this.$el.find('form'),
            collection: collectionInstance }));


        assert.assertThat('should call create instance of repo table view', ReposTableMock.prototype.initialize.callCount, __.equalTo(1));
        assert.assertThat('shoud pass repo collection and correct dom selector to repo table view',
        ReposTableMock.prototype.initialize.firstCall.args[0], __.hasProperties({
            el: __.containsString('.dvcs-repos-table'),
            collection: collectionInstance,
            syncDisabled: this.$el.find('#dvcs-account-repos-N').data('sync-disabled'),
            accountModel: model }));


        assert.assertThat('should call create instance of admin page org container view', AdminPageOrgContainerMock.prototype.initialize.callCount, __.equalTo(1));
        assert.assertThat('should call create instance of dvcs account settings', DVCSaccountSettingsMock.prototype.initialize.callCount, __.equalTo(1));

        assert.assertThat('should call create instance of rest client', RestClientMock.calledWithNew(), __.equalTo(true));
    });

    QUnit.test('should render empty state when no repo is enabled', function (assert, DVCSAccountView) {
        var model = new AccountModelMock();

        var view = new DVCSAccountView({
            el: this.$el,
            model: model });

        view.render();

        assert.assertThat('should call hasLinkedRepositories on passed model', this.modelHasEnabledReposStub.calledOn(model), __.equalTo(true));
        assert.assertThat('should render empty state when account is approved and has no linked repos', templateSpy.callCount, __.equalTo(1));
        assert.assertThat('should render empty state when account is approved and has no linked repos',
        this.$el.find('.no-enabled-repos').find('div#empty-div').length, __.equalTo(1));
    });

    QUnit.test('should not render empty state when no repo is enabled but account is not approved', function (assert, DVCSAccountView) {
        var model = new AccountModelMock();

        var view = new DVCSAccountView({
            el: this.$el,
            model: model });


        this.modelIsApproved.returns(false);
        view.render();

        assert.assertThat('should call hasLinkedRepositories on passed model', this.modelHasEnabledReposStub.calledOn(model), __.equalTo(true));
        assert.assertThat('should not render empty state when account is not approved and has no linked repos', templateSpy.callCount, __.equalTo(0));
        assert.assertThat('should not render empty state when account is not approved and has no linked repos',
        this.$el.find('.no-enabled-repos').find('div#empty-div').length, __.equalTo(0));
    });

    QUnit.test('should show spinner without empty state when account has enabled repos until repos async load is done', function (assert, DVCSAccountView) {
        var model = new AccountModelMock();

        var stub = sinon.stub(this.ajaxResultStub, 'done');
        stub.returns({ fail: sinon.spy() });

        var view = new DVCSAccountView({
            el: this.$el,
            model: model });


        this.modelHasEnabledReposStub.returns(true);
        this.modelIsApproved.returns(true);
        view.render();

        assert.assertThat('should call hasLinkedRepositories on passed model', this.modelHasEnabledReposStub.calledOn(model), __.equalTo(true));
        assert.assertThat('should not render empty state when account has enabled repos', templateSpy.callCount, __.equalTo(0));
        assert.assertThat('should show spinner until repo async load is done', $.fn.spin.callCount, __.equalTo(1));
        assert.assertThat('should not stop spinning until async call returned', $.fn.spinStop.callCount, __.equalTo(0));

        stub.callArgWith(0, [{ id: 1, name: 'repo1' }]);
        assert.assertThat('should stop spinning on ajax return', $.fn.spinStop.callCount, __.equalTo(1));
        assert.assertThat('should not render empty state when account has enabled repos',
        this.$el.find('.no-enabled-repos').find('div#empty-div').length, __.equalTo(0));
    });

    QUnit.test('should add repos to repo collection after async call', function (assert, DVCSAccountView) {
        var model = new AccountModelMock();

        var addSpy = sinon.spy(RepoCollectionMock.prototype, 'add');

        var stub = sinon.stub(this.ajaxResultStub, 'done');
        stub.returns({ fail: sinon.spy() });

        var view = new DVCSAccountView({
            el: this.$el,
            model: model });

        view.render();

        assert.assertThat('should not add any repo to collection', addSpy.callCount, __.equalTo(0));

        var repoArray = [{ id: 1, name: 'repo1', linked: true }, { id: 2, name: 'repo2', linked: true }];
        stub.callArgWith(0, repoArray);

        assert.assertThat('should call add repo to collection', addSpy.called, __.equalTo(true));
        var allAddedRepos = [];
        addSpy.args.map(function (args) {return args[0];}).forEach(function (arr) {return allAddedRepos.push.apply(allAddedRepos, _toConsumableArray(arr));});
        assert.assertThat('should call add repo to collection with returned repos', allAddedRepos, __.equalTo(repoArray));
    });


    QUnit.test('should render empty state when last connected repo is deleted', function (assert, DVCSAccountView) {
        var model = new AccountModelMock();

        var stub = sinon.stub(this.ajaxResultStub, 'done');
        stub.returns({ fail: sinon.spy() });

        var view = new DVCSAccountView({
            el: this.$el,
            model: model });


        this.modelHasEnabledReposStub.returns(true);
        this.modelIsApproved.returns(true);

        view.render();

        var repoArray = [{ id: 1, name: 'repo1' }, { id: 2, name: 'repo2' }];
        stub.callArgWith(0, repoArray);

        assert.assertThat('empty state should not be called when there is at least one connected repo', templateSpy.callCount, __.equalTo(0));
    });

    QUnit.test('should show webhooks warning dialog', function (assert, DVCSAccountView) {
        var model = new AccountModelMock();
        var view = new DVCSAccountView({
            el: this.$el,
            model: model });

        view.render();

        var multiSelector = RepoMultiSelectorMock.prototype.initialize.thisValues[0];

        var repoWithWarning = {
            id: 101,
            getName: function getName() {return 'warnRepo';},
            getLastRegistration: function getLastRegistration() {return new Object({ callBackUrlInstalled: false, callBackUrl: 'http://example.com' });} };


        var repoWithoutWarning = {
            id: 202,
            getName: function getName() {return 'repo';},
            getLastRegistration: function getLastRegistration() {return new Object({ callBackUrlInstalled: true });} };

        assert.assertThat('should not show webhook dialog until multi selector event is triggered', webhooksDialogMock.showWebhooksDialog.callCount, __.equalTo(0));

        multiSelector.trigger('jira-dvcs-connector:repos-batch-added', [repoWithWarning, repoWithoutWarning]);

        assert.assertThat('should show webhook dialog when multi selector event is triggered with repo with webhook warning',
        webhooksDialogMock.showWebhooksDialog.callCount, __.equalTo(1));

        assert.assertThat('should show webhook dialog with only the repo with webhook warning',
        webhooksDialogMock.showWebhooksDialog.firstCall.args[1], __.equalTo({
            101: { "repoName": "warnRepo", "callBackUrl": "http://example.com" } }));


        webhooksDialogMock.showWebhooksDialog.reset();

        var repo3 = {
            id: 303,
            getName: function getName() {return 'repo3';},
            getLastRegistration: function getLastRegistration() {return new Object({ callBackUrlInstalled: true });} };


        multiSelector.trigger('jira-dvcs-connector:repos-batch-added', [repo3]);

        assert.assertThat('should not show webhook dialog no added repo has webhook warning', webhooksDialogMock.showWebhooksDialog.callCount, __.equalTo(0));

    });

    QUnit.test('should render account body and hide it after clicking on the header', function (assert, DVCSAccountView) {
        var model = new AccountModelMock();
        var view = new DVCSAccountView({
            el: this.$el,
            model: model });

        view.render();

        assert.assertThat('account body should be visible', this.$el.find('div[id^="dvcs-account-repos-"]').is(':visible'), __.truthy());
        assert.assertThat('account icon should be expanded', this.$el.find('.dvcs-header-container h4').hasClass('aui-iconfont-expanded'), __.truthy());

        this.$el.find('.dvcs-header-container').trigger('click');

        assert.assertThat('account body should not be visible', this.$el.find('div[id^="dvcs-account-repos-"]').is(':visible'), __.falsy());
        assert.assertThat('account icon should be collapsed', this.$el.find('.dvcs-header-container h4').hasClass('aui-iconfont-collapsed'), __.truthy());
    });


    QUnit.test('should always show account body', function (assert, DVCSAccountView) {
        this.$el.find('.dvcs-header-container').remove();
        this.$el.append('<div class="dvcs-header-container"><h4></h4></div>');

        var model = new AccountModelMock();
        var view = new DVCSAccountView({
            el: this.$el,
            model: model });

        view.render();

        this.$el.find('.dvcs-header-container').trigger('click');

        assert.assertThat('account body should be visible', this.$el.find('div[id^="dvcs-account-repos-"]').is(':visible'), __.truthy());
        assert.assertThat('account icon should not be expanded', this.$el.find('.dvcs-header-container h4').hasClass('aui-iconfont-expanded'), __.falsy());
        assert.assertThat('account icon should not be collapsed', this.$el.find('.dvcs-header-container h4').hasClass('aui-iconfont-collapsed'), __.falsy());
    });

    QUnit.test('should respond to pending org deleted', function (assert, DVCSAccountView) {
        var model = new AccountModelMock();
        AccountModelMock.prototype.toJSON = sinon.stub();
        AccountModelMock.prototype.toJSON.returns({ json: 'json' });
        var view = new DVCSAccountView({
            el: this.$el,
            model: model });

        var listener = sinon.spy();
        view.on('jira-dvcs-connector:org-deleted', listener, this);
        view.render();

        var orgContainerInstance = AdminPageOrgContainerMock.prototype.initialize.thisValues[0];
        orgContainerInstance.trigger('jira-dvcs-connector:pending-org-deleted');

        assert.assertThat('el was removed', $.contains(document.body, this.$el), __.falsy());
        assert.assertThat('We fired org deleted', listener.callCount, __.equalTo(1));
        assert.assertThat('We sent the write json payload with the event',
        listener.firstCall.args[0], __.equalTo({ json: 'json' }));
    });

    QUnit.test('should respond to delete button click', function (assert, DVCSAccountView) {
        this.modelGetName.returns('repo1521');
        this.modelGetId.returns(1521);
        confirmationDialogTemplateSpy.returns('<div>body</div>');

        var model = new AccountModelMock();
        AccountModelMock.prototype.toJSON = sinon.stub();
        AccountModelMock.prototype.toJSON.returns({ json: { id: 1521 } });
        var view = new DVCSAccountView({
            el: this.$el,
            model: model });


        var listener = sinon.spy();
        view.on('jira-dvcs-connector:org-deleted', listener, this);
        view.render();

        this.$el.find('.dvcs-control-delete-org').trigger('click');

        assert.assertThat('should show confirmation dialog on delete', ConfirmationDialogMock.prototype.initialize.callCount, __.equalTo(1));
        assert.assertThat('should pass correct parameters to config dialog', ConfirmationDialogMock.prototype.initialize.firstCall.args[0],
        __.hasProperties({
            header: __.containsString('repo1521'),
            body: __.equalTo('<div>body</div>'),
            submitButtonLabel: __.truthy(),
            okAction: __.instanceOf(Function) }));

        assert.assertThat('should show confirmation dialog on delete', ConfirmationDialogMock.prototype.render.callCount, __.equalTo(1));

        assert.assertThat('should not delete account without confirmation', RestClientMock.prototype.organization.remove.callCount, __.equalTo(0));

        var stub = sinon.stub(this.ajaxResultStub, 'done');
        stub.returns({ fail: sinon.spy() });

        var okCallback = ConfirmationDialogMock.prototype.initialize.firstCall.args[0].okAction;
        okCallback(ConfirmationDialogMock.prototype.initialize.thisValues[0]);

        assert.assertThat('should delete organization after confirmation', RestClientMock.prototype.organization.remove.callCount, __.equalTo(1));
        assert.assertThat('should pass correct organization id to delete fn', RestClientMock.prototype.organization.remove.firstCall.args, __.equalTo([1521]));

        stub.callArg(0);
        assert.assertThat('should close confirmation dialog after delete is done', ConfirmationDialogMock.prototype.remove.callCount, __.equalTo(1));
        assert.assertThat('We fired org deleted', listener.callCount, __.equalTo(1));
        assert.assertThat('We sent the write json payload with the event',
        listener.firstCall.args[0], __.equalTo({ json: { id: 1521 } }));
    });
});