'use strict';define([
'fusion/test/qunit',
'fusion/test/jquery',
'fusion/test/hamjest',
'fusion/test/backbone',
'underscore'],

function (QUnit,
$,
__,
Backbone,
_) {

    var NotificationMock = {
        showError: sinon.spy(),
        showWarning: sinon.spy() };


    var MockedContextPath = function MockedContextPath() {return sinon.spy();};

    var ConfigureAccountDialogMock = Backbone.View.extend({
        initialize: sinon.spy() });


    var ModelMock = Backbone.Model.extend({
        getId: function getId() {return 1;},
        getName: function getName() {return "orgName";},
        isReposDefaultEnabled: function isReposDefaultEnabled() {return true;},
        isSmartCommitsDefaultEnabled: function isSmartCommitsDefaultEnabled() {return true;} });


    QUnit.module('dvcs/views/dvcs-account-settings', {
        require: {
            main: 'dvcs/views/dvcs-account-settings',
            backbone: 'fusion/test/backbone' },


        templates: {},

        mocks: {
            jquery: QUnit.moduleMock('jquery', function () {return $;}),
            underscore: QUnit.moduleMock('underscore', function () {return _;}),
            backbone: QUnit.moduleMock('backbone', function () {return Backbone;}),
            ConfigureAccountDialog: QUnit.moduleMock("dvcs/bitbucket/views/default-account-settings-dialog",
            function () {return ConfigureAccountDialogMock;}),
            contextPath: QUnit.moduleMock('wrm/context-path', function () {return MockedContextPath;}),
            Notification: QUnit.moduleMock("dvcs/admin/dvcs-notifications", function () {return NotificationMock;}) },



        setupFixture: function setupFixture() {
            this.$el = $('<div class="the-view-el"></div>');
            this.fixture.append(this.$el);
            this.$el.append('<ul><li class="default-setting-item"></li></ul>');
        },

        beforeEach: function beforeEach(assert) {
            this.setupFixture();

        },

        afterEach: function afterEach() {
            ConfigureAccountDialogMock.prototype.initialize.reset();
            MockedContextPath().reset();
            NotificationMock.showError.reset();
            NotificationMock.showWarning.reset();
        } });


    QUnit.test('should create dialog on click', function (assert, accountSettingsView) {
        var settingsView = new accountSettingsView({
            el: this.$el,
            model: new ModelMock() });

        var li = this.fixture.find('.default-setting-item');
        li.click();

        assert.assertThat('should call create instance of account settings dialog', ConfigureAccountDialogMock.prototype.initialize.callCount, __.equalTo(1));
        assert.assertThat('should pass correct parameters to settings dialog', ConfigureAccountDialogMock.prototype.initialize.firstCall.args[0],
        __.hasProperties({
            organizationId: 1,
            organizationName: "orgName",
            autoLinkEnabled: true,
            smartCommitsEnabled: true }));

    });

});