'use strict';define([
'fusion/test/qunit',
'fusion/test/hamjest',
'fusion/test/backbone'],
function (QUnit,
__,
Backbone) {

    var RepoModel = Backbone.Model.extend({
        getName: function getName() {
            return this.get('name');
        } });


    QUnit.module('dvcs/models/dvcs-repo-collection', {
        require: {
            main: 'dvcs/models/dvcs-repo-collection',
            backbone: 'fusion/test/backbone' },


        mocks: {
            backbone: QUnit.moduleMock('backbone', function () {return Backbone;}),

            RepoModel: QUnit.moduleMock("dvcs/models/dvcs-repo-model", function () {return RepoModel;}) } });



    QUnit.test('should filter repos by linked value', function (assert, RepoCollection) {
        var linkedRepo = {
            id: 'linkedRepo',
            name: 'linkedRepo',
            linked: true };


        var unLinkedRepo = {
            id: 'unlinkedRepo',
            name: 'unlinkedRepo',
            linked: false };


        var collection = new RepoCollection([unLinkedRepo, linkedRepo]);
        assert.assertThat('should filter only linked repos', collection.filterEnabled().toJSON(), __.equalTo([linkedRepo]));
        assert.assertThat('should filter only unlinked repos', collection.filterDisabled().toJSON(), __.equalTo([unLinkedRepo]));

        assert.assertThat('should has enabled repos', collection.hasEnabledRepos(), __.equalTo(true));

        collection.remove('linkedRepo');

        assert.assertThat('should not have enabled repos', collection.hasEnabledRepos(), __.equalTo(false));
    });
});