'use strict';define([
'fusion/test/qunit',
'fusion/test/hamjest',
'jquery',
'fusion/test/mock-declaration',
'fusion/test/backbone'],
function (QUnit,
__,
$,
MockDeclaration,
Backbone)
{

    var pendingOrgViewSnippet = '\n        <div data-bitbucket-override-url="http://dev.bitbucket.org:8000" data-org-name="test" data-org-id="1">\n            <section class="approve-org-section" role="main">\n                <section class="bb-org-approval-details">\n                    <h2 class="bb-org-access-request">Your test account is requesting access to JIRA</h2>\n                    <div>\n                        <div>The <strong>test</strong> account on Bitbucket is requesting the ability to:</div>\n                        <div class="scopes">\n                            <div class="scopeItem">\n                                <div class="aui-group aui-group-split">\n                                    <div class="aui-item scope-icon"><span class="aui-icon icon-issues"></span></div>\n                                    <div class="aui-item scope-text">View and update your issues</div>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n                    <form class="buttons-container no-left-padding buttons aui">\n                        <button class="aui-button aui-button-primary approve-org-button">Grant access</button>\n                        <button class="aui-button aui-button-link remove-connection-button">Remove connection</button>\n                        <span class="confirmation-spinner aui-icon aui-icon-wait hidden"></span></form>\n                </section>\n            </section>\n        </div>\n    ';
























    QUnit.module('dvcs/bitbucket/views/bitbucket-admin-page-pending-org-view', {
        require: {
            main: 'dvcs/bitbucket/views/bitbucket-admin-page-pending-org-view' },

        mocks: {
            backbone: QUnit.moduleMock('backbone', function () {
                return Backbone;
            }),
            restClient: QUnit.moduleMock("dvcs/rest/dvcs-connector-rest-client",
            new MockDeclaration([
            'organization.remove']).
            withConstructor()),

            contextPath: QUnit.moduleMock('wrm/context-path', function () {
                return function () {
                    return 'context-path';
                };
            }),
            configureOrganization: QUnit.moduleMock("dvcs/admin/configure-organization",
            new MockDeclaration([])),

            analyticsClient: QUnit.moduleMock("dvcs/analytics/analytics-client",
            new MockDeclaration([
            'firePendingOrgRemoved']).
            withConstructor()) },


        templates: {},

        beforeEach: function beforeEach(assert, PendingOrgView) {
            this.view = new PendingOrgView({
                el: $(pendingOrgViewSnippet) });

        } });


    QUnit.test('Remove connection fires analytics and triggers event on successful removal',
    function (assert) {
        _runOrgRemovalTest(this, assert);
    });


    QUnit.test('Remove connection fires analytics and triggers event on 404',
    function (assert) {
        _runOrgRemovalTest(this, assert, 404);
    });


    QUnit.test('Remove connection fires analytics and triggers event on timeout',
    function (assert) {
        _runOrgRemovalTest(this, assert, 0);
    });


    QUnit.test('Remove connection fires analytics and doesn\'t trigger event on other error',
    function (assert) {
        _runOrgRemovalTest(this, assert, 500, false);
    });


    /**
         * Run an org removal test.
         *
         * This test will:
         * - click the "remove connection" button
         * - respond to the 'remove' REST call with success or fail
         * - assert on the expected behavior
         *
         * @param self A reference to the test
         * @param assert The assertion library
         * @param [failStatus] if provided, will respond to the 'remove' REST call with this failure status;
         *  otherwise will simulate a successful request (HTTP.200 OK).
         * @param [expectEventTriggered] whether or not the 'pending-org-deleted' event is expected to fire.
         * @private
         */
    function _runOrgRemovalTest(self, assert, failStatus) {var expectEventTriggered = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
        // setup
        var removeOrgTask = new $.Deferred();
        self.mocks.restClient.answer.organization.remove.returns(removeOrgTask);

        var eventFired = false;
        self.view.on('jira-dvcs-connector:pending-org-deleted', function () {
            eventFired = true;
        });

        // execute
        self.view.$el.find('.remove-connection-button').click();
        if (failStatus) {
            removeOrgTask.reject({
                status: failStatus });

        } else
        {
            removeOrgTask.resolve();
        }

        // verify
        assert.assertThat("Expected the org deleted event to fire", eventFired, __.is(expectEventTriggered));

        assert.assertThat("Expected the org remove to happen",
        self.mocks.restClient.answer.organization.remove, __.calledOnce());

        assert.assertThat("Expected the pending org removed analytics to fire",
        self.mocks.analyticsClient.answer.firePendingOrgRemoved, __.calledOnce());
    }
});