"use strict";AJS.test.require("com.atlassian.jira.plugins.jira-bitbucket-connector-plugin:__test__entrypoint-add-user-bitbucket-access-extension",function(){require(["dvcs/bitbucket-access/add-user-form","dvcs/bitbucket-access/bitbucket-access","dvcs/bitbucket-access/bitbucket-access-controller"],function(e,t,s){module("Bitbucket access controller",{setup:function(){this.sandbox=sinon.sandbox.create(),this.addUserForm={isSoftwareApplicationSelected:this.sandbox.stub(),getSelectedApplicationCount:this.sandbox.stub(),onApplicationSelectionChange:this.sandbox.stub(),onSubmit:this.sandbox.stub(),append:this.sandbox.stub()},this.bitbucketAccess={enable:this.sandbox.stub(),disable:this.sandbox.stub(),select:this.sandbox.stub(),deselect:this.sandbox.stub(),isEnabled:this.sandbox.stub(),isSelected:this.sandbox.stub()};var e="1:developers;1:admin;2:developers";this.bitbucketAccessController=new s(this.addUserForm,this.bitbucketAccess,e)},teardown:function(){this.sandbox.restore()}}),test("Should establish initial state and register listeners when start is invoked",function(){this.sandbox.spy(this.bitbucketAccessController,"establishInitialState"),this.sandbox.spy(this.bitbucketAccessController,"registerListeners"),this.bitbucketAccessController.start(),sinon.assert.calledOnce(this.bitbucketAccessController.establishInitialState),sinon.assert.calledOnce(this.bitbucketAccessController.registerListeners)}),test("Should select bitbucket access when Software is selected",function(){this.addUserForm.isSoftwareApplicationSelected.returns(!0),this.bitbucketAccessController.establishInitialState(),sinon.assert.calledOnce(this.bitbucketAccess.select)}),test("Should not select bitbucket access when Software is not selected",function(){this.addUserForm.isSoftwareApplicationSelected.returns(!1),this.bitbucketAccessController.establishInitialState(),sinon.assert.notCalled(this.bitbucketAccess.select)}),test("Should disable bitbucket access when no application is selected",function(){this.addUserForm.getSelectedApplicationCount.returns(0),this.bitbucketAccessController.establishInitialState(),sinon.assert.calledOnce(this.bitbucketAccess.disable)}),test("Should not disable bitbucket access when some applications are selected",function(){this.addUserForm.getSelectedApplicationCount.returns(3),this.bitbucketAccessController.establishInitialState(),sinon.assert.notCalled(this.bitbucketAccess.disable)}),test("Should listen to change and submit events",function(){this.bitbucketAccessController.registerListeners(),sinon.assert.calledOnce(this.addUserForm.onApplicationSelectionChange),sinon.assert.calledOnce(this.addUserForm.onSubmit)}),test("Should disable bitbucket access on application selection change when no application is selected and bitbucket access is enabled",function(){this.addUserForm.getSelectedApplicationCount.returns(0),this.bitbucketAccess.isEnabled.returns(!0),this.bitbucketAccessController.onApplicationSelectionChange(),sinon.assert.calledOnce(this.bitbucketAccess.disable)}),test("Should do nothing on application selection change when no application is selected and bitbucket access is disabled",function(){this.addUserForm.getSelectedApplicationCount.returns(0),this.bitbucketAccess.isEnabled.returns(!1),this.bitbucketAccessController.onApplicationSelectionChange(),sinon.assert.notCalled(this.bitbucketAccess.disable)}),test("Should enable bitbucket access on application selection change when some applications are selected and bitbucket access is disabled",function(){this.addUserForm.getSelectedApplicationCount.returns(3),this.bitbucketAccess.isEnabled.returns(!1),this.bitbucketAccessController.onApplicationSelectionChange(),sinon.assert.calledOnce(this.bitbucketAccess.enable)}),test("Should do nothing on application selection change when some applications are selected and bitbucket access is enabled",function(){this.addUserForm.getSelectedApplicationCount.returns(3),this.bitbucketAccess.isEnabled.returns(!0),this.bitbucketAccessController.onApplicationSelectionChange(),sinon.assert.notCalled(this.bitbucketAccess.enable)}),test("Should append hidden input field on form submit when Bitbucket access is selected",function(){this.bitbucketAccess.isSelected.returns(!0),this.bitbucketAccessController.onFormSubmit(),sinon.assert.calledWithExactly(this.addUserForm.append,'<input type="hidden" name="dvcs_org_selector" value="1:developers;1:admin;2:developers" />')}),test("Should do nothing on form submit when Bitbucket access is not selected",function(){this.bitbucketAccess.isSelected.returns(!1),this.bitbucketAccessController.onFormSubmit(),sinon.assert.notCalled(this.addUserForm.append)})})});