jiraDVCSPluginJsonp(["add-organization-generic"],{

/***/ "./js/dvcs/add-organization/add-organization-generic.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * !IMPORTANT
 * dvcs.connector.plugins is a magic global with data - see add-organization.vm
 */

__webpack_require__.e/* require */(1).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__("jira.webresources:jira-logger/require('jira/util/logger')"), __webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("./js/dvcs/rest/dvcs-connector-rest-client.js"), __webpack_require__("./js/dvcs/ui/update-sync-status.js"), __webpack_require__("./js/dvcs/lib/aui/messages.js"), __webpack_require__("./js/dvcs/ui/showRepoDialog.js"), __webpack_require__("./js/dvcs/random/bitbucket.js"), __webpack_require__("./js/dvcs/admin/configure-organization.js"), __webpack_require__("./js/dvcs/lib/aui/dialog.js"), __webpack_require__("./js/dvcs/util/redirectToBitbucketAuthorize.js")]; (function (logger, formatter, $, DvcsConnectorRestClient, updateSyncStatus, AJSMessages, showAddRepoDetails, bitbucketRandom, ConfigureOrganization, AJSDialog, redirectToBitbucketAuthorize) {
    __webpack_require__(6);
    __webpack_require__(1);
    __webpack_require__(4);
    __webpack_require__(2);
    __webpack_require__(3);
    __webpack_require__(5);

    function setCheckedDropdown2(checkboxId, checked) {
        if (checked) {
            $("#" + checkboxId).addClass("checked");
        } else {
            $("#" + checkboxId).removeClass("checked");
        }
    }

    function autoLinkIssuesOrg(organizationId, checkboxId, checkedValue) {
        var $orgAutoLinkCheckbox = $("#" + checkboxId);
        $orgAutoLinkCheckbox.addClass("disabled");
        var restClient = new DvcsConnectorRestClient(dvcs.connector.plugin.BASE_URL);
        restClient.organization.autoLinkRepositories(organizationId, checkedValue).done(function (data) {
            var $orgSmartCommitsCheckbox = $("#org_global_smarts" + organizationId);
            $orgAutoLinkCheckbox.removeClass("disabled");
            if (!checkedValue && $orgSmartCommitsCheckbox) {
                $orgSmartCommitsCheckbox.addClass("disabled");
            } else {
                $orgSmartCommitsCheckbox.removeClass("disabled");
            }
        }).fail(function (err) {
            bitbucketRandom.showError("Unexpected error occurred. Please contact the server administrator.", "#aui-message-bar-" + organizationId);
            $orgAutoLinkCheckbox.removeClass("disabled");
            setCheckedDropdown2(checkboxId, !checkedValue);
        });
    }

    function enableSmartcommitsOnNewRepos(organizationId, checkboxId, checkedValue) {
        var $orgAutoSmartCommitsCheckbox = $("#" + checkboxId);
        $orgAutoSmartCommitsCheckbox.addClass("disabled");
        var restClient = new DvcsConnectorRestClient(dvcs.connector.plugin.BASE_URL);
        restClient.organization.autoEnableSmartCommits(organizationId, checkedValue).done(function (data) {
            $orgAutoSmartCommitsCheckbox.removeClass("disabled");
        }).fail(function (err) {
            bitbucketRandom.showError("Unexpected error occurred when enabling smart commits on new repositories. Please contact the server administrator.", "#aui-message-bar-" + organizationId);
            $orgAutoSmartCommitsCheckbox.removeClass("disabled");
            setCheckedDropdown2(checkboxId, !checkedValue);
        });
    }

    function retrieveSyncStatus() {
        $.getJSON(dvcs.connector.plugin.BASE_URL + "/rest/bitbucket/1.0/repositories", function (data) {
            $.each(data.repositories, function (a, repo) {
                updateSyncStatus(repo);
            });
            window.setTimeout(retrieveSyncStatus, 20000);
        }).fail(function (jqxhr, textStatus, error) {
            var err = textStatus + ", " + error;
            logger.log("DVCS: Request Failed: " + err);
            window.setTimeout(retrieveSyncStatus, 60000);
        });
    }

    function registerDropdownCheckboxHandlers() {
        $("a[id^='org_autolink_check']").on({
            "aui-dropdown2-item-check": function auiDropdown2ItemCheck() {
                autoLinkIssuesOrg(this.id.substring("org_autolink_check".length), this.id, true);
            },
            "aui-dropdown2-item-uncheck": function auiDropdown2ItemUncheck() {
                autoLinkIssuesOrg(this.id.substring("org_autolink_check".length), this.id, false);
            }
        });

        $("a[id^='org_global_smarts']").on({
            "aui-dropdown2-item-check": function auiDropdown2ItemCheck() {
                enableSmartcommitsOnNewRepos(this.id.substring("org_global_smarts".length), this.id, true);
            },
            "aui-dropdown2-item-uncheck": function auiDropdown2ItemUncheck() {
                enableSmartcommitsOnNewRepos(this.id.substring("org_global_smarts".length), this.id, false);
            }
        });
    }

    /**
     * Show the OAuth settings dialog for the provided org
     * <p>
     * Collects and validates oauth credentials from the user and POSTS them to the appropriate REST endpoint before
     * executing the provided success callback.
     *
     * @param org The org being configured
     * @param popupId The element ID to use for the popup dialog
     * @param header The header text to show in the dialog
     * @param submitButtonText The text to use on the dialog submit button
     * @param success A function to execute on successful submit
     */
    function showOAuthDialog(org, popupId, header, submitButtonText, success) {
        /**
         * Validate that the provided required field contains a value
         *
         * @param $field The field to validate
         * @param errorMsg The message to show in case of a validation error
         * @returns {boolean} true if validation was successful; false otherwise.
         * @private
         */
        function _validateField($field, errorMsg) {
            if (!$.trim($field.val())) {
                _showFieldError($field, errorMsg);
                return false;
            }
            _clearFieldError($field);
            return true;
        }

        /**
         * Show an error against the provided dialog field
         * @param $field The field to show an error against
         * @param errorMsg The message to show
         * @private
         */
        function _showFieldError($field, errorMsg) {
            $field.next().html(errorMsg);
            $field.next().show();
        }

        /**
         * Clear the error message associated with the provided dialog field
         * @param $field The field to clear the error against
         * @private
         */
        function _clearFieldError($field) {
            $field.next().html("&nbsp;");
            $field.next().hide();
        }

        /**
         * Show an error message in the dialog
         *
         * @param {jqXHR} err The error response received from the server
         * @private
         */
        function _showOAuthErrorMsg(err) {
            var msg;
            if (err.status == 409) {
                msg = 'The credentials for this organisation are out of date and cannot be updated. ' + 'Please <a href="javascript:location.reload()">refresh the page</a>.';
            } else {
                msg = "Could not configure OAuth";
            }
            $("#aui-message-bar-oauth-dialog").empty();
            AJSMessages.error("#aui-message-bar-oauth-dialog", {
                title: "Error!",
                body: msg,
                closeable: false
            });
            var $buttonPanel = $("#repositoryOAuthDialog .dialog-button-panel");
            $buttonPanel.find('button').removeAttr("disabled");
            $buttonPanel.find('button').removeAttr("aria-disabled");
            $buttonPanel.find('.aui-icon-wait').remove();
        }

        // dialog with 2 pages
        var popup = new AJSDialog({
            width: 600,
            height: 350,
            id: popupId
        });

        function addCancelButtonToPopup() {
            popup.addCancel(formatter.I18n.getText("common.forms.cancel"), function (dialog) {
                dialog.remove();
            });
        }

        popup.addHeader(header);

        // first page
        // show current used oAuth key
        popup.addPanel("", dvcs.connector.plugin.soy.repositoryOAuthDialog({
            'organizationId': org.id,
            'oAuthKey': org.credential.key,
            'edit': false
        }));

        popup.addButton(formatter.I18n.getText("common.forms.edit"), function (dialog) {
            popup.nextPage();
            popup.updateHeight();
        }, "edit-button");

        addCancelButtonToPopup();

        // add 2nd page
        popup.addPage();

        popup.addHeader(header);
        // show form to set new oAuth key & secret
        popup.addPanel("", dvcs.connector.plugin.soy.repositoryOAuthDialog({
            'organizationId': org.id,
            'oAuthKey': org.credential.key,
            'edit': true
        }));

        _clearFieldError($("#updateOAuthForm #key"));
        _clearFieldError($("#updateOAuthForm #secret"));

        // button to return back to 1st page
        popup.addButton(formatter.I18n.getText("common.concepts.back"), function (dialog) {
            popup.prevPage();
            popup.updateHeight();
        });

        // button to submit new oAuth credentials
        popup.addButton(submitButtonText, function (dialog) {
            // validate
            var v1 = _validateField($("#updateOAuthForm #key"), "OAuth key must not be blank");
            var v2 = _validateField($("#updateOAuthForm #secret"), "OAuth secret must not be blank");
            popup.updateHeight();
            if (!v1 || !v2) {
                return;
            }

            $("#repositoryOAuthDialog .dialog-button-panel button").attr("disabled", "disabled");
            $("#repositoryOAuthDialog .dialog-button-panel button").attr("aria-disabled", "true");
            $("#repositoryOAuthDialog .dialog-button-panel").prepend("<span class='aui-icon aui-icon-wait' style='padding-right:10px'>Wait</span>");

            // submit form
            $.post(dvcs.connector.plugin.BASE_URL + "/rest/bitbucket/1.0/org/" + org.id + "/oauth", $("#updateOAuthForm").serialize()).done(function (data) {
                if (success) {
                    success(popup);
                }
            }).error(function (err) {
                _showOAuthErrorMsg(err);
                popup.updateHeight();
            });
        }, "aui-button submit");

        addCancelButtonToPopup();

        // start popup
        popup.gotoPage(0);
        popup.show();
        popup.updateHeight();

        return false;
    }

    /**
     * Show the configure oauth settings dialog for a user-added account
     * @param org The org to configure
     * @param atlToken The csrf token to append to page redirects
     */
    function configureOAuthForUserAccount(org, atlToken) {

        showOAuthDialog(org, "repositoryOAuthDialog", "Configure OAuth for account " + org.name, "Regenerate Access Token", function (popup) {
            var actionName;
            if (org.dvcsType == "bitbucket") {
                actionName = "RegenerateBitbucketOauthToken.jspa";
            } else if (org.dvcsType == "github") {
                actionName = "RegenerateGithubOauthToken.jspa";
            } else {
                actionName = "RegenerateGithubEnterpriseOauthToken.jspa";
            }

            location.replace(dvcs.connector.plugin.BASE_URL + "/secure/admin/" + actionName + "?organization=" + org.id + "&atl_token=" + atlToken);
        });

        $.getJSON(dvcs.connector.plugin.BASE_URL + "/rest/bitbucket/1.0/organization/" + org.id + "/tokenOwner", function (data) {
            if (data.fullName.trim().length == 0) {
                data.fullName = data.username;
            }
            $(".repositoryOAuthDialog #tokenUser").html(dvcs.connector.plugin.soy.repositoryOAuthDialogTokenOwner(data));
        }).error(function (err) {
            $(".repositoryOAuthDialog #tokenUser").html("<i>&lt;Invalid, please regenerate access token.&gt;<i>");
        });
    }

    function confirmationDialog(options) {
        var dialog = new AJSDialog({ width: 500, height: 150, id: "confirm-dialog", closeOnOutsideClick: false });
        dialog.addHeader(options.header);
        dialog.addPanel("ConfirmPanel", options.body + "<div id='aui-message-bar-confirmation-dialog'></div>");

        dialog.addButtonPanel();
        dialog.page[0].buttonpanel.append("<span id='confirm-action-wait' class='aui-icon' style='padding-right:10px'>&nbsp;</span>");

        dialog.addSubmit(options.submitButtonLabel, function (dialog, event) {
            dialog.working(true);
            if (typeof options.okAction == 'function') {
                options.okAction(dialog);
            }
        });

        dialog.addCancel("Cancel", function (dialog) {
            if (typeof options.cancelAction == 'function') {
                options.cancelAction(dialog);
            }
            dialog.remove();
        }, "#");

        dialog.disableActions = function () {
            $('#confirm-dialog .button-panel-submit-button').attr("disabled", "disabled");
            $('#confirm-dialog .button-panel-submit-button').attr("aria-disabled", "true");
            $('#confirm-dialog .button-panel-cancel-link').addClass('dvcs-link-disabled');
        };

        dialog.enableActions = function () {
            $('#confirm-dialog .button-panel-submit-button').removeAttr("disabled");
            $('#confirm-dialog .button-panel-submit-button').removeAttr("aria-disabled");
            $('#confirm-dialog .button-panel-cancel-link').removeClass('dvcs-link-disabled');
        };

        dialog.working = function (working) {
            if (working) {
                $("#confirm-action-wait").addClass("aui-icon-wait");
                this.disableActions();
            } else {
                $("#confirm-action-wait").removeClass("aui-icon-wait");
                this.enableActions();
            }
        };

        dialog.showError = function (message) {
            dialog.working(false);
            bitbucketRandom.showError(message, "#aui-message-bar-confirmation-dialog");
            dialog.updateHeight();
        };

        dialog.isAttached = function () {
            return !$.isEmptyObject(dialog.popup.element);
        };

        dialog.show();
        dialog.updateHeight();

        return dialog;
    }

    function configureDefaultGroups(id) {

        var dialog = confirmationDialog({
            header: "Configure automatic access",
            body: dvcs.connector.plugin.soy.defaultGroupsForm({
                'baseUrl': dvcs.connector.plugin.BASE_URL,
                'atlToken': dvcs.connector.plugin.atlToken,
                'organizationIdDefaultGroups': id
            }),
            submitButtonLabel: "Save",
            okAction: function okAction(dialog) {
                $("#configureDefaultGroupsForm").submit();
            }
        });

        dialog.page[0].buttonpanel.append(dvcs.connector.plugin.soy.defaultGroupsHelpUrl());
        dialog.disableActions();

        // load web fragment
        $.ajax({
            type: 'GET',
            url: dvcs.connector.plugin.BASE_URL + "/rest/bitbucket/1.0/organization/" + id + "/defaultgroups",
            success: function success(data) {
                if (dialog.isAttached()) {
                    $(".dialog-panel-body #configureDefaultGroupsContent").html(dvcs.connector.plugin.soy.defaultGroups({
                        organization: data.organization,
                        groups: data.groups,
                        isBitbucketRebrandEnabled: $("#dvcs-connect-source").data("bbrebrand")
                    }));
                    dialog.updateHeight();
                    dialog.enableActions();
                }
            }
        }).error(function (err) {
            dialog.showError($(err.responseXML).find('status').find('message').text());
            dialog.updateHeight();
        });
    }

    $(function () {

        /**
         * register onclick handler that used to be inline:
         * in add-organization.vm we call dvcs.connector.plugin.soy.dvcs.accounts.dvcsAccountHeader
         * which calls dvcs.connector.plugin.soy.dvcs.accounts.dropDownMenu
         * which calls dvcs.connector.plugin.soy.dvcs.accounts.dropDownList
         * which had 3 onclick-inline javascript handlers defined.
         *
         */
        $('body').on('click', '.orga-sync-repo-trigger', function () {
            var $this = $(this);
            var orgId = $this.data('orgId');
            var orgName = $this.data('orgName');
            ConfigureOrganization.syncRepositoryList(orgId, orgName);
            return false;
        }).on('click', '.orga-configure-oauth-user-trigger', function () {
            var $this = $(this);
            var orgJson = window.dvcs.connector.plugin.orgData;
            var atlToken = $this.data('atlToken');
            configureOAuthForUserAccount(orgJson, atlToken);
            return false;
        }).on('click', '.orga-configure-default-groups-trigger', function () {
            var $this = $(this);
            var orgId = $this.data('orgId');
            var orgName = $this.data('orgName');
            configureDefaultGroups(orgId, orgName);
            return false;
        });

        /**
         * register onclick handlers that used to be inline:
         * in add-organization.vm we call dvcs.connector.plugin.soy.dvcs.accounts.linkAccountSection
         * which has some inline on event handlers - also it includes dvcs.connector.plugin.soy.dvcs.accounts.linkAccountSection.noAccounts
         * which has some inline javascript on event handlers
         */
        $('body').on('click', '.link-repository-trigger, .link-github-account-trigger', function () {
            showAddRepoDetails(true);
        }).on('click', '.link-bitbucket-account-trigger', function () {
            var bitbucketOverrideUrl = $(this).data('bitbucketOverrideUrl');
            redirectToBitbucketAuthorize(bitbucketOverrideUrl);
        });

        // cancel annoying leave message even when browser pre-fill some fields
        window.onbeforeunload = function () {};

        // run timer for repos sync statuses
        retrieveSyncStatus();
        registerDropdownCheckboxHandlers();

        /**
         * DVCS connector uses the hash '#expand' in the URL to determine whether to automatically open the
         * 'Add New Account' dialog.
         */
        if (window.location.hash == '#expand') {
            var hostToSelect = undefined;
            if (parseUri) {
                //queryKey should always be available in the object returned by parseUri(), but it's good to be
                // defensive anyway
                var urlQueries = parseUri(window.location.href).queryKey || {};
                hostToSelect = urlQueries.selectHost;
            }

            // still global in bitbucket.js - too many global dependencies for now
            showAddRepoDetails(true, hostToSelect);
        }
    });

    // Perform the redirect ASAP - preferably before the page loads...
    // This is done after the plugin globals are set because redirectToBitbucketAuthorize depends on them
    if (dvcs.connector.plugin.aciEnabled && window.location.hash == '#expand' && parseUri) {
        var urlQueries = parseUri(window.location.href).queryKey || {};
        if (urlQueries.selectHost == 'bitbucket') {
            // Stop all module initialisers from executing, and prevent the remainder of the DOM from loading
            $.holdReady(true);
            if (window.stop) {
                window.stop();
            } else if (document.execCommand) {
                document.execCommand("Stop");
            }
            // Perform the redirect
            redirectToBitbucketAuthorize(dvcs.connector.plugin.bitbucketOverrideUrl);
        }
    }
}.apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__));}).catch(__webpack_require__.oe);

/***/ })

},["./js/dvcs/add-organization/add-organization-generic.js"]);
//# sourceMappingURL=add-organization-generic.js.map