jiraDVCSPluginJsonp([4],{

/***/ "./js/dvcs/bitbucket-access/add-user-form.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_RESULT__ = function () {
    "use strict";

    var AddUserForm = function AddUserForm($applications, $form, $softwareAccess) {
        this.$applications = $applications;
        this.$form = $form;
        this.$softwareAccess = $softwareAccess;
    };

    AddUserForm.prototype = {
        isSoftwareApplicationSelected: function isSoftwareApplicationSelected() {
            return this.$softwareAccess.attr('checked');
        },

        getSelectedApplicationCount: function getSelectedApplicationCount() {
            return this.$applications.filter(':checked').length;
        },

        onApplicationSelectionChange: function onApplicationSelectionChange(callback) {
            this.$applications.on('change', callback);
        },

        onSubmit: function onSubmit(callback) {
            this.$form.on('submit', callback);
        },

        append: function append(toAppend) {
            this.$form.append(toAppend);
        }
    };

    return AddUserForm;
}.call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/bitbucket-access/bitbucket-access-controller.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (_) {
    "use strict";

    var BitbucketAccessController = function BitbucketAccessController(addUserForm, bitbucketAccess, bitbucketInviteToGroups) {
        this.addUserForm = addUserForm;
        this.bitbucketAccess = bitbucketAccess;
        this.bitbucketGroupsInputField = '<input type="hidden" name="dvcs_org_selector" value="' + bitbucketInviteToGroups + '" />';
    };

    BitbucketAccessController.prototype = {
        start: function start() {
            this.establishInitialState();
            this.registerListeners();
        },

        establishInitialState: function establishInitialState() {
            if (this.addUserForm.isSoftwareApplicationSelected()) {
                this.bitbucketAccess.select();
            }

            if (this.addUserForm.getSelectedApplicationCount() === 0) {
                this.bitbucketAccess.disable();
            }
        },

        registerListeners: function registerListeners() {
            this.addUserForm.onApplicationSelectionChange(_.bind(this.onApplicationSelectionChange, this));
            this.addUserForm.onSubmit(_.bind(this.onFormSubmit, this));
        },

        onApplicationSelectionChange: function onApplicationSelectionChange() {
            var selectedApplicationCount = this.addUserForm.getSelectedApplicationCount();

            if (selectedApplicationCount === 0 && this.bitbucketAccess.isEnabled()) {
                this.bitbucketAccess.disable();
            }

            if (selectedApplicationCount !== 0 && !this.bitbucketAccess.isEnabled()) {
                this.bitbucketAccess.enable();
            }
        },

        onFormSubmit: function onFormSubmit() {
            if (this.bitbucketAccess.isSelected()) {
                this.addUserForm.append(this.bitbucketGroupsInputField);
            }
        }
    };

    return BitbucketAccessController;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/bitbucket-access/bitbucket-access.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_RESULT__ = function () {
    "use strict";

    var BitbucketAccess = function BitbucketAccess($bitbucketAccessOption, $bitbucketInfoIcon) {
        this.$bitbucketAccessOption = $bitbucketAccessOption;
        this.$bitbucketInfoIcon = $bitbucketInfoIcon;
    };

    BitbucketAccess.prototype = {
        enable: function enable() {
            this.$bitbucketAccessOption.attr('disabled', false);
            this.$bitbucketInfoIcon.addClass('hidden');
        },

        disable: function disable() {
            this.deselect();
            this.$bitbucketAccessOption.attr('disabled', true);
            this.$bitbucketInfoIcon.removeClass('hidden');
        },

        select: function select() {
            this.$bitbucketAccessOption.attr('checked', true);
        },

        deselect: function deselect() {
            this.$bitbucketAccessOption.attr('checked', false);
        },

        isEnabled: function isEnabled() {
            return !this.$bitbucketAccessOption.attr('disabled');
        },

        isSelected: function isSelected() {
            return this.$bitbucketAccessOption.attr('checked');
        }
    };

    return BitbucketAccess;
}.call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "com.atlassian.auiplugin:ajs/require('aui/inline-dialog2')":
/***/ (function(module, exports) {

module.exports = require('aui/inline-dialog2');

/***/ }),

/***/ "jira.webresources:ajs-underscorejs-amd-shim/require('underscore')":
/***/ (function(module, exports) {

module.exports = require('underscore');

/***/ }),

/***/ "jira.webresources:jquery/require('jquery')":
/***/ (function(module, exports) {

module.exports = require('jquery');

/***/ }),

/***/ "jira.webresources:wrm-data/require('wrm/data')":
/***/ (function(module, exports) {

module.exports = require('wrm/data');

/***/ })

});
//# sourceMappingURL=4.js.map