jiraDVCSPluginJsonp([3],{

/***/ "./js/dvcs/bitbucket/views/bitbucket-post-install-approval.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * Encapsulates client side behaviour for "Bitbucket post install approval" action views.
 *
 * @module jira-dvcs-connector/bitbucket/views/bitbucket-post-install-approval
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (require) {
    "use strict";

    var $ = __webpack_require__("jira.webresources:jquery/require('jquery')");
    var Backbone = __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')");
    var DvcsConnectorRestClient = __webpack_require__("./js/dvcs/rest/dvcs-connector-rest-client.js");
    var Navigate = __webpack_require__("./js/dvcs/util/navigate.js");

    return {
        approvalView: Backbone.View.extend({
            el: "#bb-post-install-admin-approval-dialog",
            initialize: function initialize() {
                var $el = this.$el;
                var redirectUrl = $el.data("redirect-url");
                if (redirectUrl) {
                    Navigate.navigate(redirectUrl);
                } else {
                    var baseUrl = $el.data("base-url");
                    var orgId = $el.data("org-id");
                    var grantAccessButtonRedirectUrl = $el.data("grant-access-button-redirect-url");
                    var atlToken = $el.data("atl-token");

                    var restClient = new DvcsConnectorRestClient(baseUrl, atlToken);

                    $el.find("#approve-button").on('click', function (e) {
                        e.preventDefault();

                        restClient.organization.approve(orgId, restClient.organization.ApprovalLocationEnum.DURING_INSTALLATION_FLOW).done(function (data) {
                            Navigate.navigate(grantAccessButtonRedirectUrl);
                        }).fail(function (err, textStatus, errorThrown) {
                            if (err.status === 401) {
                                Navigate.redirectToLogin();
                            } else if (err.status === 403) {
                                Navigate.reload();
                            } else if (err.status === 404) {
                                Navigate.navigate(Navigate.getUrl() + "&approvalError");
                            } else {
                                var errorMessage = encodeURIComponent("Approve Organization AJAX call returned error. Status: " + err.status + "; textStatus: " + textStatus + "; errorThrown: " + errorThrown);
                                Navigate.navigate(Navigate.getUrl() + "&unknownError&unknownErrorMessage=" + errorMessage);
                            }
                        });
                    });
                }
            }
        })
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/rest/dvcs-connector-rest-client.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * Wrapper for DVCS Connector REST endpoints.
 *
 * @module jira-dvcs-connector/rest/dvcs-connector-rest-client
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (jQuery) {
    'use strict';

    var jQuery = __webpack_require__("jira.webresources:jquery/require('jquery')");
    var Navigate = __webpack_require__("./js/dvcs/util/navigate.js");

    /**
     * REST client for working with Organizations
     *
     * @param {string} baseURL The JIRA base URL to use for the client
     * @constructor
     */
    function OrganizationClient(baseURL, atlToken) {
        /**
         * @returns {string} The JIRA base URL for this client
         */
        this.getBaseUrl = function () {
            return baseURL;
        };

        /**
         * @returns {string} The atlToken that this client was initialised with, if any
         */
        this.getAtlToken = function () {
            return atlToken;
        };

        /**
         * @returns {string} A query param with the atl_token value set or empty string depending if atlToken was
         * supplied in the constructor
         */
        this.getAtlTokenQueryParam = function () {
            return atlToken ? '?atl_token=' + encodeURIComponent(atlToken) : '';
        };
    }

    /**
     * Where the approval occurred, direct reflection of the Java implementation in OrganizationApprovalLocation
     * @readonly
     * @enum {string}
     */
    OrganizationClient.prototype.ApprovalLocationEnum = {
        DURING_INSTALLATION_FLOW: 'DURING_INSTALLATION_FLOW',
        ON_ADMIN_SCREEN: 'ON_ADMIN_SCREEN',
        UNKNOWN: 'UNKNOWN'
    },

    /**
     * Approve the scopes for the provided organisation
     *
     * @param {Integer} orgId The ID of the organisation to approve
     * @param {ApprovalLocationEnum} approvalLocation The part of the UI that issued the approval
     * @returns {jqXHR} The JQuery XHR object representing the promise
     */
    OrganizationClient.prototype.approve = function (orgId, approvalLocation) {
        var queryParams = {
            approvalLocation: approvalLocation
        };
        if (this.getAtlToken()) {
            queryParams.atlToken = this.getAtlToken();
        }
        return jQuery.ajax({
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/organization/' + encodeURIComponent(orgId) + '/approve' + Navigate.buildQueryParams(queryParams)
        });
    };

    /**
     * Delete the organization with the specified id
     * @param {integer} orgId the ID of the organization to delete
     * @returns {jqXHR} The JQuery XHR object representing the promise
     */
    OrganizationClient.prototype.remove = function (orgId) {
        return jQuery.ajax({
            type: 'DELETE',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/organization/' + encodeURIComponent(orgId) + this.getAtlTokenQueryParam()
        });
    };

    /**
     * Refresh the organisation repository list
     *
     * @param {integer} orgId the ID of the organisation to refresh
     * @returns {jqXHR} the JQuery XHR object representing the request
     */
    OrganizationClient.prototype.refreshRepositoryList = function (orgId) {
        return jQuery.ajax({
            type: 'GET',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/organization/' + orgId + '/syncRepoList'
        });
    };

    /**
     * Set whether or not new repositories are auto-linked for the provided organization
     *
     * @param {int} orgId The ID of the organization to set
     * @param {boolean} autolink whether to autolink or not
     * @returns {jqXHR} the JQuery XHR object representing the request
     */
    OrganizationClient.prototype.autoLinkRepositories = function (orgId, autolink) {
        return jQuery.ajax({
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/org/' + orgId + '/autolink',
            data: JSON.stringify({
                payload: autolink
            })
        });
    };

    /**
     * Set whether or not smart commits are enabled for new repositories for the provided organization
     *
     * @param {int} orgId The ID of the organization to set
     * @param {boolean} enabled whether to auto-enable smart commits or not
     * @returns {jqXHR} the JQuery XHR object representing the request
     */
    OrganizationClient.prototype.autoEnableSmartCommits = function (orgId, enabled) {
        return jQuery.ajax({
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/org/' + orgId + '/globalsmarts',
            data: JSON.stringify({
                payload: enabled
            })
        });
    };

    /**
     * Update the 'automatically enable X' settings for the given organization.
     *
     * Note that this is the recommended way to update these settings as a unit, rather than calling each
     * of the individual update methods as it avoids race conditions and treats the update as an atomic operation.
     * It is also more efficient than calling each operation individually.
     *
     * @param {int} orgId The ID of the organization to update
     * @param {boolean} enableAutolink whether to auto-link new repositories
     * @param {boolean} enableSmarcommits whether to auto-enable smart commits on new repositories
     * @returns {*}
     */
    OrganizationClient.prototype.updateAutoSettings = function (orgId, enableAutolink, enableSmarcommits) {
        return jQuery.ajax({
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/organization/' + orgId + '/autosettings',
            data: JSON.stringify({
                enableAutolink: enableAutolink,
                enableSmartCommits: enableSmarcommits
            })
        });
    };

    /**
     * retrieve all repositories in given organization
     *
     * @param orgId {int} orgId The ID of the organization to get it repositories
     * @returns {*}
     */
    OrganizationClient.prototype.getRepositories = function (orgId) {
        return jQuery.ajax({
            type: 'GET',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/repository/find?orgId=' + encodeURIComponent(orgId)
        });
    };

    /**
     * REST client for working with the internal Users API
     *
     * @param {string} baseURL The base URL of the JIRA instance the API is for
     *
     * @constructor
     */
    function InternalUserClient(baseURL) {
        /**
         * @returns {string} The JIRA base URL for this client
         */
        this.getBaseUrl = function () {
            return baseURL;
        };
    }

    /**
     * Retrieve the value of the 'has seen feature discovery' flag for the current user
     *
     * @returns {jqXHR} the jQuery XHR object representing the request
     */
    InternalUserClient.prototype.getHasUserSeenFeatureDiscovery = function () {
        console.info("Getting flag!");
        return jQuery.ajax({
            type: 'GET',
            url: this.getBaseUrl() + '/rest/dvcs-connector-internal/1.0/user/flag/featureDiscoverySeen',
            dataType: 'json'
        });
    };

    /**
     * Update the value of the 'has seen feature discovery' flag for the current user
     *
     * @param {boolean} hasSeenFeatureDiscovery The value of the flag to set
     *
     * @returns {jqXHR} the jQuery XHR object representing the request
     */
    InternalUserClient.prototype.setHasUserSeenFeatureDiscovery = function (hasSeenFeatureDiscovery) {
        return jQuery.ajax({
            type: 'PUT',
            url: this.getBaseUrl() + '/rest/dvcs-connector-internal/1.0/user/flag/featureDiscoverySeen',
            dataType: 'json',
            contentType: 'application/json',
            data: JSON.stringify({
                value: hasSeenFeatureDiscovery
            })
        });
    };

    /**
     * A client for interacting with the DVCS Connector REST API
     *
     * @param {string} baseURL The JIRA base URL to use for the client (e.g. http://my.domain.com/jira)
     * @constructor
     */
    function RestClient(baseURL, atlToken) {

        /**
         * The base URL for the JIRA instance this client works with
         */
        this.getBaseUrl = function () {
            return baseURL;
        };

        /**
         * API for working with Organizations
         *
         * @type {OrganizationClient}
         */
        this.organization = new OrganizationClient(baseURL, atlToken);

        /**
         * Internal APIs
         *
         * @type {object}
         */
        this.internal = {

            /**
             * Internal API for working with users
             */
            user: new InternalUserClient(baseURL)
        };
    }

    return RestClient;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/util/navigate.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * A utility module that wraps interactions with the browser location.
 *
 * Abstracts away from the underlying window object which makes client code more testable, and provides utility methods
 * for working with the window location (event-safe redirect etc.). Utilities include:
 * <ul>
 * <li> simple fragment manipulation API that can retrieve and set the fragment part, along with
 *   fragment params that can be added to the fragment without causing a backend page request etc.
 *   e.g. http://myurl.com#urlHash?hashParam=value
 * </li>
 * <li> the ability to append an element id to the url after a double hash, and then retrieve this id later so the
 *   element can be scrolled to after a refresh
 *   e.g. http://myurl.com##elementId
 * </li>
 * </ul>
 *
 * @module jira-dvcs-connector/util/navigate
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("./js/dvcs/util/window.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (_, contextPath, window) {
    "use strict";

    return {
        /**
         * @returns the current URL that is being displayed by the browser
         */
        getUrl: function getUrl() {
            return window.location.href;
        },

        /**
         * @returns {string} The origin of the current page
         */
        getOrigin: function getOrigin() {
            if (window.location.origin) {
                return window.location.origin;
            }
            return window.location.protocol + "//" + window.location.host;
        },

        /**
         * @returns {string} The hash/fragment component of the current window location (if there is one), with hash
         * params etc. stripped from it e.g. "http://example.com/path#hash?key=value" -> "hash"
         */
        getHash: function getHash() {
            if (!window.location.hash) {
                return "";
            }
            var hash = window.location.hash.indexOf('#');
            var query = window.location.hash.indexOf('?');

            return window.location.hash.substring(hash + 1, query > 0 ? query : window.location.hash.length);
        },

        /**
         * Get the hash params for the current window location, if there are any
         *
         * Supports a hash of the form "#hash?key=value&foo=bar" -> {"key":"value", "foo": "bar"}
         *
         * @returns {{}} The map of key=value params encoded in the current window hash (if any)
         */
        getHashParams: function getHashParams() {
            if (!window.location.hash) {
                return {};
            }

            var queryStart = window.location.hash.indexOf('?');
            if (queryStart == -1) {
                return {};
            }

            return _parseParams(window.location.hash.substring(queryStart + 1));
        },

        /**
         * Set the url hash to the hash string provided.
         *
         * e.g. http://abc.com#hash
         *
         * @param hash {string} string to set the url hash to.
         */
        setHash: function setHash(hash) {
            window.location.hash = hash;
        },

        /**
         * Set the url hash to ##<elementId>, so that we can retrieve this id from the url after we refresh the page,
         * and then scroll to it.
         *
         * Just setting the url hash to #<elementId> scrolls the browser
         * to that element, but there are some cross browser issues with that approach, and this is more reliable.
         *
         * @param elementId {string} the id of an element on the page to scroll to after navigation
         */
        setIdToScrollPostRefresh: function setIdToScrollPostRefresh(elementId) {
            window.location.hash = "##" + elementId;
        },

        /**
         * Retrieve the id after a double hash in the url, if it exists, as this represents an element we want
         * to scroll to, assuming we have just refreshed the page.
         *
         * @returns {string, null} the id of the element to scroll to, or null if we haven't set one.
         */
        getIdToScrollToPostRefreshIfExists: function getIdToScrollToPostRefreshIfExists() {
            if (window.location.hash && window.location.hash.substring(0, 2) === "##") {
                return window.location.hash.substring(2);
            } else {
                return null;
            }
        },

        /**
         * Clear the hash component from the window URL
         */
        clearHash: function clearHash() {
            window.location.hash = '';
        },

        /**
         * @returns {{}} The current query params as a hash
         */
        getQueryParams: function getQueryParams() {
            if (!parseUri) {
                // TODO: Implement our own parsing here if needed
                return {};
            }

            return parseUri(window.location.href).queryKey || {};
        },

        /**
         * Turns the supplied hash into a query parameter string, i.e. ? followed by & separated parameters.
         * @param params A hash of params
         * @returns String An empty string if the hash is empty or a query string with the params encoded
         */
        buildQueryParams: function buildQueryParams(params) {
            var queryParams = [];
            for (var param in params) {
                if (param && params.hasOwnProperty(param)) {
                    queryParams.push(encodeURI(param) + '=' + encodeURI(params[param]));
                }
            }

            return queryParams.length === 0 ? '' : '?' + queryParams.join('&');
        },

        /**
         * Triggers browser reload of the page that is currently displayed
         */
        reload: function reload() {
            _.defer(function () {
                window.location.reload();
            });
        },

        /**
         * Make the browser navigate to specified URL after all current events have been processed.
         * @param url to navigate to
         */
        navigate: function navigate(url) {
            _.defer(function () {
                window.location = url;
            });
        },

        /**
         * Redirects user to JIRA login page. After successful login, user will be redirected to the currently
         * displayed page.
         */
        redirectToLogin: function redirectToLogin() {
            this.navigate(contextPath() + '/login.jsp?permissionViolation=true&os_destination=' + encodeURIComponent(window.location.href));
        }
    };

    /**
     * Parse and return parameters from the provided query part
     *
     * @param queryPart The query part to parse - of the form "key=value&foo=bar"
     * @returns {{}}
     * @private
     */
    function _parseParams(queryPart) {
        if (!queryPart) {
            return {};
        }
        var result = {};
        _.each(queryPart.split('&'), function (q) {
            if (!q) {
                return;
            }
            var kv = q.split('=');
            result[kv[0]] = kv[1];
        });
        return result;
    }
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/util/window.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * AMD wrapper around the global Window object.
 *
 * Useful for making modules that depend on the Window more testable.
 *
 * @module jira-dvcs-connector/util/window
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function () {
  "use strict";

  return window;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "jira.webresources:ajs-backbone-amd-shim/require('backbone')":
/***/ (function(module, exports) {

module.exports = require('backbone');

/***/ }),

/***/ "jira.webresources:ajs-underscorejs-amd-shim/require('underscore')":
/***/ (function(module, exports) {

module.exports = require('underscore');

/***/ }),

/***/ "jira.webresources:jquery/require('jquery')":
/***/ (function(module, exports) {

module.exports = require('jquery');

/***/ }),

/***/ "jira.webresources:wrm-context-path/require('wrm/context-path')":
/***/ (function(module, exports) {

module.exports = require('wrm/context-path');

/***/ })

});
//# sourceMappingURL=3.js.map