jiraDVCSPluginJsonp([1,2,7],{

/***/ "./js/dvcs/admin/configure-organization.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * Functions that add behaviour to the Configure Organizations screen.
 * Methods in this module are being migrated here from bitbucket.js
 *
 * @module jira-dvcs-connector/admin/configure-organization
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-logger/require('jira/util/logger')"), __webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')"), __webpack_require__("jira.webresources:jquery/require('jira/jquery/deferred')"), __webpack_require__, __webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("./js/dvcs/lib/aui/messages.js"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("./js/dvcs/util/console.js"), __webpack_require__("./js/dvcs/util/navigate.js"), __webpack_require__("./js/dvcs/util/settings.js"), __webpack_require__("./js/dvcs/admin/view/refresh-account-dialog.js"), __webpack_require__("./js/dvcs/bitbucket/views/connection-successful-dialog.js"), __webpack_require__("./js/dvcs/feature-discovery/feature-discovery-view.js"), __webpack_require__("./js/dvcs/rest/dvcs-connector-rest-client.js"), __webpack_require__("./js/dvcs/analytics/analytics-client.js"), __webpack_require__("./js/dvcs/admin/dvcs-notifications.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (logger, formatter, Deferred, require, contextPath, Messages, $, console, Navigate, LocalSettingsAccessor, RefreshAccountDialog, ConnectionSuccessfulDialog, FeatureDiscovery, DvcsConnectorRestClient, AnalyticsClient, Notification) {

    var restClient = new DvcsConnectorRestClient(contextPath());
    var analyticsClient = new AnalyticsClient();

    return {

        /**
         * Execute the "complete connection" flow.
         *
         * This will:
         *
         * 1. Launch the "Connection Successful" dialog and allow users to set the org's auto settings
         * 2. Refresh the Org's repository list
         * 3. Show the "Feature Discovery" tour if applicable
         * 4. Refresh the page on completion to ensure data is up-to-date
         *
         * @param {int} organizationId The ID of the organization to complete
         * @param {string} [organizationName] The organization name to display. If not provided, will retrieve from the page.
         */
        doFinishConnectionFlow: function doFinishConnectionFlow(organizationId, organizationName) {
            var self = this;
            if (!self._isValidOrganizationId(organizationId)) {
                logger.log('No organization found with ID ' + organizationId);
                return;
            }

            if (!organizationName) {
                organizationName = self._findOrganizationName(organizationId);
            }

            // Launch the connection successful dialog
            var connectionSuccessfulTask = self._showConnectionSuccessDialog(organizationId, organizationName);

            // When it has completed (including updating the auto settings), trigger the
            // repository refresh and feature discovery tour if needed
            connectionSuccessfulTask.done(function () {
                var refreshRepositoryListTask = restClient.organization.refreshRepositoryList(organizationId);

                self.showFeatureDiscovery().always(function () {
                    self._attachUIElementsToRepositoryRefreshTask(refreshRepositoryListTask, organizationId, organizationName);
                });
            });
        },

        /**
         * Trigger a sync of the repository list for the given org.
         *
         * Will launch a dialog+spinner during refresh.
         *
         * @param {int} organizationId
         * @param {string} [organizationName]
         */
        syncRepositoryList: function syncRepositoryList(organizationId, organizationName) {
            var self = this;
            if (!this._isValidOrganizationId(organizationId)) {
                logger.log('No organization found with ID ' + organizationId);
                return;
            }

            if (!organizationName) {
                organizationName = this._findOrganizationName(organizationId);
            }

            var refreshRepositoryListTask = restClient.organization.refreshRepositoryList(organizationId);
            self._attachUIElementsToRepositoryRefreshTask(refreshRepositoryListTask, organizationId, organizationName);
        },

        /**
         * Show the Connection Successful dialog for the provided organization and then trigger refresh of the
         * organization repository list on successful completion of the dialog.
         *
         * On 'submit' will update the autolink/smart commits settings and trigger a refresh of the
         * organization's repository list.
         *
         * @param {int} organizationId The ID of the organization to refresh
         * @param {string} [organizationName] The name of the organization to display.
         *  If not provided will be retrieved from the DOM.
         *
         * @return {Deferred} A deferred object representing the display of the connection successful dialog.
         */
        showConnectionSuccessDialogAndRefresh: function showConnectionSuccessDialogAndRefresh(organizationId, organizationName) {
            var self = this;
            if (!this._isValidOrganizationId(organizationId)) {
                logger.log('No organization found with ID ' + organizationId);
                return Deferred().reject();
            }

            if (!organizationName) {
                organizationName = this._findOrganizationName(organizationId);
            }

            return this._showConnectionSuccessDialog(organizationId, organizationName).done(function () {
                self.syncRepositoryList(organizationId, organizationName);
            });
        },

        /**
         * Shows the feature discovery tour to the user.
         *
         * The returned deferred will always resolve. On completion it will include a flag indicating if the tour
         * was completed or not.
         *
         * @return {Deferred} a deferred object that will complete when the user dismisses the dialog
         */
        showFeatureDiscovery: function showFeatureDiscovery() {
            var deferred = Deferred();

            var localSettings = new LocalSettingsAccessor();
            if (!localSettings.shouldShowFeatureDiscovery()) {
                deferred.resolve(false);
                return deferred;
            }

            var featureDiscovery = new FeatureDiscovery();
            featureDiscovery.on("tourFinished", function () {
                analyticsClient.fireFeatureDiscoveryCompleted();
            }).on("tourAborted", function () {
                analyticsClient.fireFeatureDiscoveryAborted(featureDiscovery.getCurrentPageIndex());
            }).on("closed", function () {
                localSettings.setFeatureDiscoveryShown();
                restClient.internal.user.setHasUserSeenFeatureDiscovery(true).always(function () {
                    deferred.resolve(true);
                });
            });
            analyticsClient.fireFeatureDiscoveryStarted();
            featureDiscovery.show();

            return deferred;
        },

        /**
         * Work out which organization we should scroll to based on the id in the query hash or query params
         * @returns {el} A jquery element that is the element that should be scrolled to
         */
        getOrganizationElementToScrollTo: function getOrganizationElementToScrollTo() {
            var id = Navigate.getIdToScrollToPostRefreshIfExists();
            if (id) {
                return $('#' + id);
            }

            var queryParams = Navigate.getQueryParams();
            var queryPrincipalUuid = queryParams.principalUuid;
            if (queryPrincipalUuid) {
                var principalDataSelector = '[data-org-principal-id="' + queryPrincipalUuid + '"]';
                var organizationElement = $(principalDataSelector);
                analyticsClient.fireConnectOrganizationNavigatedByPrincipal(organizationElement.attr('id'), queryPrincipalUuid);
                return organizationElement;
            }
        },

        /**
         * Show an AUI message where the message handling is specified in the callback.
         *
         * @param {string} message The message to show the user
         * @param {string} [auiMessageElement] The selector for the DOM element to inject the message into
         * @param {boolean} [closeable] Whether the message is closable or not
         * @param callback callback to apply to render the message, this will be set to Messages
         *
         * @private
         */
        _showAuiMessage: function _showAuiMessage(message, auiMessageElement, closeable, callback) {
            if (typeof auiMessageElement == 'undefined') {
                auiMessageElement = "#aui-message-bar-global";
            }

            $(auiMessageElement).empty();
            callback.call(Messages, auiMessageElement, {
                title: message,
                closeable: closeable
            });
        },

        /**
         * Returns if the provided ID matches an organization currently rendered on the page.
         *
         * Note that this method does not do any backend calls and should be used only after page render.
         *
         * @param {int} organizationId The ID to check
         * @returns {boolean} true if the provided ID matches an organization currently rendered on the page; false otherwise.
         *
         * @private
         */
        _isValidOrganizationId: function _isValidOrganizationId(organizationId) {
            var $orgContainer = $('#dvcs-orgdata-container-' + organizationId);
            return $orgContainer.length > 0;
        },

        /**
         * Find the organization name for the organization with the given ID.
         *
         * Will query the DOM.
         *
         * @param {int} organizationId The ID of the organization to find the name for
         * @returns {string|null} The organization name, or null if none is found.
         *
         * @private
         */
        _findOrganizationName: function _findOrganizationName(organizationId) {
            var $orgContainer = $('#dvcs-orgdata-container-' + organizationId);
            if ($orgContainer.length === 0) {
                return null;
            }
            return $orgContainer.data('org-name');
        },

        /**
         * Show the Connection Successful dialog for the provided organization.
         *
         * On 'submit' will update the autolink/smart commits settings for the org based on the user's selections.
         *
         * Returns a deferred object that is tied to the lifecycle of the dialog. This deferred will be rejected if the
         * settings update operation fails ("fail"); otherwise it will be resolved ("done").
         *
         * @param {int} organizationId The ID of the organization to refresh. Assumed to be pre-validated and valid.
         * @param {string} [organizationName] The name of the organization to display.
         *  If not provided will be retrieved from the DOM.
         *
         * @return {Deferred} A deferred object representing the display of the connection successful dialog
         *
         * @private
         */
        _showConnectionSuccessDialog: function _showConnectionSuccessDialog(organizationId, organizationName) {
            var $deferred = Deferred();
            var self = this;
            var connectionSuccessDialog = new ConnectionSuccessfulDialog({
                organizationId: organizationId,
                organizationName: organizationName,
                baseUrl: contextPath(),
                onSuccess: function onSuccess() {
                    Navigate.setIdToScrollPostRefresh("dvcs-orgdata-container-" + organizationId);
                    $deferred.resolve();
                },
                onError: function onError() {
                    Notification.showError(formatter.I18n.getText('com.atlassian.jira.plugins.dvcs.admin.error.unexpected'), "#aui-message-bar-" + organizationId);
                    $deferred.reject();
                }
            });
            connectionSuccessDialog.render();

            return $deferred;
        },

        /**
         * Attach UI elements to a running refresh repository list task.
         *
         * This will bind a RefreshAccountDialog to the task, and trigger a page refresh on completion of the task.
         * In the case of the refresh task failing, will show an appropriate error/warning on the UI.
         *
         * @param refreshRepositoryListTask The task to attach the UI elements to
         * @param organizationId The organization id being refreshed
         * @param organizationName The organization name to display
         * @private
         */
        _attachUIElementsToRepositoryRefreshTask: function _attachUIElementsToRepositoryRefreshTask(refreshRepositoryListTask, organizationId, organizationName) {
            var self = this;

            // Avoid showing the dialog if the task has already failed...
            if ("rejected" === refreshRepositoryListTask.state()) {
                self._showRefreshFailedMessage(refreshRepositoryListTask.statusText, organizationId, organizationName);
                return;
            }

            // Otherwise attach the dialog to the running task...
            //
            // Note that this creates a nicer user experience even if the task has completed
            // it will take some time for the page to refresh, and showing the dialog even if the REST call has
            // completed gives the user feedback that the page refresh is under way.
            var dialog = new RefreshAccountDialog({
                organizationName: organizationName
            });
            dialog.show();

            refreshRepositoryListTask.done(function () {
                Navigate.reload();
            }).fail(function (jqXHR, statusText, errorThrown) {
                self._showRefreshFailedMessage(statusText, organizationId, organizationName);
                dialog.hide();
            });
        },

        /**
         * Show the refresh list failed message based.
         *
         * @param statusText The status of the failed task. Used to determine what message to show.
         * @param organizationId The ID of the org the refresh failed for
         * @param organizationName The name of the org the refresh failed for
         * @private
         */
        _showRefreshFailedMessage: function _showRefreshFailedMessage(statusText, organizationId, organizationName) {
            if ("timeout" === statusText) {
                Notification.showWarning(formatter.I18n.getText('com.atlassian.jira.plugins.dvcs.admin.error.refresh-timed-out', organizationName), "#aui-message-bar-" + organizationId);
            } else {
                Notification.showError(formatter.I18n.getText('com.atlassian.jira.plugins.dvcs.admin.error.refresh-failed', organizationName), "#aui-message-bar-" + organizationId);
            }
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/admin/dvcs-notifications.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * Warning and error notifications for use with the configure accounts screen
 *
 * @module jira-dvcs-connector/admin/dvcs-notifications
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (require) {
    "use strict";

    var $ = __webpack_require__("jira.webresources:jquery/require('jquery')");
    var Messages = __webpack_require__("./js/dvcs/lib/aui/messages.js");

    return {
        /**
         * Show an AUI error message on the DVCS Accounts admin page
         *
         * @param {string} message The message to show the user
         * @param {string} [auiMessageElement] The selector for the DOM element to inject the message into
         * @param {boolean} [closeable] Whether the message is closable or not
         */
        showError: function showError(message, auiMessageElement, closeable) {
            this.showAuiMessage(message, auiMessageElement, closeable, Messages.error);
        },

        /**
         * Show an AUI warning message on the DVCS Accounts admin page
         *
         * @param {string} message The message to show the user
         * @param {string} [auiMessageElement] The selector for the DOM element to inject the message into
         * @param {boolean} [closeable] Whether the message is closable or not
         */
        showWarning: function showWarning(message, auiMessageElement, closeable) {
            this.showAuiMessage(message, auiMessageElement, closeable, Messages.warning);
        },

        /**
         * Show an AUI message where the message handling is specified in the callback.
         *
         * @param {string} message The message to show the user
         * @param {string} [auiMessageElement] The selector for the DOM element to inject the message into
         * @param {boolean} [closeable] Whether the message is closable or not
         * @param callback callback to apply to render the message, this will be set to Messages
         */
        showAuiMessage: function showAuiMessage(message, auiMessageElement, closeable, callback) {
            if (typeof auiMessageElement == 'undefined') {
                auiMessageElement = "#aui-message-bar-global";
            }

            $(auiMessageElement).empty();
            callback.call(Messages, auiMessageElement, {
                title: message,
                closeable: closeable
            });
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/admin/view/refresh-account-dialog.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * A view that shows the 'Refreshing account' spinner dialog
 *
 * @module jira-dvcs-connector/admin/view/refresh-account-dialog
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (require) {
    'use strict';

    var Backbone = __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')");
    var Dialog = __webpack_require__("./js/dvcs/lib/aui/dialog.js");

    return Backbone.View.extend({

        initialize: function initialize(options) {
            this.dialog = new Dialog({
                width: 400,
                height: 150,
                id: "refreshing-account-dialog",
                closeOnOutsideClick: false
            });
            this.dialog.addHeader('Refreshing Account');
            this.dialog.addPanel("RefreshPanel", this._renderPanelContent(options.organizationName));
        },

        show: function show() {
            this.dialog.show();
            this.dialog.updateHeight();
        },

        hide: function hide() {
            this.dialog.remove();
        },

        _renderPanelContent: function _renderPanelContent(organizationName) {
            return "<p>Refreshing '" + organizationName + "' account. Please wait... <span class='aui-icon aui-icon-wait'>&nbsp;</span></p>";
        }

    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/analytics/analytics-client.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * Presents an API for making analytics calls for the various DVCS Connector analytics events.
 *
 * @module jira-dvcs-connector/analytics/analytics-client
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function () {

    var trigger = __webpack_require__("./js/dvcs/lib/aui/trigger.js");

    return function AnalyticsClient() {

        /**
         * Fire an analytics event that represents the user performing the initial configuration of their Organization
         * @param {number} organizationId The organization that was just configured
         */
        this.fireConfigCompleted = function (organizationId, autoLinkReposEnabled, smartCommitsEnabled) {
            _fireEvent('jira.dvcsconnector.organization.initial.config.completed', {
                organizationId: organizationId,
                autoLinkRepos: autoLinkReposEnabled,
                smartCommits: smartCommitsEnabled
            });
        };

        /**
         * Fire an analytics event that indicates a feature discovery tour was started
         */
        this.fireFeatureDiscoveryStarted = function () {
            _fireEvent('jira.dvcsconnector.featurediscovery.started');
        };

        /**
         * Fire an analytics event that indicates a feature discovery tour was completed
         */
        this.fireFeatureDiscoveryCompleted = function () {
            _fireEvent('jira.dvcsconnector.featurediscovery.completed');
        };

        /**
         * Fire an analytics event that indicates a feature discovery tour was aborted
         *
         * @param {number} pageIndex the page index the tour was aborted on
         */
        this.fireFeatureDiscoveryAborted = function (pageIndex) {
            _fireEvent('jira.dvcsconnector.featurediscovery.aborted', {
                pageIndex: pageIndex
            });
        };

        /**
         * Fire an analytics event that indicates a pending org was removed by an admin (rather than approved)
         *
         * @param {number} organizationId the organization that was removed
         */
        this.firePendingOrgRemoved = function (organizationId) {
            _fireEvent('jira.dvcsconnector.connect.organization.pending.removed', {
                organizationId: organizationId
            });
        };

        /**
         * Fire an analytics event that represents the user performing the initial configuration of their Organization
         * @param {number} organizationId The organization that was just configured
         */
        this.fireDefaultSettingsChanged = function (organizationId, autoLinkReposEnabled, smartCommitsEnabled) {
            _fireEvent('jira.dvcsconnector.organization.default.settings.changed', {
                organizationId: organizationId,
                autoLinkRepos: autoLinkReposEnabled,
                smartCommits: smartCommitsEnabled
            });
        };

        /**
         * Fire an analytics event that indicates the principal uuid was passed as query parameter which happens
         * if the user clicked configure from bitbucket
         * @param organizationId The Organization which is to be focused
         * @param principalUuid The principal uuid from Bitbucket which was included in the url
         */
        this.fireConnectOrganizationNavigatedByPrincipal = function (organizationId, principalUuid) {
            _fireEvent('jira.dvcsconnector.connect.organization.principal.navigation', {
                organizationId: organizationId,
                principalUuid: principalUuid
            });
        };
    };

    function _fireEvent(name, data) {
        trigger('analyticsEvent', {
            name: name,
            data: data || {}
        });
    }
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/bitbucket/rest/bitbucket-client.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * An API client for working with Bitbucket Cloud
 *
 * @see https://confluence.atlassian.com/bitbucket/use-the-bitbucket-cloud-rest-apis-222724129.html
 *
 * @module jira-dvcs-connector/bitbucket-client
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function () {

  var BITBUCKET_URL = "https://bitbucket.org";

  /**
   * Create a new client with the given optional Bitbucket URL.
   *
   * If no URL is provided, will use the default public Bitbucket URL.
   *
   * @param {string} [bitbucketUrl] The bitbucket URL to use for the client
   * @constructor
   */
  return function Client(bitbucketUrl) {

    if (!bitbucketUrl) {
      bitbucketUrl = BITBUCKET_URL;
    }

    /**
     * The URL this client instance will use to contact Bitbucket
     */
    this.bitbucketUrl = bitbucketUrl;

    /**
     * API for working with Connect addons.
     */
    this.addons = {

      /**
       * Generate a URL that can be used to redirect to the authorize addon page in Bitbucket.
       *
       * The provided URIs should be passed un-encoded.
       *
       * @param descriptorUri The URL for the addon descriptor to be installed
       * @param redirectUri The URL to redirect to after authorization
       */
      generateAddonAuthorizeRedirect: function generateAddonAuthorizeRedirect(descriptorUri, redirectUri) {

        var authorizeUrl = bitbucketUrl + '/site/addons/authorize';
        return authorizeUrl + '?descriptor_uri=' + encodeURIComponent(descriptorUri) + '&redirect_uri=' + encodeURIComponent(redirectUri);
      }
    };
  };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/bitbucket/views/connection-successful-dialog.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * The 'connection successful' dialog shown on successful approval of a Bitbucket organization connected
 * with easy connect.
 *
 * @module jira-dvcs-connector/bitbucket/views/connection-successful
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (require) {
    "use strict";

    __webpack_require__(7);
    __webpack_require__(8);
    __webpack_require__(1);
    __webpack_require__(4);
    __webpack_require__(2);
    __webpack_require__(3);
    __webpack_require__(5);

    var dialog2 = __webpack_require__("./js/dvcs/lib/aui/dialog2.js");
    var ConfigDialog = __webpack_require__("./js/dvcs/bitbucket/views/repo-config-dialog.js");
    var AnalyticsClient = __webpack_require__("./js/dvcs/analytics/analytics-client.js");
    var analyticsClient = new AnalyticsClient();

    /**
     * A view that will render the Connection Successful dialog into the page and show it.
     */
    return ConfigDialog.extend({

        template: JIRA.Templates.DVCSConnector.Bitbucket.connectionSuccessfulDialog,
        events: {
            'click #dialog-submit-button': '_submit'
        },

        /**
         * Initialize the view. Invoked on construction of a new view instance.
         *
         * @param {Object} options - Initialization options
         * @param {int} options.organizationId - The ID of the organization the dialog is for
         * @param {string} options.organizationName - The organization name to display on the dialog
         * @param {string} options.baseUrl - The JIRA base URL to use when updating the organization
         * @param {function} options.onSuccess - A callback to invoke on successful update of
         *  autolink/smartcommits settings
         * @param {function} options.onError - A callback to invoke on failed update of autolink/smartcommits settings
         */
        initialize: function initialize(options) {
            this.orgId = options.organizationId;
            this.onSuccess = options.onSuccess;
            this.onError = options.onError;

            this.dialog = dialog2(this.template({
                organizationName: options.organizationName
            }));
            this._initialize();
        },

        _submit: function _submit() {
            this.$submitSpinner.toggleClass('hidden');
            this.$submitButton.attr('disabled', 'disabled');
            this.$autolinkCheckbox.attr('disabled', 'disabled');
            this.$smartCommitsCheckbox.attr('disabled', 'disabled');

            this.submitUpdates(analyticsClient.fireConfigCompleted);
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/bitbucket/views/repo-config-dialog.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * The parent dialogue for configuring the default behaviour of a repository
 *
 * @module jira-dvcs-connector/bitbucket/views/repo-config-dialog
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (require) {
    "use strict";

    var $ = __webpack_require__("jira.webresources:jquery/require('jquery')");
    var Backbone = __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')");
    var dialog2 = __webpack_require__("./js/dvcs/lib/aui/dialog2.js");

    var DvcsConnectorRestClient = __webpack_require__("./js/dvcs/rest/dvcs-connector-rest-client.js");
    var contextPath = __webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')");
    var _ = __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')");
    var restClient = new DvcsConnectorRestClient(contextPath());

    /**
     * A view that will render the Connection Successful dialog into the page and show it.
     */
    return Backbone.View.extend({

        /**
         * Show the dialog
         *
         * @returns {repo-config-dialog} The view instance to support method chaining
         */
        render: function render() {
            this.dialog.show();
            return this;
        },

        _initialize: function _initialize() {
            this.setElement(this.dialog.$el);

            this.$submitButton = this.$el.find('#dialog-submit-button');
            this.$submitSpinner = this.$el.find('#dialog-submit-spinner');
            this.$autolinkCheckbox = this.$el.find('#autolink-checkbox');
            this.$smartCommitsCheckbox = this.$el.find('#smartcommits-checkbox');

            this.dialog.on('show', this._show.bind(this));
            this.dialog.on('hide', this._cleanup.bind(this));
        },

        submitUpdates: function submitUpdates(analyticsFunction, dontHideDialog) {
            var self = this;
            self._toggleSpinnerAndElements(false);

            var autoLinkReposEnabled = this._autoLinkReposEnabled();
            var smartCommitsEnabled = this._smartCommitsEnabled();
            var updateRequest = restClient.organization.updateAutoSettings(this.orgId, autoLinkReposEnabled, smartCommitsEnabled);
            $.when(updateRequest).done(function () {
                self.dialog.hide();
                if (self.onSuccess) {
                    self.onSuccess({
                        autoLinkReposEnabled: autoLinkReposEnabled,
                        smartCommitsEnabled: smartCommitsEnabled
                    });
                }
            }).fail(function () {
                if (!dontHideDialog) {
                    self.dialog.hide();
                } else {
                    self._toggleSpinnerAndElements(true);
                }
                if (self.onError) {
                    self.onError();
                }
            });

            if (_.isFunction(analyticsFunction)) {
                analyticsFunction(this.orgId, autoLinkReposEnabled, smartCommitsEnabled);
            }
        },

        _toggleSpinnerAndElements: function _toggleSpinnerAndElements(showSpinner) {
            var self = this;
            self.$submitSpinner.toggleClass('hidden');
            self.$submitButton.prop('disabled', showSpinner ? false : 'disabled');
            self.$autolinkCheckbox.prop('disabled', showSpinner ? false : 'disabled');
            self.$smartCommitsCheckbox.prop('disabled', showSpinner ? false : 'disabled');
        },

        _show: function _show() {},

        _cleanup: function _cleanup() {
            this.remove();
            this.dialog.remove();
        },

        _autoLinkReposEnabled: function _autoLinkReposEnabled() {
            return this.$autolinkCheckbox.is(':checked');
        },

        _smartCommitsEnabled: function _smartCommitsEnabled() {
            return this.$smartCommitsCheckbox.is(':checked');
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/feature-discovery/feature-discovery-view.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * The view that shows the DVCS Connector feature discovery wizard
 *
 * @module jira-dvcs-connector/feature-discovery/feature-discovery-view
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__, __webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("./js/dvcs/lib/aui/dialog2.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (require, formatter, Backbone, dialog2) {
    'use strict';

    __webpack_require__(9);

    __webpack_require__(4);
    __webpack_require__(1);
    __webpack_require__(2);
    __webpack_require__(3);

    var FEATURE_DISCOVERY_PAGES = [{
        pageName: "clearer-picture",
        headingText: formatter.I18n.getText("com.atlassian.jira.plugins.dvcs.featurediscovery.clearer-picture.heading"),
        bodyText: formatter.I18n.getText("com.atlassian.jira.plugins.dvcs.featurediscovery.clearer-picture.text"),
        imageClass: "dvcs-feature-discovery-clearer-picture-img"
    }, {
        pageName: "do-once",
        headingText: formatter.I18n.getText("com.atlassian.jira.plugins.dvcs.featurediscovery.do-once.heading"),
        bodyText: formatter.I18n.getText("com.atlassian.jira.plugins.dvcs.featurediscovery.do-once.text"),
        imageClass: "dvcs-feature-discovery-do-once-img"
    }, {
        pageName: "release-with-confidence",
        headingText: formatter.I18n.getText("com.atlassian.jira.plugins.dvcs.featurediscovery.release.heading"),
        bodyText: formatter.I18n.getText("com.atlassian.jira.plugins.dvcs.featurediscovery.release.text"),
        imageClass: "dvcs-feature-discovery-release-img"
    }];

    /**
     * The Feature Discovery dialog view
     *
     * Events:
     * - tourFinished: Emitted when a user reaches the end of the tour and clicks the action button
     * - tourAborted: Emitted when a user closes the tour without reaching the end (e.g. ESC, or close)
     * - pageChanged: Emitted when the tour page changes
     * - close: Emitted when the tour is closed (after the tourFinished/tourAborted events)
     */
    return Backbone.View.extend({

        events: {
            "aui-tour-finish aui-tour": "_triggerTourFinished",
            "aui-tour-page-change aui-tour": "_handleTourPageChange",
            "click .aui-dialog2-header-close": "_triggerTourAborted",
            "click .aui-tour-next": "_handlePageChangeClick",
            "click .aui-tour-prev": "_handlePageChangeClick",
            "click .aui-tour-page-indicator a": "_handlePageChangeClick"
        },

        template: JIRA.Templates.DVCSConnector.FeatureDiscovery.dialog,

        initialize: function initialize() {
            this.dialog = dialog2(this.template({ pages: FEATURE_DISCOVERY_PAGES }));

            this.$el = this.dialog.$el;

            // In some browsers a page change event is fired on show
            // We want to track if a user has actually changed the page in order to do the correct
            // show/hide of link elements
            this._userHasTriggeredActualPageChange = false;

            // This relies on the fact that tour completion triggers a 'remove' event on the dialog rather than a 'hide'
            this.dialog.on("hide", this._triggerTourAborted.bind(this));
        },

        /**
         * Show the feature discovery dialog.
         *
         * @returns {FeatureDiscovery} the Feature Discovery instance
         */
        show: function show() {
            this.dialog.show();
            this._hideNonVisibleTabbableElements();
            this._setFocusOnNext();
            return this;
        },

        /**
         * Closes the feature discovery dialog and cleans up resources.
         *
         * Once closed do not interact with the feature discovery instance
         * as it will be in an invalid state.
         */
        close: function close() {
            this.remove();
            this.dialog.remove();
            this.trigger("closed");
        },

        /**
         * Get the current page the tour is on
         *
         * @returns {String} The name of the current page the tour is on
         */
        getCurrentPageName: function getCurrentPageName() {
            return FEATURE_DISCOVERY_PAGES[this.getCurrentPageIndex()].pageName;
        },

        /**
         * Get the (0-indexed) index of the current page the tour is on
         *
         * @returns {number} The index of the current page the tour is on
         */
        getCurrentPageIndex: function getCurrentPageIndex() {
            return Number(this.$el.find('aui-tour').attr('page'));
        },

        _handleTourPageChange: function _handleTourPageChange() {
            if (!this._userHasTriggeredActualPageChange) {
                this._hideNonVisibleTabbableElements();
                return;
            }

            // This is a workaround for a bug where tabbable elements on tour pages can be tabbed to,
            // which breaks the tour appearance.
            // Sets all links to hidden once the transition animation has completed
            var self = this;
            this._showTabbableElements();
            this.$el.find("div.aui-tour-content").one('webkitTransitionEnd otransitionend oTransitionEnd transitionend', function () {
                self._hideNonVisibleTabbableElements();
            });

            this.trigger("pageChanged");
        },

        _handlePageChangeClick: function _handlePageChangeClick() {
            // The first time a user actually triggers a page change,
            // run the tour page changed logic (which will have been skipped to
            // account for some browsers that fire a page change event on show)
            if (!this._userHasTriggeredActualPageChange) {
                this._userHasTriggeredActualPageChange = true;
                this._handleTourPageChange();
            }
        },

        _triggerTourFinished: function _triggerTourFinished() {
            this.trigger("tourFinished");
            this.close();
        },

        _triggerTourAborted: function _triggerTourAborted() {
            this.trigger("tourAborted");
            this.close();
        },

        _showTabbableElements: function _showTabbableElements() {
            this.$el.find('div.aui-tour-page div.dvcs-feature-discovery-link-container').removeClass('hidden');
            this.trigger("_pageLinkElementsShown");
        },

        _hideNonVisibleTabbableElements: function _hideNonVisibleTabbableElements() {
            this.$el.find('div.aui-tour-page[aria-hidden="true"] div.dvcs-feature-discovery-link-container').addClass('hidden');
            this.trigger("_pageLinkElementsHidden");
        },

        _setFocusOnNext: function _setFocusOnNext() {
            var $nextButton = this.$el.find('.aui-tour-next');
            if ($nextButton.length == 0) {
                setTimeout(this._setFocusOnNext.bind(this), 100);
            }
            $nextButton.focus();
        }

    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/lib/aui/dialog.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * An AMD wrapper around the AUI Dialog type
 *
 * @module jira-dvcs-connector/aui/dialog
 * @deprecated
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function () {
  'use strict';

  return AJS.Dialog;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/lib/aui/dialog2.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * AMD wrapper for the AUI Dialog2 component
 *
 * @module jira-dvcs-connector/aui/dialog2
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function () {
  'use strict';

  return AJS.dialog2;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/lib/aui/messages.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * AMD wrapper around the AUI messages mechanism
 *
 * @module jira-dvcs-connector/aui/messages
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:aui-core-amd-shim/require('aui/message')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (AuiMessages) {
  return AuiMessages;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/lib/aui/trigger.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * AMD wrapper around the aui trigger mechanism. Prefixed with dvcs as aui/trigger seems to conflict with something in
 * aui
 *
 * @module jira-dvcs-connector/aui/trigger
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function () {
  return AJS.trigger;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/random/bitbucket.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-analytics-amd/require('jira/analytics')"), exports, __webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (analytics, exports, $) {
    /**
     * Supported DVCS types.
     *
     * @readonly
     * @enum {string}
     */
    exports.DvcsType = {
        BITBUCKET: 'bitbucket',
        GITHUB: 'github',
        GITHUB_ENTERPRISE: 'githube'
    };

    /**
     * Supported DVCS providers, keyed by DvcsType
     * @readonly
     */
    exports.DvcsProviders = {
        bitbucket: {
            actionPath: '/secure/admin/AddBitbucketOrganization.jspa',
            hostUrl: function hostUrl() {
                if (dvcs.connector.plugin.bitbucketOverrideUrl) {
                    return dvcs.connector.plugin.bitbucketOverrideUrl;
                }
                return 'https://bitbucket.org';
            }
        },
        github: {
            actionPath: '/secure/admin/AddGithubOrganization.jspa',
            hostUrl: function hostUrl() {
                return 'https://github.com';
            }
        },
        githube: {
            actionPath: '/secure/admin/AddGithubEnterpriseOrganization.jspa',
            hostUrl: function hostUrl() {
                return 'https://github.com';
            }
        }
    };

    //--------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------

    function showError(message, auiMessageElement, closeable) {
        if (typeof auiMessageElement == 'undefined') {
            auiMessageElement = "#aui-message-bar-global";
        }

        $(auiMessageElement).empty();
        AJS.messages.error(auiMessageElement, {
            title: message,
            closeable: closeable
        });
    }
    exports.showError = showError;

    exports.setChecked = function setChecked(checkboxId, checked) {
        if (checked) {
            $("#" + checkboxId).attr("checked", "checked");
        } else {
            $("#" + checkboxId).removeAttr("checked");
        }
    };

    //--------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------

    function triggerAnalyticsEvent(eventType) {
        if (AJS.EventQueue) {
            analytics.send({
                name: "jira.dvcsconnector.config." + eventType,
                properties: { source: $("#dvcs-connect-source").data("sourceOrDefault") }
            });
        }
    }
    exports.triggerAnalyticsEvent = triggerAnalyticsEvent;

    return exports;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/rest/dvcs-connector-rest-client.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * Wrapper for DVCS Connector REST endpoints.
 *
 * @module jira-dvcs-connector/rest/dvcs-connector-rest-client
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (jQuery) {
    'use strict';

    var jQuery = __webpack_require__("jira.webresources:jquery/require('jquery')");
    var Navigate = __webpack_require__("./js/dvcs/util/navigate.js");

    /**
     * REST client for working with Organizations
     *
     * @param {string} baseURL The JIRA base URL to use for the client
     * @constructor
     */
    function OrganizationClient(baseURL, atlToken) {
        /**
         * @returns {string} The JIRA base URL for this client
         */
        this.getBaseUrl = function () {
            return baseURL;
        };

        /**
         * @returns {string} The atlToken that this client was initialised with, if any
         */
        this.getAtlToken = function () {
            return atlToken;
        };

        /**
         * @returns {string} A query param with the atl_token value set or empty string depending if atlToken was
         * supplied in the constructor
         */
        this.getAtlTokenQueryParam = function () {
            return atlToken ? '?atl_token=' + encodeURIComponent(atlToken) : '';
        };
    }

    /**
     * Where the approval occurred, direct reflection of the Java implementation in OrganizationApprovalLocation
     * @readonly
     * @enum {string}
     */
    OrganizationClient.prototype.ApprovalLocationEnum = {
        DURING_INSTALLATION_FLOW: 'DURING_INSTALLATION_FLOW',
        ON_ADMIN_SCREEN: 'ON_ADMIN_SCREEN',
        UNKNOWN: 'UNKNOWN'
    },

    /**
     * Approve the scopes for the provided organisation
     *
     * @param {Integer} orgId The ID of the organisation to approve
     * @param {ApprovalLocationEnum} approvalLocation The part of the UI that issued the approval
     * @returns {jqXHR} The JQuery XHR object representing the promise
     */
    OrganizationClient.prototype.approve = function (orgId, approvalLocation) {
        var queryParams = {
            approvalLocation: approvalLocation
        };
        if (this.getAtlToken()) {
            queryParams.atlToken = this.getAtlToken();
        }
        return jQuery.ajax({
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/organization/' + encodeURIComponent(orgId) + '/approve' + Navigate.buildQueryParams(queryParams)
        });
    };

    /**
     * Delete the organization with the specified id
     * @param {integer} orgId the ID of the organization to delete
     * @returns {jqXHR} The JQuery XHR object representing the promise
     */
    OrganizationClient.prototype.remove = function (orgId) {
        return jQuery.ajax({
            type: 'DELETE',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/organization/' + encodeURIComponent(orgId) + this.getAtlTokenQueryParam()
        });
    };

    /**
     * Refresh the organisation repository list
     *
     * @param {integer} orgId the ID of the organisation to refresh
     * @returns {jqXHR} the JQuery XHR object representing the request
     */
    OrganizationClient.prototype.refreshRepositoryList = function (orgId) {
        return jQuery.ajax({
            type: 'GET',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/organization/' + orgId + '/syncRepoList'
        });
    };

    /**
     * Set whether or not new repositories are auto-linked for the provided organization
     *
     * @param {int} orgId The ID of the organization to set
     * @param {boolean} autolink whether to autolink or not
     * @returns {jqXHR} the JQuery XHR object representing the request
     */
    OrganizationClient.prototype.autoLinkRepositories = function (orgId, autolink) {
        return jQuery.ajax({
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/org/' + orgId + '/autolink',
            data: JSON.stringify({
                payload: autolink
            })
        });
    };

    /**
     * Set whether or not smart commits are enabled for new repositories for the provided organization
     *
     * @param {int} orgId The ID of the organization to set
     * @param {boolean} enabled whether to auto-enable smart commits or not
     * @returns {jqXHR} the JQuery XHR object representing the request
     */
    OrganizationClient.prototype.autoEnableSmartCommits = function (orgId, enabled) {
        return jQuery.ajax({
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/org/' + orgId + '/globalsmarts',
            data: JSON.stringify({
                payload: enabled
            })
        });
    };

    /**
     * Update the 'automatically enable X' settings for the given organization.
     *
     * Note that this is the recommended way to update these settings as a unit, rather than calling each
     * of the individual update methods as it avoids race conditions and treats the update as an atomic operation.
     * It is also more efficient than calling each operation individually.
     *
     * @param {int} orgId The ID of the organization to update
     * @param {boolean} enableAutolink whether to auto-link new repositories
     * @param {boolean} enableSmarcommits whether to auto-enable smart commits on new repositories
     * @returns {*}
     */
    OrganizationClient.prototype.updateAutoSettings = function (orgId, enableAutolink, enableSmarcommits) {
        return jQuery.ajax({
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/organization/' + orgId + '/autosettings',
            data: JSON.stringify({
                enableAutolink: enableAutolink,
                enableSmartCommits: enableSmarcommits
            })
        });
    };

    /**
     * retrieve all repositories in given organization
     *
     * @param orgId {int} orgId The ID of the organization to get it repositories
     * @returns {*}
     */
    OrganizationClient.prototype.getRepositories = function (orgId) {
        return jQuery.ajax({
            type: 'GET',
            url: this.getBaseUrl() + '/rest/bitbucket/1.0/repository/find?orgId=' + encodeURIComponent(orgId)
        });
    };

    /**
     * REST client for working with the internal Users API
     *
     * @param {string} baseURL The base URL of the JIRA instance the API is for
     *
     * @constructor
     */
    function InternalUserClient(baseURL) {
        /**
         * @returns {string} The JIRA base URL for this client
         */
        this.getBaseUrl = function () {
            return baseURL;
        };
    }

    /**
     * Retrieve the value of the 'has seen feature discovery' flag for the current user
     *
     * @returns {jqXHR} the jQuery XHR object representing the request
     */
    InternalUserClient.prototype.getHasUserSeenFeatureDiscovery = function () {
        console.info("Getting flag!");
        return jQuery.ajax({
            type: 'GET',
            url: this.getBaseUrl() + '/rest/dvcs-connector-internal/1.0/user/flag/featureDiscoverySeen',
            dataType: 'json'
        });
    };

    /**
     * Update the value of the 'has seen feature discovery' flag for the current user
     *
     * @param {boolean} hasSeenFeatureDiscovery The value of the flag to set
     *
     * @returns {jqXHR} the jQuery XHR object representing the request
     */
    InternalUserClient.prototype.setHasUserSeenFeatureDiscovery = function (hasSeenFeatureDiscovery) {
        return jQuery.ajax({
            type: 'PUT',
            url: this.getBaseUrl() + '/rest/dvcs-connector-internal/1.0/user/flag/featureDiscoverySeen',
            dataType: 'json',
            contentType: 'application/json',
            data: JSON.stringify({
                value: hasSeenFeatureDiscovery
            })
        });
    };

    /**
     * A client for interacting with the DVCS Connector REST API
     *
     * @param {string} baseURL The JIRA base URL to use for the client (e.g. http://my.domain.com/jira)
     * @constructor
     */
    function RestClient(baseURL, atlToken) {

        /**
         * The base URL for the JIRA instance this client works with
         */
        this.getBaseUrl = function () {
            return baseURL;
        };

        /**
         * API for working with Organizations
         *
         * @type {OrganizationClient}
         */
        this.organization = new OrganizationClient(baseURL, atlToken);

        /**
         * Internal APIs
         *
         * @type {object}
         */
        this.internal = {

            /**
             * Internal API for working with users
             */
            user: new InternalUserClient(baseURL)
        };
    }

    return RestClient;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/ui/showRepoDialog.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__, __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("./js/dvcs/lib/aui/dialog.js"), __webpack_require__("./js/dvcs/lib/aui/messages.js"), __webpack_require__("./js/dvcs/random/bitbucket.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (require, $, AJSDialog, AJSMessages, bitbucketRandom) {
    __webpack_require__(6);
    __webpack_require__(1);
    __webpack_require__(4);
    __webpack_require__(2);
    __webpack_require__(3);
    __webpack_require__(5);

    // DVCS Validator
    function DvcsValidator() {

        this.validatedItems = [];
        this.valid = true;
    }

    DvcsValidator.clearAllErrors = function () {
        $(".dvcs-error").each(function (index, item) {
            $(item).hide();
        });
    };

    DvcsValidator.prototype.addItem = function (valuableInputId, errorElementId, rule) {

        this.validatedItems.push({
            "errorElementId": errorElementId,
            "valuableInputId": valuableInputId,
            "rule": rule,
            "valid": true
        });
    };

    DvcsValidator.prototype.runValidation = function () {

        DvcsValidator.clearAllErrors();

        for (var index in this.validatedItems) {

            var value = this.validatedItems[index];

            // if field has more validators, skip other validations in case of first invalidity
            if (!value.valid) {
                continue;
            }

            var jqElement = $("#" + value.valuableInputId);

            // rule required
            if (value.rule === "required" && !jqElement.val()) {
                var jqElementError = $("#" + value.errorElementId);
                jqElementError.show();
                value.valid = false;

                this.valid = false;
            }
            // rule URL
            else if (value.rule === "url" && jqElement.val() && !this._URL_REGEX.test(jqElement.val())) {
                    var _jqElementError = $("#" + value.errorElementId);
                    _jqElementError.show();
                    value.valid = false;

                    this.valid = false;
                }
        }

        return this.valid;
    };

    DvcsValidator.prototype._URL_REGEX = /(http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/;

    function parseAccountUrl(url) {
        var pattern = /(.*)\/(.+?)\/?$/;
        var matches = url.match(pattern);
        if (matches) return { hostUrl: matches[1], name: matches[2] };
    }

    var dvcsSubmitFormAjaxHandler = {
        "bitbucket": function bitbucket(data) {
            $("#repoEntry").attr("action", dvcs.connector.plugin.BASE_URL + "/secure/admin/AddBitbucketOrganization.jspa");
            $('#repoEntry').submit();
        },

        "github": function github(data) {
            $("#repoEntry").attr("action", dvcs.connector.plugin.BASE_URL + "/secure/admin/AddGithubOrganization.jspa");
            $('#repoEntry').submit();
        }
    };

    function validateAccountInfoForm() {
        var validator = new DvcsValidator();
        validator.addItem("organization", "org-error", "required");
        return validator.runValidation();
    }

    function validateAddOrganizationForm() {
        var validator = new DvcsValidator();
        validator.addItem("organization", "org-error", "required");

        if ($("#oauthClientIdGhe").is(":visible")) {
            validator.addItem("urlGhe", "ghe-url-error", "required");
            validator.addItem("urlGhe", "ghe-invalid-url-error", "url");
            validator.addItem("oauthClientIdGhe", "oauth-ghe-client-error", "required");
            validator.addItem("oauthSecretGhe", "oauth-ghe-secret-error", "required");
        } else if ($("#oauthBbClientId").is(":visible")) {
            validator.addItem("oauthBbClientId", "oauth-bb-client-error", "required");
            validator.addItem("oauthBbSecret", "oauth-bb-secret-error", "required");
        } else if ($("#oauthClientId").is(":visible")) {
            validator.addItem("oauthClientId", "oauth-gh-client-error", "required");
            validator.addItem("oauthSecret", "oauth-gh-secret-error", "required");
        } else if ($("#adminUsername").is(":visible")) {
            // validator.addItem("adminUsername", "admin-username-error", "required");
            // validator.addItem("adminPassword", "admin-password-error", "required");
        }
        return validator.runValidation();
    }

    function dvcsSubmitFormHandler(event, skipLoggingAlert) {
        var dialog = dvcs.connector.plugin.addOrganizationDialog;
        // submit form
        var organizationElement = $("#organization");
        // if not custom URL
        if (!parseAccountUrl(organizationElement.val())) {
            // some really simple validation
            if (!validateAddOrganizationForm()) {
                dialog.enabled(true);
                dialog.updateHeight();
                return false;
            }
            var selectedDvcs = $("#urlSelect option:selected");
            var dvcsHost = selectedDvcs.text();

            if (selectedDvcs.val() == bitbucketRandom.DvcsType.GITHUB_ENTERPRISE) {
                // impose real URL to hidden input
                $("#url").val($("#urlGhe").val());

                if (!skipLoggingAlert) {
                    $("#githubeConfirmation").html(dvcs.connector.plugin.soy.confirmLoggedIn({
                        dvcsHost: dvcsHost
                    }));
                    dialog.nextPage();
                    dialog.updateHeight();
                    return false;
                }
            }

            // disable add form
            dialog.enabled(false);

            //
            AJSMessages.info("#aui-message-bar", {
                title: "Connecting to " + dvcsHost + " to configure your account...",
                closeable: false
            });
            dialog.updateHeight();
            // set url by selected type
            return true; // submit form
        }

        // else - lets try to identify account
        // account info
        if (!validateAccountInfoForm()) {
            dialog.enabled(true);
            return false;
        }

        var account = parseAccountUrl($("#organization").val());
        $("#url").val(account.hostUrl);
        $("#organization").val(account.name);

        $("#aui-message-bar").empty();

        AJSMessages.info("#aui-message-bar", { title: "Trying to identify repository type...", closeable: false });
        dialog.updateHeight();

        var repositoryUrl = $("#url").val().trim();
        var organizationName = $("#organization").val().trim();

        var requestUrl = dvcs.connector.plugin.BASE_URL + "/rest/bitbucket/1.0/accountInfo?server=" + encodeURIComponent(repositoryUrl) + "&account=" + encodeURIComponent(organizationName);

        $.getJSON(requestUrl, function (data) {

            $("#aui-message-bar").empty();
            dialog.enabled(true);

            if (data.validationErrors && data.validationErrors.length > 0) {
                $.each(data.validationErrors, function (i, msg) {
                    AJSMessages.error("#aui-message-bar", { title: "Error!", body: msg });
                    dialog.updateHeight();
                });
            } else {
                dvcsSubmitFormAjaxHandler[data.dvcsType].apply(this, arguments);
            }
        }).error(function (a) {
            $("#aui-message-bar").empty();
            AJSMessages.error("#aui-message-bar", {
                title: "Error!",
                body: "The url [<b>" + AJS.escapeHtml($("#url").val()) + "</b>] is incorrect or the server is not responding."
            });
            dialog.enabled(true);
            dialog.updateHeight();
        });
        return false;
    }

    /**
     * Switch the Add Organization dialog to the selected DVCS type mode.
     *
     * @param {DvcsType} dvcsType The dvcs type selected
     */
    function switchDvcsDetails(dvcsType) {
        // clear all form errors
        DvcsValidator.clearAllErrors();

        $("#url").val(bitbucketRandom.DvcsProviders[dvcsType].hostUrl());
        $("#organization").focus().select();
        $("#repoEntry").attr("action", dvcs.connector.plugin.BASE_URL + bitbucketRandom.DvcsProviders[dvcsType].actionPath);

        if (dvcsType == bitbucketRandom.DvcsType.BITBUCKET) {

            $('#github-form-section').hide();
            $('#githube-form-section').hide();
            $("#bitbucket-form-section").fadeIn();
        } else if (dvcsType == bitbucketRandom.DvcsType.GITHUB) {

            $('#bitbucket-form-section').hide();
            $('#githube-form-section').hide();
            $("#github-form-section").fadeIn();
        } else if (dvcsType == bitbucketRandom.DvcsType.GITHUB_ENTERPRISE) {

            $('#bitbucket-form-section').hide();
            $('#github-form-section').hide();
            $("#githube-form-section").fadeIn();
        }
    }

    function createAddOrganizationDialog(action) {
        var dialog = new AJSDialog({
            width: 800,
            height: 400,
            id: "add-organization-dialog",
            closeOnOutsideClick: false
        });

        // First page
        dialog.addHeader("Add New Account");

        dialog.addPanel("", dvcs.connector.plugin.soy.addOrganizationDialog({
            atlToken: dvcs.connector.plugin.atlToken,
            source: $("#dvcs-connect-source").data("source"),
            disabledHosts: dvcs.connector.plugin.disabledHosts,
            isAciEnabled: dvcs.connector.plugin.aciEnabled
        }), "panel-body");

        dialog.addButtonPanel();
        dialog.page[0].buttonpanel.append("<span id='add-organization-wait' class='aui-icon' style='padding-right:10px'>&nbsp;</span>");
        dialog.addSubmit("Add", function (dialog, event) {
            if (dvcsSubmitFormHandler(event, false)) {
                $("#repoEntry").submit();
            }
        });

        dialog.addCancel("Cancel", function (dialog) {
            $("#repoEntry").trigger('reset');
            $("#aui-message-bar").empty();
            dialog.hide();
            bitbucketRandom.triggerAnalyticsEvent("add.cancelled");
        }, "#");

        $('#urlSelect').change(function (event) {
            var dvcsSelect = event.target;
            var dvcsType = dvcsSelect.options[dvcsSelect.selectedIndex].value;
            switchDvcsDetails(dvcsType);
            dialog.updateHeight();
        });

        // Second page, GitHub Enterprise confirmation page
        dialog.addPage();
        dialog.addHeader("Add New Account");
        dialog.addPanel("Confirmation", "<div id='githubeConfirmation'>Test</div>", "panel-body");
        dialog.addSubmit("Continue", function (dialog, event) {
            dialog.gotoPage(0);
            dialog.updateHeight();
            if (dvcsSubmitFormHandler(event, true)) {
                $("#repoEntry").submit();
            }
        });

        dialog.addButton("Previous", function (dialog) {
            dialog.prevPage();
            dialog.updateHeight();
        });

        dialog.addCancel("Cancel", function (dialog) {
            $("#repoEntry").trigger('reset');
            $("#aui-message-bar").empty();
            dialog.hide();
            bitbucketRandom.triggerAnalyticsEvent("add.cancelled");
        }, "#");

        dialog.enabled = function (enabled) {
            if (enabled) {
                $("#add-organization-wait").removeClass("aui-icon-wait");
                $('#add-organization-dialog .button-panel-submit-button').removeAttr("disabled");
                $('#add-organization-dialog .button-panel-submit-button').remove("aria-disabled");
            } else {
                $("#add-organization-wait").addClass("aui-icon-wait");
                $('#add-organization-dialog .button-panel-submit-button').attr("disabled", "disabled");
                $('#add-organization-dialog .button-panel-submit-button').attr("aria-disabled", "true");
            }
        };
        dvcs.connector.plugin.addOrganizationDialog = dialog;
    }

    function showAddRepoDetails(show, hostToSelect) {
        if (!dvcs.connector.plugin.addOrganizationDialog) {
            createAddOrganizationDialog();
        }
        var dialog = dvcs.connector.plugin.addOrganizationDialog;
        // Reset to default view:
        $('#repoEntry').attr("action", "");
        // - hide username/password
        $("#github-form-section").hide();

        // - show url, organization field
        var urlSelect = $('#urlSelect');
        urlSelect.show();
        /**
         * Building an internal map of all of the available hosts to avoid the use of $ or .find
         * in the case of potential XSS hole when mixing input from url with query string
         */
        var availableHosts = {};
        var defaultHost;
        urlSelect.find("option").each(function (index, option) {
            var $option = $(option);
            $option.data("index", index);
            if (!dvcs.connector.plugin.disabledHosts[$option.attr("value")]) {
                var host = $option.attr("value");
                availableHosts[host] = $option;
                if (!defaultHost || host == "bitbucket") {
                    defaultHost = host;
                }
            }
        });

        var selectedHost;
        if (hostToSelect && availableHosts[hostToSelect]) {
            selectedHost = $(availableHosts[hostToSelect]);
        } else {
            //Defaults to bitbucket
            selectedHost = $(availableHosts[defaultHost]);
        }

        urlSelect.val(selectedHost.attr("value"));
        $('#urlReadOnly').hide();

        $('#organization').show();
        $('#organizationReadOnly').hide();

        dialog.enabled(true);

        // clear all form errors
        DvcsValidator.clearAllErrors();

        // Enable form for the selected host
        switchDvcsDetails(selectedHost.attr("value"));

        $("#organization").focus().select();
        dialog.gotoPage(0);
        dialog.gotoPanel(0);
        dialog.show();
        dialog.updateHeight();

        bitbucketRandom.triggerAnalyticsEvent("add.started");
    }

    return showAddRepoDetails;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/ui/update-sync-status.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__, __webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')"), __webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (require, formatter, $) {
    "use strict";

    __webpack_require__(12);

    __webpack_require__(1);

    function updateSyncStatus(repo) {
        var syncStatusDiv = $('#sync_status_message_' + repo.id);
        var syncErrorDiv = $('#sync_error_message_' + repo.id);
        var syncIconElement = $('#syncicon_' + repo.id);
        var syncRepoIconElement = $('#syncrepoicon_' + repo.id);
        var syncStatusHtml = "";
        if (repo.sync) {
            if (repo.sync.finished) {
                syncStatusHtml = repoSyncFinished(syncIconElement, syncRepoIconElement, syncErrorDiv, repo);
            } else {
                syncStatusHtml = repoSyncInProgress(syncRepoIconElement, syncErrorDiv, repo);
            }
        } else if (repo.lastActivityDate) {
            syncStatusHtml = getLastCommitRelativeDateHtml(repo.lastActivityDate);
        }
        syncRepoIconElement.tooltip({ aria: true });
        syncStatusDiv.html(syncStatusHtml);
    }

    function repoSyncFinished(syncIconElement, syncRepoIconElement, syncErrorDiv, repo) {
        addHoverIcon(syncIconElement, syncRepoIconElement);
        var syncStatusHtml = getLastCommitRelativeDateHtml(repo.lastActivityDate);
        var title = syncRepoIconElement.attr("data-title");
        if (repo.sync.finishTime) {
            var finishSyncDateTime = new Date(repo.sync.finishTime);
            title += " (last sync finished at " + finishSyncDateTime.toDateString() + " " + finishSyncDateTime.toLocaleTimeString() + ")";
            syncRepoIconElement.attr("data-last-sync", finishSyncDateTime.getTime());
        }
        syncRepoIconElement.attr("title", title);

        if (repo.sync.error) {
            syncStatusHtml = "";

            var syncTitle = repo.sync.errorTitle && repo.sync.errorTitle != '' ? repo.sync.errorTitle : formatter.I18n.getText('com.atlassian.jira.plugins.dvcs.admin.sync.status.sync-failed');
            var syncIcon = repo.sync.warning === true ? "info" : "error";
            syncErrorDiv.html(dvcs.connector.plugin.soy.sync_error({
                'syncIcon': syncIcon,
                'syncTitle': syncTitle,
                'syncError': repo.sync.error
            }));
        } else {
            syncErrorDiv.html("");
        }
        return syncStatusHtml;
    }

    function repoSyncInProgress(syncRepoIconElement, syncErrorDiv, repo) {
        removeHoverIcon(syncRepoIconElement);

        syncErrorDiv.html("");
        var title = "Synchronizing...";
        if (repo.sync.startTime) {
            var startSyncDateTime = new Date(repo.sync.startTime);
            title += " (started at " + startSyncDateTime.toDateString() + " " + startSyncDateTime.toLocaleTimeString() + ")";
        }
        syncRepoIconElement.attr("title", title);

        var syncStatusHtml = dvcs.connector.plugin.soy.sync_progress({
            'changesetCount': repo.sync.changesetCount,
            'pullRequestCount': repo.sync.pullRequestActivityCount,
            'issueCount': repo.sync.jiraCount
        });

        if (repo.sync.synchroErrorCount > 0) {
            syncStatusHtml += ", <span style='color:#e16161;'><strong>" + repo.sync.synchroErrorCount + "</strong>" + formatter.I18n.getText('com.atlassian.jira.plugins.dvcs.admin.sync.status.commits-incomplete') + "</span>";
        }
        return syncStatusHtml;
    }

    function removeHoverIcon(syncRepoIconElement) {
        syncRepoIconElement.removeClass("hover_icon").removeClass("aui-icon aui-icon-small").removeClass("aui-iconfont-refresh-small");
        syncRepoIconElement.addClass("refresh_running");
        syncRepoIconElement.text('\xa0');
    }

    function addHoverIcon(syncIconElement, syncRepoIconElement) {
        syncIconElement.removeClass("commits").removeClass("finished").removeClass("refresh_running").removeClass("error").removeClass("info");
        syncRepoIconElement.removeClass("refresh_running");
        syncRepoIconElement.addClass("aui-icon aui-icon-small aui-iconfont-refresh-small hover_icon");
        syncRepoIconElement.text(syncRepoIconElement.data("title"));
    }

    function getLastCommitRelativeDateHtml(daysAgo) {
        var html = "";
        if (daysAgo) {
            html = new Date(daysAgo).toDateString();
        }
        return html;
    }

    return updateSyncStatus;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/util/console.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * A simple AMD module for accessing the console where its available.
 *
 * Provides a polyfill that is safe to use when no console is available.
 *
 * @module jira-dvcs-connector/util/console
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function () {
    if (console) {
        return console;
    }
    var f = function f() {};
    return {
        log: f,
        info: f,
        warn: f,
        debug: f,
        error: f
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/util/navigate.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * A utility module that wraps interactions with the browser location.
 *
 * Abstracts away from the underlying window object which makes client code more testable, and provides utility methods
 * for working with the window location (event-safe redirect etc.). Utilities include:
 * <ul>
 * <li> simple fragment manipulation API that can retrieve and set the fragment part, along with
 *   fragment params that can be added to the fragment without causing a backend page request etc.
 *   e.g. http://myurl.com#urlHash?hashParam=value
 * </li>
 * <li> the ability to append an element id to the url after a double hash, and then retrieve this id later so the
 *   element can be scrolled to after a refresh
 *   e.g. http://myurl.com##elementId
 * </li>
 * </ul>
 *
 * @module jira-dvcs-connector/util/navigate
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("./js/dvcs/util/window.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (_, contextPath, window) {
    "use strict";

    return {
        /**
         * @returns the current URL that is being displayed by the browser
         */
        getUrl: function getUrl() {
            return window.location.href;
        },

        /**
         * @returns {string} The origin of the current page
         */
        getOrigin: function getOrigin() {
            if (window.location.origin) {
                return window.location.origin;
            }
            return window.location.protocol + "//" + window.location.host;
        },

        /**
         * @returns {string} The hash/fragment component of the current window location (if there is one), with hash
         * params etc. stripped from it e.g. "http://example.com/path#hash?key=value" -> "hash"
         */
        getHash: function getHash() {
            if (!window.location.hash) {
                return "";
            }
            var hash = window.location.hash.indexOf('#');
            var query = window.location.hash.indexOf('?');

            return window.location.hash.substring(hash + 1, query > 0 ? query : window.location.hash.length);
        },

        /**
         * Get the hash params for the current window location, if there are any
         *
         * Supports a hash of the form "#hash?key=value&foo=bar" -> {"key":"value", "foo": "bar"}
         *
         * @returns {{}} The map of key=value params encoded in the current window hash (if any)
         */
        getHashParams: function getHashParams() {
            if (!window.location.hash) {
                return {};
            }

            var queryStart = window.location.hash.indexOf('?');
            if (queryStart == -1) {
                return {};
            }

            return _parseParams(window.location.hash.substring(queryStart + 1));
        },

        /**
         * Set the url hash to the hash string provided.
         *
         * e.g. http://abc.com#hash
         *
         * @param hash {string} string to set the url hash to.
         */
        setHash: function setHash(hash) {
            window.location.hash = hash;
        },

        /**
         * Set the url hash to ##<elementId>, so that we can retrieve this id from the url after we refresh the page,
         * and then scroll to it.
         *
         * Just setting the url hash to #<elementId> scrolls the browser
         * to that element, but there are some cross browser issues with that approach, and this is more reliable.
         *
         * @param elementId {string} the id of an element on the page to scroll to after navigation
         */
        setIdToScrollPostRefresh: function setIdToScrollPostRefresh(elementId) {
            window.location.hash = "##" + elementId;
        },

        /**
         * Retrieve the id after a double hash in the url, if it exists, as this represents an element we want
         * to scroll to, assuming we have just refreshed the page.
         *
         * @returns {string, null} the id of the element to scroll to, or null if we haven't set one.
         */
        getIdToScrollToPostRefreshIfExists: function getIdToScrollToPostRefreshIfExists() {
            if (window.location.hash && window.location.hash.substring(0, 2) === "##") {
                return window.location.hash.substring(2);
            } else {
                return null;
            }
        },

        /**
         * Clear the hash component from the window URL
         */
        clearHash: function clearHash() {
            window.location.hash = '';
        },

        /**
         * @returns {{}} The current query params as a hash
         */
        getQueryParams: function getQueryParams() {
            if (!parseUri) {
                // TODO: Implement our own parsing here if needed
                return {};
            }

            return parseUri(window.location.href).queryKey || {};
        },

        /**
         * Turns the supplied hash into a query parameter string, i.e. ? followed by & separated parameters.
         * @param params A hash of params
         * @returns String An empty string if the hash is empty or a query string with the params encoded
         */
        buildQueryParams: function buildQueryParams(params) {
            var queryParams = [];
            for (var param in params) {
                if (param && params.hasOwnProperty(param)) {
                    queryParams.push(encodeURI(param) + '=' + encodeURI(params[param]));
                }
            }

            return queryParams.length === 0 ? '' : '?' + queryParams.join('&');
        },

        /**
         * Triggers browser reload of the page that is currently displayed
         */
        reload: function reload() {
            _.defer(function () {
                window.location.reload();
            });
        },

        /**
         * Make the browser navigate to specified URL after all current events have been processed.
         * @param url to navigate to
         */
        navigate: function navigate(url) {
            _.defer(function () {
                window.location = url;
            });
        },

        /**
         * Redirects user to JIRA login page. After successful login, user will be redirected to the currently
         * displayed page.
         */
        redirectToLogin: function redirectToLogin() {
            this.navigate(contextPath() + '/login.jsp?permissionViolation=true&os_destination=' + encodeURIComponent(window.location.href));
        }
    };

    /**
     * Parse and return parameters from the provided query part
     *
     * @param queryPart The query part to parse - of the form "key=value&foo=bar"
     * @returns {{}}
     * @private
     */
    function _parseParams(queryPart) {
        if (!queryPart) {
            return {};
        }
        var result = {};
        _.each(queryPart.split('&'), function (q) {
            if (!q) {
                return;
            }
            var kv = q.split('=');
            result[kv[0]] = kv[1];
        });
        return result;
    }
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/util/redirectToBitbucketAuthorize.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("./js/dvcs/bitbucket/rest/bitbucket-client.js"), __webpack_require__("./js/dvcs/util/navigate.js"), __webpack_require__("./js/dvcs/random/bitbucket.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (BitbucketClient, Navigate, bitbucketRandom) {
    /**
     * Redirect the user's browser to the Bitbucket authorize addon screen to initiate the
     * addon installation flow.
     *
     * @param {String} [bitbucketBaseUrl] The URL to use to override the location of bitbucket for testing etc. If not
     * provided, will use dvcs.connector.plugin.bitbucketOverrideUrl or the default URL found in DvcsProviders.
     */
    return function redirectToBitbucketAuthorize(bitbucketBaseUrl) {
        if (!bitbucketBaseUrl) {
            bitbucketBaseUrl = bitbucketRandom.DvcsProviders[bitbucketRandom.DvcsType.BITBUCKET].hostUrl();
        }
        var jiraBaseUrl = Navigate.getOrigin() + dvcs.connector.plugin.BASE_URL;
        var descriptorUri = jiraBaseUrl + '/rest/aci/1.0/installation/jira-bitbucket-connector-plugin/descriptor';
        var redirectUri = jiraBaseUrl + '/secure/BitbucketPostInstallApprovalAction.jspa?jiraInitiated=true&atl_token=' + dvcs.connector.plugin.atlToken;

        triggerAnalyticsEvent("add.bitbucket.flow.started");

        var client = new BitbucketClient(bitbucketBaseUrl);

        Navigate.navigate(client.addons.generateAddonAuthorizeRedirect(descriptorUri, redirectUri));
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/util/settings.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * An accessor for getting and setting the settings stored on the DVCS accounts admin page
 *
 * Note that this will only retrieve/set what is on the page. It will not make calls to the backend to set anything.
 * You should use the appropriate rest client for that.
 *
 * @module jira-dvcs-connector/util/settings
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function ($) {
    return function LocalSettingsAccessor() {

        var $settingsEl = $('#dvcs-connect-source');

        return {

            isAciEnabled: function isAciEnabled() {
                return $settingsEl.data('aci-enabled');
            },

            shouldShowFeatureDiscovery: function shouldShowFeatureDiscovery() {
                return $settingsEl.data('show-feature-discovery');
            },

            setFeatureDiscoveryShown: function setFeatureDiscoveryShown() {
                $settingsEl.data('show-feature-discovery', false);
            }
        };
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/dvcs/util/window.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * AMD wrapper around the global Window object.
 *
 * Useful for making modules that depend on the Window more testable.
 *
 * @module jira-dvcs-connector/util/window
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function () {
  "use strict";

  return window;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ 1:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 12:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 2:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 3:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 4:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 5:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 6:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 7:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 8:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 9:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ "jira.webresources:ajs-backbone-amd-shim/require('backbone')":
/***/ (function(module, exports) {

module.exports = require('backbone');

/***/ }),

/***/ "jira.webresources:ajs-underscorejs-amd-shim/require('underscore')":
/***/ (function(module, exports) {

module.exports = require('underscore');

/***/ }),

/***/ "jira.webresources:aui-core-amd-shim/require('aui/message')":
/***/ (function(module, exports) {

module.exports = require('aui/message');

/***/ }),

/***/ "jira.webresources:jira-analytics-amd/require('jira/analytics')":
/***/ (function(module, exports) {

module.exports = require('jira/analytics');

/***/ }),

/***/ "jira.webresources:jira-formatter/require('jira/util/formatter')":
/***/ (function(module, exports) {

module.exports = require('jira/util/formatter');

/***/ }),

/***/ "jira.webresources:jira-logger/require('jira/util/logger')":
/***/ (function(module, exports) {

module.exports = require('jira/util/logger');

/***/ }),

/***/ "jira.webresources:jquery/require('jira/jquery/deferred')":
/***/ (function(module, exports) {

module.exports = require('jira/jquery/deferred');

/***/ }),

/***/ "jira.webresources:jquery/require('jquery')":
/***/ (function(module, exports) {

module.exports = require('jquery');

/***/ }),

/***/ "jira.webresources:wrm-context-path/require('wrm/context-path')":
/***/ (function(module, exports) {

module.exports = require('wrm/context-path');

/***/ })

});
//# sourceMappingURL=1.js.map