/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.JiraDocValues;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.parameters.lucene.JiraBytesRef;
import com.atlassian.jira.issue.statistics.TwoDimensionalStatsMap;
import com.atlassian.jira.issue.statistics.util.BytesRefMapper;
import com.atlassian.jira.issue.statistics.util.CachingBytesRefMapper;
import com.atlassian.jira.issue.statistics.util.HitCollectorUtil;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public class TwoDimensionalTermHitCollector
extends Collector {
    private final TwoDimensionalStatsMap statsMap;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final String aggregateField;
    private final FieldManager fieldManager;
    private final ReaderCache readerCache;
    private final BytesRefMapper<Object> docValueMapper;
    private JiraDocValues docToXTerms;
    private JiraDocValues docToYTerms;
    private JiraDocValues docToValueTerms;
    private JiraDocValues projectDocToTerms;
    private JiraDocValues issueTypeDocToTerms;
    private final String xFieldName;
    private final String yFieldName;
    private int docBase = 0;
    private final BytesRefMapper<String> issueTypesMapper = new CachingBytesRefMapper<String>(Function.identity());
    private final BytesRefMapper<Long> projectIdsMapper = new CachingBytesRefMapper<Long>(Long::new);

    public TwoDimensionalTermHitCollector(TwoDimensionalStatsMap statsMap, IndexReader indexReader, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache) {
        this(statsMap, indexReader, fieldVisibilityManager, readerCache, null);
    }

    public TwoDimensionalTermHitCollector(TwoDimensionalStatsMap statsMap, IndexReader indexReader, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, LuceneFieldSorter aggregateField) {
        this(statsMap, indexReader, fieldVisibilityManager, readerCache, aggregateField, ComponentAccessor.getFieldManager());
    }

    public TwoDimensionalTermHitCollector(TwoDimensionalStatsMap statsMap, IndexReader indexReader, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, LuceneFieldSorter aggregateField, FieldManager fieldManager) {
        this(statsMap, fieldVisibilityManager, readerCache, aggregateField, fieldManager);
        this.setNextReader(indexReader, 0);
    }

    public TwoDimensionalTermHitCollector(TwoDimensionalStatsMap statsMap, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, LuceneFieldSorter aggregateField, FieldManager fieldManager) {
        this.statsMap = statsMap;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.readerCache = readerCache;
        this.docValueMapper = new CachingBytesRefMapper<Object>(aggregateField);
        this.aggregateField = aggregateField == null ? null : aggregateField.getDocumentConstant();
        this.fieldManager = fieldManager;
        HitCollectorUtil hitCollectorUtil = new HitCollectorUtil();
        this.xFieldName = hitCollectorUtil.getFieldId(statsMap.getxAxisMapper().getDocumentConstant());
        this.yFieldName = hitCollectorUtil.getFieldId(statsMap.getyAxisMapper().getDocumentConstant());
    }

    public void collect(int i) {
        this.adjustForValues(i);
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void setNextReader(IndexReader reader, int docBase) {
        this.docBase = docBase;
        this.docToXTerms = this.getDocToXTerms(reader, this.statsMap);
        this.docToYTerms = this.getDocToYTerms(reader, this.statsMap);
        this.docToValueTerms = this.getDocToValueTerms(this.aggregateField, reader);
        this.projectDocToTerms = this.getDocToValueTerms(SystemSearchConstants.forProject().getIndexField(), reader);
        this.issueTypeDocToTerms = this.getDocToValueTerms(SystemSearchConstants.forIssueType().getIndexField(), reader);
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    private void adjustForValues(int docId) {
        Object[] xValues = this.docToXTerms.getDocValues(docId);
        Object[] yValues = this.docToYTerms.getDocValues(docId);
        int incrementValue = this.docToValueTerms == null ? 1 : this.getFieldValue(docId);
        boolean xFieldNotVisible = false;
        boolean yFieldNotVisible = false;
        Long projectId = this.projectIdForDocument(docId);
        String issueTypeId = this.issueTypeForDocument(docId);
        if (projectId == null || issueTypeId == null) {
            return;
        }
        if (ArrayUtils.isEmpty((Object[])xValues) && !this.isVisibleAndInScope(projectId, issueTypeId, this.xFieldName)) {
            xFieldNotVisible = true;
        }
        if (ArrayUtils.isEmpty((Object[])yValues) && !this.isVisibleAndInScope(projectId, issueTypeId, this.yFieldName)) {
            yFieldNotVisible = true;
        }
        if (xFieldNotVisible || yFieldNotVisible) {
            this.statsMap.adjustMapForIrrelevantValues((JiraBytesRef[])xValues, xFieldNotVisible, (JiraBytesRef[])yValues, yFieldNotVisible, incrementValue);
        } else {
            this.statsMap.adjustMapForValues((JiraBytesRef[])xValues, (JiraBytesRef[])yValues, incrementValue);
        }
    }

    private String issueTypeForDocument(int docId) {
        return this.issueTypesMapper.mapSingleValueFromArray(this.issueTypeDocToTerms.getDocValues(docId));
    }

    private Long projectIdForDocument(int docId) {
        return this.projectIdsMapper.mapSingleValueFromArray(this.projectDocToTerms.getDocValues(docId));
    }

    private boolean isVisibleAndInScope(Long projectId, String issueTypeId, String fieldName) {
        CustomField customField;
        if (this.fieldManager.isCustomField(fieldName) && !(customField = this.fieldManager.getCustomField(fieldName)).isRelevantForIssueContext((IssueContext)new IssueContextImpl(projectId, issueTypeId))) {
            return false;
        }
        return !this.fieldVisibilityManager.isFieldHidden(projectId, fieldName, issueTypeId);
    }

    private int getFieldValue(int i) {
        Number value = this.getValue(this.docToValueTerms.getDocValues(i));
        return value != null ? value.intValue() : 0;
    }

    private Number getValue(JiraBytesRef[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        if (values.length > 1) {
            throw new IllegalArgumentException("More than one value stored for statistic \"" + Arrays.toString(values) + "\".");
        }
        Object o = this.docValueMapper.mapValue(values[0]);
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        throw new IllegalArgumentException("Value stored for statistic was \"" + (o != null ? o.getClass().getName() : "null") + "\".  Expected \"java.lang.Number\"");
    }

    private JiraDocValues getDocToXTerms(IndexReader indexReader, TwoDimensionalStatsMap statsMap) {
        return this.getDocToValueTerms(statsMap.getxAxisMapper().getDocumentConstant(), indexReader);
    }

    private JiraDocValues getDocToYTerms(IndexReader indexReader, TwoDimensionalStatsMap statsMap) {
        return this.getDocToValueTerms(statsMap.getyAxisMapper().getDocumentConstant(), indexReader);
    }

    private JiraDocValues getDocToValueTerms(String documentConstant, IndexReader indexReader) {
        if (documentConstant != null) {
            return this.readerCache.getDocValues(indexReader, documentConstant);
        }
        return null;
    }
}

