/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.JiraDocValues;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.parameters.lucene.JiraBytesRef;
import com.atlassian.jira.issue.statistics.util.BytesRefMapper;
import com.atlassian.jira.issue.statistics.util.CachingBytesRefMapper;
import com.atlassian.jira.issue.statistics.util.HitCollectorUtil;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractOneDimensionalHitCollector
extends Collector {
    private static final Logger log = LoggerFactory.getLogger(AbstractOneDimensionalHitCollector.class);
    private final String fieldId;
    private JiraDocValues docToTerms;
    private JiraDocValues docToProject;
    private JiraDocValues docToIssueType;
    private String documentFieldId;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final ReaderCache readerCache;
    private long irrelevantCount = 0L;
    private boolean usingOldCallingConvention = false;
    private final CustomField customField;
    private final Map<Long, Map<String, Boolean>> projectIdIssueTypeIdFieldVisibility = new HashMap<Long, Map<String, Boolean>>();
    private final BytesRefMapper<String> issueTypesMapper = new CachingBytesRefMapper<String>(Function.identity());
    private final BytesRefMapper<Long> projectIdsMapper = new CachingBytesRefMapper<Long>(Long::new);
    private long hitCount = 0L;
    private int docBase = 0;

    public AbstractOneDimensionalHitCollector(String documentFieldId, IndexReader indexReader, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, FieldManager fieldManager, ProjectManager projectManager) {
        this.documentFieldId = documentFieldId;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.readerCache = readerCache;
        this.fieldId = new HitCollectorUtil().getFieldId(documentFieldId);
        this.setNextReader(indexReader, 0);
        this.usingOldCallingConvention = true;
        this.customField = fieldManager.isCustomField(this.fieldId) ? fieldManager.getCustomField(this.fieldId) : null;
    }

    public AbstractOneDimensionalHitCollector(String documentFieldId, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, FieldManager fieldManager, ProjectManager projectManager) {
        this.documentFieldId = documentFieldId;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.readerCache = readerCache;
        this.fieldId = new HitCollectorUtil().getFieldId(documentFieldId);
        this.customField = fieldManager.isCustomField(this.fieldId) ? fieldManager.getCustomField(this.fieldId) : null;
    }

    public AbstractOneDimensionalHitCollector(String documentFieldId, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, FieldManager fieldManager) {
        this.documentFieldId = documentFieldId;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.readerCache = readerCache;
        this.fieldId = new HitCollectorUtil().getFieldId(documentFieldId);
        this.customField = fieldManager.isCustomField(this.fieldId) ? fieldManager.getCustomField(this.fieldId) : null;
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void setNextReader(IndexReader reader, int docBase) {
        if (this.usingOldCallingConvention) {
            log.warn("You constructed an instance of AbstractOneDimensionalHitCollector using the old calling convention and passed in an index reader.  You should not be calling setNextReader() on that instance as it will cause excessive double caching of data.  This is a BAD BAD THING!!!");
        }
        this.docBase = docBase;
        this.docToTerms = this.readerCache.getDocValues(reader, this.documentFieldId);
        this.docToProject = this.readerCache.getDocValues(reader, SystemSearchConstants.forProject().getIndexField());
        this.docToIssueType = this.readerCache.getDocValues(reader, SystemSearchConstants.forIssueType().getIndexField());
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public void collect(int i) {
        ++this.hitCount;
        JiraBytesRef[] terms = this.docToTerms.getDocValues(i);
        if (terms == null || terms.length == 0) {
            Long projectIdString = this.projectIdsMapper.mapSingleValueFromArray(this.docToProject.getDocValues(i));
            String issueTypeId = this.issueTypesMapper.mapSingleValueFromArray(this.docToIssueType.getDocValues(i));
            if (projectIdString != null && issueTypeId != null && this.fieldIsRelevant(projectIdString, issueTypeId)) {
                this.collectWithTerms(this.docBase + i, null);
            } else {
                ++this.irrelevantCount;
                this.collectIrrelevant(this.docBase + i);
            }
        } else {
            this.collectWithTerms(this.docBase + i, terms);
        }
    }

    private boolean fieldIsRelevant(Long projectId, String issueTypeId) {
        Boolean fieldRelevant;
        Map<String, Boolean> issueTypeIdFieldVisibility = this.projectIdIssueTypeIdFieldVisibility.get(projectId);
        if (issueTypeIdFieldVisibility == null) {
            issueTypeIdFieldVisibility = new HashMap<String, Boolean>();
            this.projectIdIssueTypeIdFieldVisibility.put(projectId, issueTypeIdFieldVisibility);
        }
        if ((fieldRelevant = issueTypeIdFieldVisibility.get(issueTypeId)) == null) {
            fieldRelevant = this.fieldVisibilityManager.isFieldVisible(projectId, this.fieldId, issueTypeId) && this.isFieldInScope(projectId, issueTypeId);
            issueTypeIdFieldVisibility.put(issueTypeId, fieldRelevant);
        }
        return fieldRelevant;
    }

    private boolean isFieldInScope(Long projectId, String issueTypeId) {
        if (this.fieldId == null || "".equals(this.fieldId) || projectId == null || issueTypeId == null || "".equals(issueTypeId)) {
            return false;
        }
        if (this.customField == null) {
            return true;
        }
        return this.customField.isInScope(projectId.longValue(), issueTypeId);
    }

    private static String getSingleValue(JiraBytesRef[] source) {
        return source.length > 0 ? source[0].utf8ToString() : "";
    }

    public long getIrrelevantCount() {
        return this.irrelevantCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    protected abstract void collectIrrelevant(int var1);

    protected abstract void collectWithTerms(int var1, JiraBytesRef[] var2);
}

