/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.serviceprovider.internal.servlet.authorize;

import com.atlassian.oauth.serviceprovider.internal.servlet.authorize.LoginRedirector;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class LoginRedirectorImpl
implements LoginRedirector {
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;

    public LoginRedirectorImpl(UserManager userManager, LoginUriProvider loginUriProvider) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.loginUriProvider = (LoginUriProvider)Preconditions.checkNotNull((Object)loginUriProvider, (Object)"loginUriProvider");
    }

    @Override
    public boolean isLoggedIn(HttpServletRequest request) {
        return this.userManager.getRemoteUsername(request) != null;
    }

    @Override
    public void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

