/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.serviceprovider.internal.servlet.authorize;

import com.atlassian.oauth.serviceprovider.ConsumerInformationRenderException;
import com.atlassian.oauth.serviceprovider.ConsumerInformationRenderer;
import com.atlassian.oauth.serviceprovider.ServiceProviderToken;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class BasicConsumerInformationRenderer
implements ConsumerInformationRenderer {
    private static final String TEMPLATE = "templates/auth/basic-consumer-info.vm";
    private final ApplicationProperties applicationProperties;
    private final TemplateRenderer renderer;
    private final UserManager userManager;

    public BasicConsumerInformationRenderer(ApplicationProperties applicationProperties, TemplateRenderer renderer, UserManager userManager) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"renderer");
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
    }

    public boolean canRender(ServiceProviderToken token, HttpServletRequest request) {
        return true;
    }

    public void render(ServiceProviderToken token, HttpServletRequest request, Writer writer) throws IOException {
        UserProfile profile;
        URI appUri = URI.create(this.applicationProperties.getBaseUrl());
        String username = this.userManager.getRemoteUsername();
        String userFullName = StringUtils.isNotBlank((String)username) ? ((profile = this.userManager.getUserProfile(username)) != null && StringUtils.isNotBlank((String)profile.getFullName()) ? profile.getFullName() : username) : "User unknown";
        ImmutableMap context = ImmutableMap.of((Object)"consumer", (Object)token.getConsumer(), (Object)"applicationDomain", (Object)appUri.getHost(), (Object)"userFullName", (Object)userFullName);
        try {
            this.renderer.render(TEMPLATE, (Map)context, writer);
        }
        catch (RenderingException e) {
            throw new ConsumerInformationRenderException("Could not render consumer information", (Throwable)e);
        }
    }
}

