/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.serviceprovider.internal.servlet.authorize;

import com.atlassian.oauth.serviceprovider.ServiceProviderToken;
import com.atlassian.oauth.serviceprovider.internal.servlet.OAuthProblemUtils;
import com.atlassian.oauth.serviceprovider.internal.servlet.TokenLoader;
import com.atlassian.oauth.serviceprovider.internal.servlet.TransactionalServlet;
import com.atlassian.oauth.serviceprovider.internal.servlet.authorize.AuthorizationRequestProcessor;
import com.atlassian.oauth.serviceprovider.internal.servlet.authorize.LoginRedirector;
import com.atlassian.oauth.shared.servlet.ResponseHeaderUtil;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthException;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public final class AuthorizeServlet
extends TransactionalServlet {
    static final int VERIFIER_LENGTH = 6;
    private static final String AUTH_ERROR_TEMPLATE = "templates/auth/authorize-error.vm";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AuthorizationRequestProcessor get;
    private final AuthorizationRequestProcessor post;
    private final TokenLoader loader;
    private final LoginRedirector loginRedirector;
    private final ApplicationProperties applicationProperties;
    private final TemplateRenderer templateRenderer;
    private final I18nResolver i18nResolver;

    public AuthorizeServlet(@Qualifier(value="getAuthorizationProcessor") AuthorizationRequestProcessor get, @Qualifier(value="postAuthorizationProcessor") AuthorizationRequestProcessor post, TokenLoader loader, LoginRedirector loginRedirector, ApplicationProperties applicationProperties, TransactionTemplate transactionTemplate, TemplateRenderer templateRenderer, I18nResolver i18nResolver) {
        super(transactionTemplate);
        this.get = (AuthorizationRequestProcessor)Preconditions.checkNotNull((Object)get, (Object)"get");
        this.post = (AuthorizationRequestProcessor)Preconditions.checkNotNull((Object)post, (Object)"post");
        this.loader = (TokenLoader)Preconditions.checkNotNull((Object)loader, (Object)"loader");
        this.loginRedirector = (LoginRedirector)Preconditions.checkNotNull((Object)loginRedirector, (Object)"loginRedirector");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
    }

    @Override
    public void doGetInTransaction(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(this.get, request, response);
        ResponseHeaderUtil.preventCrossFrameClickJacking((HttpServletResponse)response);
    }

    @Override
    public void doPostInTransaction(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(this.post, request, response);
        ResponseHeaderUtil.preventCrossFrameClickJacking((HttpServletResponse)response);
    }

    private void process(AuthorizationRequestProcessor processor, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServiceProviderToken token;
        try {
            token = this.loader.getTokenForAuthorization(request);
        }
        catch (OAuthException e) {
            if (e instanceof OAuthProblemException) {
                OAuthProblemUtils.logOAuthProblem(OAuthServlet.getMessage((HttpServletRequest)request, null), (OAuthProblemException)((Object)e), this.log);
            }
            OAuthServlet.handleException((HttpServletResponse)response, (Exception)((Object)e), (String)this.applicationProperties.getBaseUrl(), (boolean)false);
            response.setContentType("text/html");
            response.setCharacterEncoding("UTF-8");
            ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
            contextBuilder.put((Object)"message", (Object)this.getMessage(e));
            contextBuilder.put((Object)"applicationProperties", (Object)this.applicationProperties);
            this.templateRenderer.render(AUTH_ERROR_TEMPLATE, (Map)contextBuilder.build(), (Writer)response.getWriter());
            return;
        }
        if (!this.loginRedirector.isLoggedIn(request)) {
            this.loginRedirector.redirectToLogin(request, response);
        } else {
            processor.process(request, response, token);
        }
    }

    private String getMessage(OAuthException e) {
        if (e instanceof OAuthProblemException) {
            OAuthProblemException problem = (OAuthProblemException)((Object)e);
            if ("token_rejected".equals(problem.getProblem())) {
                return this.i18nResolver.getText("com.atlassian.oauth.serviceprovider.authorize.error.token.rejected");
            }
            if ("token_used".equals(problem.getProblem())) {
                return this.i18nResolver.getText("com.atlassian.oauth.serviceprovider.authorize.error.token.used");
            }
            if ("token_expired".equals(problem.getProblem())) {
                return this.i18nResolver.getText("com.atlassian.oauth.serviceprovider.authorize.error.token.expired");
            }
        }
        return this.i18nResolver.getText("com.atlassian.oauth.serviceprovider.authorize.error.generic");
    }
}

