/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.serviceprovider.internal;

import com.atlassian.oauth.serviceprovider.internal.InMemoryNonceService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.SimpleOAuthValidator;

public class OAuthValidatorImpl
implements OAuthValidator {
    private InMemoryNonceService nonceServiceService = new InMemoryNonceService(TimeUnit.MILLISECONDS.toSeconds(300000L));
    private OAuthValidator simpleValidator = new SimpleOAuthValidator(300000L, Double.parseDouble("1.0")){

        protected void validateTimestampAndNonce(OAuthMessage message) throws IOException, OAuthProblemException {
            super.validateTimestampAndNonce(message);
            long timestamp = Long.parseLong(message.getParameter("oauth_timestamp"));
            String nonce = message.getParameter("oauth_nonce");
            OAuthValidatorImpl.this.nonceServiceService.validateNonce(message.getConsumerKey(), timestamp, nonce);
        }
    };

    public void validateMessage(OAuthMessage message, OAuthAccessor accessor) throws OAuthException, IOException, URISyntaxException {
        message.requireParameters(new String[]{"oauth_signature_method", "oauth_consumer_key"});
        if (!message.getParameter("oauth_signature_method").equals("RSA-SHA1")) {
            throw new OAuthProblemException("signature_method_rejected");
        }
        this.simpleValidator.validateMessage(message, accessor);
    }
}

