/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.gadgets.system.DefaultStatsSearchUrlBuilder;
import com.atlassian.jira.gadgets.system.SearchQueryBackedResource;
import com.atlassian.jira.gadgets.system.StatisticTypesProvider;
import com.atlassian.jira.gadgets.system.StatsMarkup;
import com.atlassian.jira.gadgets.system.StatsSearchUrlBuilder;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.TwoDimensionalStatsMap;
import com.atlassian.jira.issue.statistics.util.FieldValueToDisplayTransformer;
import com.atlassian.jira.issue.statistics.util.ObjectToFieldValueMapper;
import com.atlassian.jira.issue.statistics.util.TwoDimensionalTermHitCollector;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.Collector;

@Path(value="/twodimensionalfilterstats")
@AnonymousAllowed
@Produces(value={"application/json"})
public class TwoDimensionalStatsResource
extends SearchQueryBackedResource {
    private static final String FILTER_ID = "filterId";
    private static final String X_STAT_TYPE = "xstattype";
    private static final String Y_STAT_TYPE = "ystattype";
    private static final String SORT_BY = "sortBy";
    private static final String SORT_DIRECTION = "sortDirection";
    private static final String NUMBER_TO_SHOW = "numberToShow";
    private static final String FILTER_PARAM = "filter";
    private final StatisticTypesProvider statisticTypesProvider;
    private SearchProvider searchProvider;
    private FilterStatisticsValuesGenerator generator;
    private VelocityRequestContextFactory velocityRequestContextFactory;
    private final FieldValueToDisplayTransformer<StatsMarkup> fieldValueToDisplayTransformer;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final FieldManager fieldManager;
    private final ReaderCache readerCache;

    public TwoDimensionalStatsResource(@ComponentImport ChartUtils chartUtils, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport SearchService searchService, @ComponentImport PermissionManager permissionManager, StatisticTypesProvider statisticTypesProvider, @ComponentImport SearchProvider searchProvider, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, FieldValueToDisplayTransformer<StatsMarkup> fieldValueToDisplayTransformer, @ComponentImport FieldManager fieldManager, @ComponentImport FieldVisibilityManager fieldVisibilityManager, @ComponentImport ReaderCache readerCache) {
        super(chartUtils, authenticationContext, searchService, permissionManager, velocityRequestContextFactory);
        this.statisticTypesProvider = statisticTypesProvider;
        this.searchProvider = searchProvider;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.fieldValueToDisplayTransformer = fieldValueToDisplayTransformer;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.fieldManager = fieldManager;
        this.readerCache = readerCache;
    }

    @GET
    @Path(value="validate")
    public Response validate(@QueryParam(value="filterId") String queryString, @QueryParam(value="xstattype") String xStatType, @QueryParam(value="ystattype") String yStatType, @QueryParam(value="numberToShow") String numberToShow) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)queryString) && !queryString.contains("-")) {
            try {
                Long.parseLong(queryString);
                queryString = "filter-" + queryString;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ArrayList<ValidationError> unfilteredErrors = new ArrayList<ValidationError>();
        this.getSearchRequestAndValidate(queryString, unfilteredErrors, params);
        for (ValidationError err : unfilteredErrors) {
            errors.add(new ValidationError("projectOrFilterId".equals(err.getField()) ? FILTER_ID : err.getField(), err.getError(), err.getParams()));
        }
        this.validateStatType(errors, xStatType, X_STAT_TYPE);
        this.validateStatType(errors, yStatType, Y_STAT_TYPE);
        this.validateNumberToShow(NUMBER_TO_SHOW, numberToShow, errors);
        return this.createValidationResponse(errors);
    }

    private FilterStatisticsValuesGenerator getGenerator() {
        if (this.generator == null) {
            this.generator = new FilterStatisticsValuesGenerator();
        }
        return this.generator;
    }

    void setGenerator(FilterStatisticsValuesGenerator generator) {
        this.generator = generator;
    }

    @GET
    @Path(value="/generate")
    public Response getStats(@QueryParam(value="filterId") String queryString, @QueryParam(value="xstattype") @DefaultValue(value="assignees") String xStatType, @QueryParam(value="ystattype") @DefaultValue(value="assignees") String yStatType, @QueryParam(value="sortDirection") @DefaultValue(value="asc") String sortDirection, @QueryParam(value="sortBy") @DefaultValue(value="natural") String sortBy, @QueryParam(value="numberToShow") @DefaultValue(value="5") String numberToShowStr) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(queryString, errors, params);
        if (StringUtils.isBlank((String)numberToShowStr)) {
            numberToShowStr = "5";
        }
        int numberToShow = this.validateNumberToShow(NUMBER_TO_SHOW, numberToShowStr, errors);
        if (!errors.isEmpty()) {
            return this.createErrorResponse(errors);
        }
        try {
            TwoDimensionalProperties properties = this.buildProperties(searchRequest, sortDirection, sortBy, numberToShow, xStatType, yStatType);
            return Response.ok((Object)properties).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                return this.createIndexingUnavailableResponse(this.createIndexingUnavailableMessage());
            }
            throw e;
        }
    }

    TwoDimensionalProperties buildProperties(SearchRequest searchRequest, String sortDirection, String sortBy, int numberToShow, String xStatType, String yStatType) {
        StatisticsMapper xAxisMapper = this.getGenerator().getStatsMapper(xStatType);
        StatisticsMapper yAxisMapper = this.getGenerator().getStatsMapper(yStatType);
        String xDisplayName = this.validateStatType(new ArrayList<ValidationError>(), xStatType, X_STAT_TYPE);
        String yDisplayName = this.validateStatType(new ArrayList<ValidationError>(), yStatType, Y_STAT_TYPE);
        TwoDimensionalStatsMap statsMap = this.getAndPopulateTwoDimensionalStatsMap(xAxisMapper, yAxisMapper, searchRequest);
        Collection allYAxisObjects = statsMap.getYAxis(sortBy, sortDirection);
        Collection xAxisObjects = statsMap.getXAxis();
        Collection<?> yAxisObjects = this.buildYObjects(numberToShow, allYAxisObjects);
        String filterUrl = this.urlPrefix() + "?" + FILTER_PARAM + "=" + searchRequest.getId();
        FilterProperties filterProperties = new FilterProperties(searchRequest.getName(), searchRequest.getDescription(), filterUrl, xAxisObjects.isEmpty() || yAxisObjects.isEmpty());
        Row firstRow = this.makeFirstRow(xStatType, searchRequest, xAxisMapper, xAxisObjects, statsMap.hasIrrelevantXData());
        int rowCount = statsMap.hasIrrelevantYData() ? allYAxisObjects.size() + 1 : allYAxisObjects.size();
        List<Row> rows = this.makeRows(searchRequest, xAxisMapper, yAxisMapper, statsMap, xAxisObjects, yAxisObjects, yStatType);
        return new TwoDimensionalProperties(filterProperties, firstRow, rows, xDisplayName, yDisplayName, rowCount);
    }

    protected TwoDimensionalStatsMap getAndPopulateTwoDimensionalStatsMap(StatisticsMapper xAxisMapper, StatisticsMapper yAxisMapper, SearchRequest searchRequest) {
        TwoDimensionalStatsMap statsMap = new TwoDimensionalStatsMap(xAxisMapper, yAxisMapper);
        this.populateStatsMap(searchRequest, statsMap);
        return statsMap;
    }

    private Collection<?> buildYObjects(int numberToShow, Collection<?> yAxisObjects) {
        if (numberToShow != 0 && yAxisObjects.size() > numberToShow) {
            return new ArrayList(yAxisObjects).subList(0, numberToShow);
        }
        return yAxisObjects;
    }

    private void populateStatsMap(SearchRequest searchRequest, TwoDimensionalStatsMap statsMap) {
        TwoDimensionalTermHitCollector aHitCollector = new TwoDimensionalTermHitCollector(statsMap, this.fieldVisibilityManager, this.readerCache, null, this.fieldManager);
        try {
            this.searchProvider.search(searchRequest.getQuery(), this.authenticationContext.getUser(), (Collector)aHitCollector);
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Row> makeRows(SearchRequest searchRequest, StatisticsMapper xAxisMapper, StatisticsMapper yAxisMapper, TwoDimensionalStatsMap statsMap, Collection<?> xAxisObjects, Collection<?> yAxisObjects, String yStatType) {
        Object last;
        Cell cell;
        Number totalForColumn;
        ArrayList<Cell> cells;
        Cell first;
        String searchUrl;
        ArrayList<Row> rows = new ArrayList<Row>(yAxisObjects.size());
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        for (Object yAxis : yAxisObjects) {
            Cell last2;
            ArrayList<Cell> cells2 = new ArrayList<Cell>(xAxisObjects.size());
            for (Object xAxis : xAxisObjects) {
                searchUrl = this.getStatsSearchUrlBuilder().getSearchUrlForCell(xAxis, yAxis, statsMap, searchRequest);
                Cell cell2 = new Cell(this.makeMarkupForCell(this.makeUrlForQuery(searchUrl), Integer.toString(statsMap.getCoordinate(xAxis, yAxis))));
                cells2.add(cell2);
            }
            first = new Cell(this.makeHeadingCell(yStatType, yAxis));
            if (statsMap.hasIrrelevantXData()) {
                Integer yIrrelevantCount = statsMap.getXAxisIrrelevantTotal(yAxis);
                Cell irrelevantCount = new Cell(((Object)yIrrelevantCount).toString());
                cells2.add(irrelevantCount);
            }
            Number totalForColumn2 = statsMap.getYAxisUniqueTotal(yAxis);
            if (statsMap.hasIrrelevantXData() && statsMap.getXAxisIrrelevantTotal(yAxis) > 0) {
                totalForColumn2 = totalForColumn2.longValue() + (long)statsMap.getXAxisIrrelevantTotal(yAxis);
                last2 = new Cell(totalForColumn2.toString(), CollectionBuilder.newBuilder((Object[])new String[]{"totals"}).asList());
            } else {
                String searchUrlForHeader = this.getStatsSearchUrlBuilder().getSearchUrlForHeaderCell(yAxis, yAxisMapper, searchRequest);
                String searchUrl2 = this.makeUrlForQuery(searchUrlForHeader);
                last2 = new Cell(this.makeMarkupForCell(searchUrl2, totalForColumn2.toString()), CollectionBuilder.newBuilder((Object[])new String[]{"totals"}).asList());
            }
            cells2.add(last2);
            Row row = new Row(first, cells2);
            rows.add(row);
        }
        if (statsMap.hasIrrelevantYData()) {
            cells = new ArrayList<Cell>(xAxisObjects.size());
            for (Object xAxis : xAxisObjects) {
                totalForColumn = statsMap.getYAxisIrrelevantTotal(xAxis);
                cell = new Cell(totalForColumn.toString());
                cells.add(cell);
            }
            if (statsMap.hasIrrelevantXData() && statsMap.hasIrrelevantYData()) {
                cells.add(new Cell(Long.toString(statsMap.getBothIrrelevant())));
            }
            last = new Cell(Long.toString(statsMap.getYAxisUniqueTotal(FilterStatisticsValuesGenerator.IRRELEVANT) + statsMap.getBothIrrelevant()), CollectionBuilder.newBuilder((Object[])new String[]{"totals"}).asList());
            cells.add((Cell)last);
            Cell first2 = this.getIrrelevantValueCell(i18nHelper);
            Row row = new Row(first2, cells);
            rows.add(row);
        }
        cells = new ArrayList(xAxisObjects.size());
        for (Object xAxis : xAxisObjects) {
            totalForColumn = statsMap.getXAxisUniqueTotal(xAxis);
            if (statsMap.hasIrrelevantYData() && statsMap.getYAxisIrrelevantTotal(xAxis) > 0) {
                totalForColumn = totalForColumn.longValue() + (long)statsMap.getYAxisIrrelevantTotal(xAxis);
                cell = new Cell(totalForColumn.toString(), CollectionBuilder.newBuilder((Object[])new String[]{"totals"}).asList());
            } else {
                searchUrl = this.makeUrlForQuery(this.getStatsSearchUrlBuilder().getSearchUrlForHeaderCell(xAxis, xAxisMapper, searchRequest));
                cell = new Cell(this.makeMarkupForCell(searchUrl, totalForColumn.toString()), CollectionBuilder.newBuilder((Object[])new String[]{"totals"}).asList());
            }
            cells.add(cell);
        }
        if (statsMap.hasIrrelevantXData() || statsMap.getBothIrrelevant() > 0) {
            last = new Cell(Long.toString(statsMap.getXAxisUniqueTotal(FilterStatisticsValuesGenerator.IRRELEVANT) + statsMap.getBothIrrelevant()), CollectionBuilder.newBuilder((Object[])new String[]{"totals"}).asList());
            cells.add((Cell)last);
        }
        if (!rows.isEmpty()) {
            String filterUrl = this.urlPrefix() + "?" + FILTER_PARAM + "=" + searchRequest.getId();
            Cell last3 = new Cell(this.makeMarkupForCell(filterUrl, Long.toString(statsMap.getUniqueTotal())), CollectionBuilder.newBuilder((Object[])new String[]{"totals"}).asList());
            cells.add(last3);
            first = new Cell(i18nHelper.getText("gadget.twodimensionalfilterstats.total.yaxis") + ":", CollectionBuilder.newBuilder((Object[])new String[]{"totals"}).asList());
            Row row = new Row(first, cells);
            rows.add(row);
        }
        return rows;
    }

    private Cell getIrrelevantValueCell(I18nHelper i18nHelper) {
        return new Cell("<span title=\"" + i18nHelper.getText("common.concepts.irrelevant.desc") + "\">" + i18nHelper.getText("common.concepts.irrelevant") + "</span>");
    }

    private String makeMarkupForCell(String searchUrl, String value) {
        return "<a href='" + searchUrl + "'>" + value + "</a>";
    }

    private Row makeFirstRow(String xStatType, SearchRequest searchRequest, StatisticsMapper xAxisMapper, Collection<?> xAxisObjects, boolean hasIrrelevantDataForXAxis) {
        Cell cell;
        ArrayList<Cell> headingCells = new ArrayList<Cell>(xAxisObjects.size());
        for (Object xAxis : xAxisObjects) {
            Cell cell2 = new Cell(this.makeHeadingCell(xStatType, xAxis));
            headingCells.add(cell2);
        }
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        if (hasIrrelevantDataForXAxis) {
            cell = this.getIrrelevantValueCell(i18nHelper);
            headingCells.add(cell);
        }
        if (!headingCells.isEmpty()) {
            cell = new Cell(i18nHelper.getText("gadget.twodimensionalfilterstats.total.xaxis"));
            headingCells.add(cell);
        }
        return new Row(headingCells);
    }

    private StatsMarkup makeHeadingCell(String statType, Object value) {
        return (StatsMarkup)ObjectToFieldValueMapper.transform((String)statType, (Object)value, null, this.fieldValueToDisplayTransformer);
    }

    private String makeUrlForQuery(String s) {
        return this.urlPrefix() + s;
    }

    private String urlPrefix() {
        return this.getBaseUrl() + "/issues/";
    }

    private String getBaseUrl() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
    }

    private String validateStatType(Collection<ValidationError> errors, String statType, String statTypeName) {
        String displayName = this.statisticTypesProvider.getDisplayName(statType);
        if (StringUtils.isBlank((String)displayName)) {
            errors.add(new ValidationError(statTypeName, "gadget.common.invalid.stat.type", statType));
        }
        return displayName;
    }

    private int validateNumberToShow(String fieldName, String numberToShow, Collection<ValidationError> errors) {
        try {
            int validatedNum = Integer.valueOf(numberToShow);
            if (validatedNum <= 0) {
                errors.add(new ValidationError(fieldName, "gadget.common.num.negative"));
            }
            return validatedNum;
        }
        catch (NumberFormatException e) {
            errors.add(new ValidationError(fieldName, "gadget.common.num.nan"));
            return -1;
        }
    }

    protected StatsSearchUrlBuilder getStatsSearchUrlBuilder() {
        return new DefaultStatsSearchUrlBuilder(this.searchService);
    }

    @XmlRootElement
    public static class FilterProperties {
        @XmlElement
        private String filterTitle;
        @XmlElement
        private String filterDescription;
        @XmlElement
        private String filterUrl;
        @XmlElement
        private boolean empty;

        public boolean isEmpty() {
            return this.empty;
        }

        public String getFilterTitle() {
            return this.filterTitle;
        }

        public String getFilterUrl() {
            return this.filterUrl;
        }

        public String getFilterDescription() {
            return this.filterDescription;
        }

        public FilterProperties(String filterTitle, String filterDescription, String filterUrl, boolean empty) {
            this.filterTitle = filterTitle;
            this.filterDescription = filterDescription;
            this.filterUrl = filterUrl;
            this.empty = empty;
        }

        public FilterProperties() {
        }
    }

    @XmlRootElement
    public static class Cell {
        @XmlElement
        private String markup;
        @XmlElement
        private List<String> classes;

        public Cell(String markup) {
            this.markup = markup;
        }

        public Cell(String markup, List<String> classes) {
            this.markup = markup;
            this.classes = classes;
        }

        private Cell() {
        }

        public Cell(StatsMarkup markup) {
            this.markup = markup.getHtml();
            this.classes = markup.getClasses();
        }

        public String getMarkup() {
            return this.markup;
        }

        public List<String> getClasses() {
            return this.classes;
        }
    }

    @XmlRootElement
    public static class Row {
        @XmlElement
        private List<Cell> cells;

        private Row() {
        }

        public Row(Cell first, List<Cell> otherCells) {
            this.cells = new ArrayList<Cell>();
            this.cells.add(first);
            this.cells.addAll(otherCells);
        }

        public Row(List<Cell> otherCells) {
            this.cells = new ArrayList<Cell>();
            this.cells.addAll(otherCells);
        }

        public List<Cell> getCells() {
            return this.cells;
        }
    }

    @XmlRootElement
    public static class TwoDimensionalProperties {
        @XmlElement
        private FilterProperties filter;
        @XmlElement
        private List<Row> rows;
        @XmlElement
        private Row firstRow;
        @XmlElement
        private String xHeading;
        @XmlElement
        private String yHeading;
        @XmlElement
        private int totalRows;

        private TwoDimensionalProperties() {
        }

        public TwoDimensionalProperties(FilterProperties filter, Row firstRow, List<Row> rows, String xHeading, String yHeading, int totalRows) {
            this.filter = filter;
            this.firstRow = firstRow;
            this.rows = rows;
            this.xHeading = xHeading;
            this.yHeading = yHeading;
            this.totalRows = totalRows;
        }

        public TwoDimensionalProperties(FilterProperties filter) {
            this.filter = filter;
        }

        public FilterProperties getFilter() {
            return this.filter;
        }

        public List<Row> getRows() {
            return this.rows;
        }

        public Row getFirstRow() {
            return this.firstRow;
        }

        public String getXHeading() {
            return this.xHeading;
        }

        public String getYHeading() {
            return this.yHeading;
        }

        public int getTotalRows() {
            return this.totalRows;
        }
    }
}

