/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.gadgets.system.DefaultStatsSearchUrlBuilder;
import com.atlassian.jira.gadgets.system.SearchQueryBackedResource;
import com.atlassian.jira.gadgets.system.StatisticTypesProvider;
import com.atlassian.jira.gadgets.system.StatsMarkup;
import com.atlassian.jira.gadgets.system.StatsSearchUrlBuilder;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.RedundantClausesQueryOptimizer;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.FieldValueToDisplayTransformer;
import com.atlassian.jira.issue.statistics.util.ObjectToFieldValueMapper;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@Path(value="/stats")
@AnonymousAllowed
@Produces(value={"application/json"})
public class StatsResource
extends SearchQueryBackedResource {
    private final JiraAuthenticationContext authenticationContext;
    private final SearchRequestService searchRequestService;
    private static final String STAT_TYPE = "statType";
    private final StatisticTypesProvider statisticTypesProvider;
    private final ProjectManager projectManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private FilterStatisticsValuesGenerator generator;
    private final FieldValueToDisplayTransformer<StatsMarkup> fieldValueToDisplayTransformer;

    public StatsResource(@ComponentImport ChartUtils chartUtils, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport SearchService searchService, @ComponentImport SearchRequestService searchRequestService, @ComponentImport PermissionManager permissionManager, StatisticTypesProvider statisticTypesProvider, @ComponentImport ProjectManager projectManager, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, FieldValueToDisplayTransformer<StatsMarkup> fieldValueToDisplayTransformer) {
        super(chartUtils, authenticationContext, searchService, permissionManager, velocityRequestContextFactory);
        this.authenticationContext = authenticationContext;
        this.searchRequestService = searchRequestService;
        this.statisticTypesProvider = statisticTypesProvider;
        this.projectManager = projectManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.fieldValueToDisplayTransformer = fieldValueToDisplayTransformer;
    }

    @GET
    @Path(value="validate")
    public Response validate(@QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="statType") String statType) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.getSearchRequestAndValidate(queryString, errors, params);
        this.validateStatType(errors, statType, STAT_TYPE);
        return this.createValidationResponse(errors);
    }

    private FilterStatisticsValuesGenerator getGenerator() {
        if (this.generator == null) {
            this.generator = new FilterStatisticsValuesGenerator();
        }
        return this.generator;
    }

    public void setGenerator(FilterStatisticsValuesGenerator generator) {
        this.generator = generator;
    }

    @GET
    @Path(value="generate")
    public Response getData(@QueryParam(value="projectOrFilterId") String queryString, @QueryParam(value="statType") @DefaultValue(value="assignees") String statType, @QueryParam(value="includeResolvedIssues") @DefaultValue(value="false") boolean includeResolvedIssues, @QueryParam(value="sortDirection") @DefaultValue(value="asc") String sortDirection, @QueryParam(value="sortBy") @DefaultValue(value="natural") String sortBy) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        SearchRequest originalSearchRequest = this.getSearchRequestAndValidate(queryString, errors, params);
        if (!errors.isEmpty()) {
            return this.createErrorResponse(errors);
        }
        SearchRequest searchRequest = originalSearchRequest;
        if (!includeResolvedIssues) {
            searchRequest = new SearchRequest(JqlQueryBuilder.newBuilder((Query)originalSearchRequest.getQuery()).where().defaultAnd().unresolved().buildQuery());
        }
        if (!errors.isEmpty()) {
            return this.createErrorResponse(errors);
        }
        StatisticsMapper mapper = this.getGenerator().getStatsMapper(statType);
        StatisticAccessorBean statsBean = this.getStatisticsAcessorBean(searchRequest);
        try {
            StatisticMapWrapper data = statsBean.getWrapper(mapper, StatisticAccessorBean.OrderBy.get((String)sortBy), StatisticAccessorBean.Direction.get((String)sortDirection));
            ArrayList<StatsRow> rows = new ArrayList<StatsRow>(data.entrySet().size() + 1);
            int total = 0;
            for (Integer n : data.values()) {
                total += n.intValue();
            }
            if ((total += data.getIrrelevantCount()) > 0) {
                for (Map.Entry entry : data.entrySet()) {
                    Object key = entry.getKey();
                    String searchUrlForHeader = this.getSearchUrlForHeaderCell(key, mapper, searchRequest);
                    String searchUrl = this.makeUrlForQuery(searchUrlForHeader);
                    StatsMarkup statsMarkup = (StatsMarkup)ObjectToFieldValueMapper.transform((String)statType, key, (String)searchUrl, this.fieldValueToDisplayTransformer);
                    StatsRow r = new StatsRow(statsMarkup, (int)((Integer)entry.getValue()), data.getPercentage(key), searchUrl);
                    rows.add(r);
                }
                if (data.getIrrelevantCount() > 0) {
                    StatsRow r = new StatsRow(new StatsMarkup("<span title=\"" + this.authenticationContext.getI18nHelper().getText("common.concepts.irrelevant.desc") + "\">" + this.authenticationContext.getI18nHelper().getText("common.concepts.irrelevant") + "</span>"), data.getIrrelevantCount(), data.getIrrelevantPercentage());
                    rows.add(r);
                }
            }
            Query query = searchRequest.getQuery();
            RedundantClausesQueryOptimizer optimizer = new RedundantClausesQueryOptimizer();
            String queryUrl = originalSearchRequest.getId() != null && includeResolvedIssues ? this.getBaseUrl() + this.searchService.getIssueSearchPath(this.authenticationContext.getUser(), SearchService.IssueSearchParameters.builder().filterId(originalSearchRequest.getId()).build()) : this.getBaseUrl() + this.searchService.getIssueSearchPath(this.authenticationContext.getUser(), SearchService.IssueSearchParameters.builder().query(optimizer.optimizeQuery(query)).build());
            return Response.ok((Object)new Results(rows, this.getQueryDescription(queryString), this.statisticTypesProvider.getDisplayName(statType), queryUrl, total)).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                return this.createIndexingUnavailableResponse(this.createIndexingUnavailableMessage());
            }
            throw e;
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
    }

    protected StatisticAccessorBean getStatisticsAcessorBean(SearchRequest searchRequest) {
        return new StatisticAccessorBean(this.authenticationContext.getUser(), searchRequest);
    }

    private String getQueryDescription(String projectOrFilterId) {
        if (projectOrFilterId.startsWith("filter-")) {
            Long filterId = new Long(projectOrFilterId.substring(7));
            SearchRequest sr = this.searchRequestService.getFilter((JiraServiceContext)new JiraServiceContextImpl(this.authenticationContext.getUser(), (ErrorCollection)new SimpleErrorCollection()), filterId);
            if (sr != null) {
                return sr.getName();
            }
            throw new IllegalArgumentException("Unknown filter " + filterId);
        }
        if (projectOrFilterId.startsWith("project-")) {
            Long projectId = new Long(projectOrFilterId.substring(8));
            Project project = this.projectManager.getProjectObj(projectId);
            if (project != null) {
                return project.getName();
            }
            throw new IllegalArgumentException("Unknown project " + projectId);
        }
        return "";
    }

    private String getSearchUrlForHeaderCell(Object axisObject, StatisticsMapper axisMapper, SearchRequest searchRequest) {
        return this.getHeadingUrlBuilder().getSearchUrlForHeaderCell(axisObject, axisMapper, searchRequest);
    }

    protected StatsSearchUrlBuilder getHeadingUrlBuilder() {
        return new DefaultStatsSearchUrlBuilder(this.searchService);
    }

    private String makeUrlForQuery(String s) {
        return this.urlPrefix() + s;
    }

    private String urlPrefix() {
        return this.getBaseUrl() + "/issues/";
    }

    private String getBaseUrl() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
    }

    private String validateStatType(Collection<ValidationError> errors, String statType, String statTypeName) {
        String displayName = this.statisticTypesProvider.getDisplayName(statType);
        if (StringUtils.isBlank((String)displayName)) {
            errors.add(new ValidationError(statTypeName, "gadget.common.invalid.stat.type", statType));
        }
        return displayName;
    }

    @XmlRootElement
    public static class Results {
        @XmlElement
        List<StatsRow> rows;
        @XmlElement
        String filterOrProjectName;
        @XmlElement
        String statTypeDescription;
        @XmlElement
        String filterOrProjectLink;
        @XmlElement
        int totalIssueCount;

        private Results() {
        }

        public Results(List<StatsRow> rows, String filterOrProjectName, String statTypeDescription, String filterOrProjectLink, int totalIssueCount) {
            this.rows = rows;
            this.filterOrProjectName = filterOrProjectName;
            this.statTypeDescription = statTypeDescription;
            this.filterOrProjectLink = filterOrProjectLink;
            this.totalIssueCount = totalIssueCount;
        }
    }

    @XmlRootElement
    public static class StatsRow {
        @XmlElement
        String html;
        @XmlElement
        int count;
        @XmlElement
        int percentage;
        @XmlElement
        List<String> classes;
        @XmlElement
        String url;

        private StatsRow() {
        }

        public StatsRow(String html, int count, int percentage, List<String> classes) {
            this(html, count, percentage, classes, null);
        }

        public StatsRow(StatsMarkup markup, int count, int percentage) {
            this(markup, count, percentage, null);
        }

        public StatsRow(StatsMarkup markup, int count, int percentage, String url) {
            this(markup.getHtml(), count, percentage, markup.getClasses(), url);
        }

        public StatsRow(String html, int count, int percentage, List<String> classes, String url) {
            this.classes = classes;
            this.percentage = percentage;
            this.count = count;
            this.html = html;
            this.url = url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatsRow statsRow = (StatsRow)o;
            if (this.count != statsRow.count) {
                return false;
            }
            if (this.percentage != statsRow.percentage) {
                return false;
            }
            if (this.classes != null ? !this.classes.equals(statsRow.classes) : statsRow.classes != null) {
                return false;
            }
            if (this.html != null ? !this.html.equals(statsRow.html) : statsRow.html != null) {
                return false;
            }
            return !(this.url == null ? statsRow.url != null : !this.url.equals(statsRow.url));
        }

        public int hashCode() {
            int result = this.html != null ? this.html.hashCode() : 0;
            result = 31 * result + this.count;
            result = 31 * result + this.percentage;
            result = 31 * result + (this.classes != null ? this.classes.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            return result;
        }
    }
}

